/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.financeiro.modelo.Caixa;
import br.com.maximasolutions.financeiro.repository.CaixaRepository;
import br.com.maximasolutions.financeiro.service.CaixaService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class CaixaServiceImpl
implements CaixaService {
    @Autowired
    private CaixaRepository caixaRepository;

    public Caixa save(Caixa entity) throws MaximaException {
        entity.setAtivo(Boolean.TRUE);
        entity.setUltimaAlteracao(LocalDateTime.now());
        return (Caixa)this.caixaRepository.save((Object)entity);
    }

    @Transactional(readOnly=true)
    public Caixa find(Long id) {
        Optional caixa = this.caixaRepository.findById((Object)id);
        if (caixa.isPresent()) {
            return (Caixa)caixa.get();
        }
        return null;
    }

    @Transactional(readOnly=true)
    public List<Caixa> lista() {
        return this.caixaRepository.listaAtivos();
    }

    public void incrementaNfce(Long caixaId) {
        Caixa caixa = (Caixa)this.caixaRepository.findById((Object)caixaId).get();
        caixa.setNfceNumero(Integer.valueOf(caixa.getNfceNumero() + 1));
        caixa = (Caixa)this.caixaRepository.save((Object)caixa);
        System.out.println("=== Pr\u00f3ximo NFCe: " + caixa.getNfceNumero());
    }
}

