/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.report.VendaProdutoReport;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.Conta;
import br.com.maximasolutions.financeiro.modelo.ContaExtratoTipo;
import br.com.maximasolutions.financeiro.modelo.ContaReceber;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixaExtratoTipo;
import br.com.maximasolutions.financeiro.repository.ContaExtratoRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberRepository;
import br.com.maximasolutions.financeiro.repository.ContaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentacaoEntradaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaExtratoRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.financeiro.service.MovimentacaoEntradaService;
import br.com.maximasolutions.financeiro.utils.ContaExtratoUtils;
import br.com.maximasolutions.financeiro.utils.MovimentoCaixaUtils;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.repository.ClienteRepository;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class MovimentacaoEntradaServiceImpl
implements MovimentacaoEntradaService {
    @Autowired
    private MovimentacaoEntradaRepository movimentacaoEntradaRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private MovimentoCaixaExtratoRepository movimentoCaixaExtratoRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private ContaReceberRepository contaReceberRepository;
    @Autowired
    private ContaRepository contaRepository;
    @Autowired
    private ContaExtratoRepository contaExtratoRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;

    public MovimentacaoEntrada recebimentoDireto(ContaReceber contaReceber, ContaReceberParcela contaReceberParcela, MovimentacaoEntrada movimentacaoEntrada, Boolean movimentoCaixa, Conta conta) throws MaximaValidacaoException {
        contaReceber = (ContaReceber)this.contaReceberRepository.save((Object)contaReceber);
        contaReceberParcela.setContaReceber(contaReceber);
        contaReceberParcela = (ContaReceberParcela)this.contaReceberParcelaRepository.save((Object)contaReceberParcela);
        MovimentoCaixa caixaAberto = null;
        if (movimentoCaixa.booleanValue() && (caixaAberto = this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")))) == null) {
            throw new MaximaValidacaoException("Nenhum movimento de caixa aberto.");
        }
        movimentacaoEntrada.setContaReceberParcela(contaReceberParcela);
        movimentacaoEntrada.setMovimentoCaixa(caixaAberto);
        movimentacaoEntrada.setDataOperacao(LocalDateTime.now());
        movimentacaoEntrada.setConta(conta);
        movimentacaoEntrada = (MovimentacaoEntrada)this.movimentacaoEntradaRepository.save((Object)movimentacaoEntrada);
        if (movimentoCaixa.booleanValue()) {
            caixaAberto = MovimentoCaixaUtils.addRecebimento((MovimentoCaixa)caixaAberto, (FormaPagamento)movimentacaoEntrada.getFormaPagamento(), (BigDecimal)movimentacaoEntrada.getTotal(), (Boolean)false, (Boolean)true);
            caixaAberto = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)caixaAberto);
            this.movimentoCaixaExtratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)caixaAberto, (Long)movimentacaoEntrada.getId(), (BigDecimal)movimentacaoEntrada.getTotal().multiply(new BigDecimal("-1")), (BigDecimal)caixaAberto.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.PAGAMENTO, (FormaPagamento)movimentacaoEntrada.getFormaPagamento()));
        }
        if (conta != null) {
            conta = (Conta)this.contaRepository.findById((Object)conta.getId()).get();
            conta.setSaldoAtual(conta.getSaldoAtual().subtract(movimentacaoEntrada.getTotal()));
            conta = (Conta)this.contaRepository.save((Object)conta);
            this.contaExtratoRepository.save((Object)ContaExtratoUtils.create((Conta)conta, (BigDecimal)MaximaNumber.negativa((BigDecimal)movimentacaoEntrada.getTotal()), (BigDecimal)conta.getSaldoAtual(), (Long)movimentacaoEntrada.getId(), (ContaExtratoTipo)ContaExtratoTipo.PAGAMENTO));
        }
        return movimentacaoEntrada;
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public MovimentacaoEntrada recebeParcela(ContaReceberParcela contaReceberParcela, MovimentacaoEntrada movimentacaoEntrada, Boolean movimentoCaixa, Conta conta) throws MaximaValidacaoException {
        Cliente cliente;
        MovimentoCaixa caixaAberto = null;
        if (movimentoCaixa.booleanValue() && (caixaAberto = this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")))) == null) {
            throw new MaximaValidacaoException("Nenhum movimento de caixa aberto.");
        }
        if (contaReceberParcela.getExcluido().booleanValue()) {
            throw new MaximaValidacaoException("Parcela exclu\u00edda.");
        }
        if (contaReceberParcela.isQuitado()) {
            throw new MaximaValidacaoException("Parcela com recebimento total efetuado. N\u00e3o \u00e9 poss\u00edvel efetuar recebimento.");
        }
        if (movimentacaoEntrada.getFormaPagamento().equals((Object)FormaPagamento.VALECOMPRA)) {
            cliente = (Cliente)this.clienteRepository.findById((Object)movimentacaoEntrada.getCliente().getId()).get();
            if (cliente.getVale().compareTo(movimentacaoEntrada.getTotal()) < 0) {
                throw new MaximaValidacaoException("Cliente n\u00e3o possui cr\u00e9dito para executar essa opera\u00e7\u00e3o.");
            }
            cliente.setVale(cliente.getVale().subtract(movimentacaoEntrada.getTotal()));
            this.clienteRepository.save((Object)cliente);
        }
        if (movimentacaoEntrada.getFormaPagamento().equals((Object)FormaPagamento.BONUS)) {
            cliente = (Cliente)this.clienteRepository.findById((Object)movimentacaoEntrada.getCliente().getId()).get();
            if (cliente.getBonus().compareTo(movimentacaoEntrada.getTotal()) < 0) {
                throw new MaximaValidacaoException("Cliente n\u00e3o possui cr\u00e9dito para executar essa opera\u00e7\u00e3o.");
            }
            cliente.setVale(cliente.getBonus().subtract(movimentacaoEntrada.getTotal()));
            this.clienteRepository.save((Object)cliente);
        }
        contaReceberParcela.setValorPendente(contaReceberParcela.getValorPendente().add(movimentacaoEntrada.getJuros()).subtract(movimentacaoEntrada.getDesconto()).subtract(movimentacaoEntrada.getTotal()));
        if (contaReceberParcela.getValorPendente().compareTo(BigDecimal.ZERO) < 0) {
            throw new MaximaValidacaoException("O valor pendente n\u00e3o pode ser menor que zero.");
        }
        if (contaReceberParcela.getValorPendente().compareTo(BigDecimal.ZERO) == 0) {
            contaReceberParcela.setQuitado(true);
            contaReceberParcela.setDataPagamento(movimentacaoEntrada.getDataMovimento());
        }
        this.contaReceberParcelaRepository.save((Object)contaReceberParcela);
        movimentacaoEntrada.setMovimentoCaixa(caixaAberto);
        movimentacaoEntrada.setConta(conta);
        movimentacaoEntrada.setDataOperacao(LocalDateTime.now());
        movimentacaoEntrada = (MovimentacaoEntrada)this.movimentacaoEntradaRepository.save((Object)movimentacaoEntrada);
        if (movimentoCaixa.booleanValue()) {
            caixaAberto = MovimentoCaixaUtils.addRecebimento((MovimentoCaixa)caixaAberto, (FormaPagamento)movimentacaoEntrada.getFormaPagamento(), (BigDecimal)movimentacaoEntrada.getTotal(), (Boolean)false, (Boolean)true);
            caixaAberto = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)caixaAberto);
            this.movimentoCaixaExtratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)caixaAberto, (Long)movimentacaoEntrada.getId(), (BigDecimal)movimentacaoEntrada.getTotal(), (BigDecimal)caixaAberto.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.RECEBIMENTO_EM_ABERTO, (FormaPagamento)movimentacaoEntrada.getFormaPagamento()));
        }
        if (conta != null) {
            conta = (Conta)this.contaRepository.findById((Object)conta.getId()).get();
            conta.setSaldoAtual(conta.getSaldoAtual().add(movimentacaoEntrada.getTotal()));
            conta = (Conta)this.contaRepository.save((Object)conta);
            this.contaExtratoRepository.save((Object)ContaExtratoUtils.create((Conta)conta, (BigDecimal)movimentacaoEntrada.getTotal(), (BigDecimal)conta.getSaldoAtual(), (Long)movimentacaoEntrada.getId(), (ContaExtratoTipo)ContaExtratoTipo.RECEBIMENTO));
        }
        return movimentacaoEntrada;
    }

    public void recebimentoEmLote(List<ContaReceberParcela> parcelas) throws MaximaValidacaoException {
        for (ContaReceberParcela contaReceberParcela : parcelas) {
            contaReceberParcela.setValorPendente(BigDecimal.ZERO);
            contaReceberParcela.setQuitado(true);
            contaReceberParcela = (ContaReceberParcela)this.contaReceberParcelaRepository.save((Object)contaReceberParcela);
            MovimentacaoEntrada movimentacaoEntrada = this.create(contaReceberParcela);
            this.movimentacaoEntradaRepository.save((Object)movimentacaoEntrada);
        }
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public void estorna(MovimentacaoEntrada movimentacaoEntrada) throws MaximaValidacaoException {
        Cliente cliente;
        MovimentoCaixa caixa;
        if ((movimentacaoEntrada = (MovimentacaoEntrada)this.movimentacaoEntradaRepository.findById((Object)movimentacaoEntrada.getId()).get()).getEstornada().booleanValue()) {
            throw new MaximaValidacaoException("Recebimento estornado anteriormente.");
        }
        if (this.vendaProdutoRepository.getByContaReceber(movimentacaoEntrada.getContaReceberParcela().getContaReceber().getId()) != null) {
            // empty if block
        }
        if (movimentacaoEntrada.getMovimentoCaixa() != null && !(caixa = (MovimentoCaixa)this.movimentoCaixaRepository.findById((Object)movimentacaoEntrada.getMovimentoCaixa().getId()).get()).getFechado().booleanValue()) {
            caixa = MovimentoCaixaUtils.deleteRecebimento((MovimentoCaixa)caixa, (FormaPagamento)movimentacaoEntrada.getFormaPagamento(), (BigDecimal)movimentacaoEntrada.getTotal(), (Boolean)false, (Boolean)true);
            caixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)caixa);
            this.movimentoCaixaExtratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)caixa, (Long)movimentacaoEntrada.getId(), (BigDecimal)movimentacaoEntrada.getTotal().multiply(new BigDecimal("-1")), (BigDecimal)caixa.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.RECEBIMENTO_ESTORNO, (FormaPagamento)movimentacaoEntrada.getFormaPagamento()));
        }
        if (movimentacaoEntrada.getConta() != null) {
            Conta conta = (Conta)this.contaRepository.findById((Object)movimentacaoEntrada.getConta().getId()).get();
            conta.setSaldoAtual(conta.getSaldoAtual().subtract(movimentacaoEntrada.getTotal()));
            conta = (Conta)this.contaRepository.save((Object)conta);
            this.contaExtratoRepository.save((Object)ContaExtratoUtils.create((Conta)conta, (BigDecimal)MaximaNumber.negativa((BigDecimal)movimentacaoEntrada.getTotal()), (BigDecimal)conta.getSaldoAtual(), (Long)movimentacaoEntrada.getId(), (ContaExtratoTipo)ContaExtratoTipo.RECEBIMENTO));
        }
        if (movimentacaoEntrada.getFormaPagamento().equals((Object)FormaPagamento.VALECOMPRA)) {
            cliente = (Cliente)this.clienteRepository.findById((Object)movimentacaoEntrada.getCliente().getId()).get();
            cliente.setVale(cliente.getVale().add(movimentacaoEntrada.getTotal()));
            this.clienteRepository.save((Object)cliente);
        }
        if (movimentacaoEntrada.getFormaPagamento().equals((Object)FormaPagamento.BONUS)) {
            cliente = (Cliente)this.clienteRepository.findById((Object)movimentacaoEntrada.getCliente().getId()).get();
            cliente.setVale(cliente.getBonus().add(movimentacaoEntrada.getTotal()));
            this.clienteRepository.save((Object)cliente);
        }
        movimentacaoEntrada.setEstornada(Boolean.TRUE);
        movimentacaoEntrada.setDataEstorno(LocalDateTime.now());
        movimentacaoEntrada = (MovimentacaoEntrada)this.movimentacaoEntradaRepository.save((Object)movimentacaoEntrada);
        ContaReceberParcela parcela = (ContaReceberParcela)this.contaReceberParcelaRepository.findById((Object)movimentacaoEntrada.getContaReceberParcela().getId()).get();
        parcela.setQuitado(false);
        parcela.setRecebimentoEstornado(Boolean.TRUE);
        parcela.setValorPendente(parcela.getValorPendente().add(movimentacaoEntrada.getTotal().add(movimentacaoEntrada.getDesconto()).subtract(movimentacaoEntrada.getJuros())));
        if (movimentacaoEntrada.getDireto().booleanValue()) {
            parcela.setExcluido(Boolean.valueOf(true));
            parcela.setDataExcluido(LocalDateTime.now());
        }
        this.contaReceberParcelaRepository.save((Object)parcela);
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoEntrada> list() {
        return this.movimentacaoEntradaRepository.list();
    }

    @Transactional(readOnly=true)
    public MovimentacaoEntrada load(long id) {
        return (MovimentacaoEntrada)this.movimentacaoEntradaRepository.getOne((Object)id);
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public MovimentacaoEntrada save(MovimentacaoEntrada movimentacaoEntrada) throws MaximaValidacaoException {
        return (MovimentacaoEntrada)this.movimentacaoEntradaRepository.save((Object)movimentacaoEntrada);
    }

    public void deleteById(Long id) {
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoEntrada> pesquisa(String valor) {
        return this.movimentacaoEntradaRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoEntrada> lista(LocalDate inicio, LocalDate fim, Cliente cliente) {
        if (cliente == null) {
            return this.movimentacaoEntradaRepository.lista(inicio, fim, "%%");
        }
        return this.movimentacaoEntradaRepository.lista(inicio, fim, cliente.getId());
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoEntrada> relatorio(LocalDate inicio, LocalDate fim, Cliente cliente, CentroCusto centroCusto, FormaPagamento formaPagamento) {
        return this.movimentacaoEntradaRepository.relatorio(inicio, fim, cliente, centroCusto, formaPagamento);
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoEntrada> lista(LocalDate inicio, LocalDate fim, String filtro) {
        return this.movimentacaoEntradaRepository.lista(inicio, fim, "%" + filtro + "%");
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoEntrada> lista(LocalDate inicio, LocalDate fim, String filtro, FormaPagamento formaPagamento) {
        if (formaPagamento == null) {
            return this.movimentacaoEntradaRepository.lista(inicio, fim, "%" + filtro + "%");
        }
        return this.movimentacaoEntradaRepository.lista(inicio, fim, "%" + filtro + "%", formaPagamento);
    }

    @Transactional(readOnly=true)
    public BigDecimal totalLiquido(LocalDate inicio, LocalDate fim, String filtro, FormaPagamento formaPagamento) {
        if (formaPagamento == null) {
            return this.movimentacaoEntradaRepository.totalLiquido(inicio, fim, "%" + filtro + "%");
        }
        return this.movimentacaoEntradaRepository.totalLiquido(inicio, fim, "%" + filtro + "%", formaPagamento);
    }

    @Transactional(readOnly=true)
    public BigDecimal totalBruto(LocalDate inicio, LocalDate fim, String filtro, FormaPagamento formaPagamento) {
        if (formaPagamento == null) {
            return this.movimentacaoEntradaRepository.totalBruto(inicio, fim, "%" + filtro + "%");
        }
        return this.movimentacaoEntradaRepository.totalBruto(inicio, fim, "%" + filtro + "%", formaPagamento);
    }

    private MovimentacaoEntrada create(ContaReceberParcela parc) {
        MovimentacaoEntrada rec = new MovimentacaoEntrada();
        rec.setCliente(parc.getCliente());
        rec.setContaReceberParcela(parc);
        rec.setDataEmissao(LocalDateTime.now());
        rec.setDataMovimento(parc.getDataPagamento());
        rec.setDataOperacao(LocalDateTime.now());
        rec.setDesconto(parc.getDesconto());
        rec.setEstornada(Boolean.FALSE);
        rec.setFormaPagamento(FormaPagamento.BOLETO);
        rec.setHistorico(parc.getHistorico());
        rec.setJuros(parc.getJuros());
        rec.setTotal(parc.getTotal());
        rec.setValor(parc.getValor());
        rec.setValorLiquido(parc.getTotal());
        return rec;
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoEntrada> listaPorMovimentoCaixa(MovimentoCaixa movimentoCaixa) {
        return this.movimentacaoEntradaRepository.listaPorMovimentoCaixa(movimentoCaixa.getId());
    }

    @Transactional(readOnly=true)
    public void imprimeComprovante(MovimentacaoEntrada recebimento) throws MaximaValidacaoException {
        try {
            Configuracao conf = this.configuracaoRepository.load();
            ArrayList<MovimentacaoEntrada> itens = new ArrayList<MovimentacaoEntrada>();
            itens.add(recebimento);
            String jasper = "/jasper/financeiro/movimentacaoEntrada/recebimento-comprovante.jasper";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("EMPRESA", conf.getNomeEmpresa().toUpperCase());
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(itens);
            URL web = VendaProdutoReport.class.getResource("/jasper/financeiro/movimentacaoEntrada/");
            params.put("subrel", web.toString());
            new PrintReport().showReport(jasper, (JRDataSource)jrds, params);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(MovimentacaoEntradaServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("Ops, falha ao imprimir o comprovante.");
        }
    }
}

