/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.repository.CategoriaProdutoRepository;
import br.com.maximasolutions.estoque.repository.EntradaProdutoRepository;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoFaturamentoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.financeiro.bean.MovimentoCaixaItemVendidoBean;
import br.com.maximasolutions.financeiro.bean.MovimentoCaixaRecebimentoBean;
import br.com.maximasolutions.financeiro.modelo.Caixa;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixaExtratoTipo;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixaSangria;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixaSuprimento;
import br.com.maximasolutions.financeiro.printer.MovimentoCaixaPrinter;
import br.com.maximasolutions.financeiro.repository.MovimentacaoEntradaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaExtratoRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaSangriaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaSuprimentoRepository;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.financeiro.utils.MovimentoCaixaUtils;
import br.com.maximasolutions.food.repository.MesaAbertaItemRepository;
import br.com.maximasolutions.food.repository.MesaAbertaRepository;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MovimentoCaixaServiceImpl
implements MovimentoCaixaService {
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private MovimentoCaixaExtratoRepository extratoRepository;
    @Autowired
    private MovimentoCaixaSangriaRepository sangriaRepository;
    @Autowired
    private MovimentoCaixaSuprimentoRepository suprimentoRepository;
    @Autowired
    private VendaProdutoFaturamentoRepository vendaProdutoFaturamentoRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    @Autowired
    private MovimentacaoEntradaRepository movimentacaoEntradaRepository;
    @Autowired
    private CategoriaProdutoRepository CategoriaProdutoRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private EntradaProdutoRepository entradaProdutoRepository;
    @Autowired
    private MesaAbertaRepository mesaAbertaRepository;
    @Autowired
    private MesaAbertaItemRepository mesaAbertaItemRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;

    public MovimentoCaixa inicia(MovimentoCaixa movimentoCaixa) throws MaximaException {
        MovimentoCaixa caixaAberto = this.getCaixaAberto(movimentoCaixa.getCaixa().getId().longValue());
        if (caixaAberto != null) {
            throw new MaximaException("AVISO: O caixa j\u00e1 est\u00e1 aberto.");
        }
        movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)movimentoCaixa);
        this.extratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)movimentoCaixa, (Long)movimentoCaixa.getId(), (BigDecimal)movimentoCaixa.getSaldoAbertura(), (BigDecimal)movimentoCaixa.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.ABERTURA, (FormaPagamento)FormaPagamento.DINHEIRO));
        return movimentoCaixa;
    }

    public MovimentoCaixa save(MovimentoCaixa entity) {
        entity = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)entity);
        this.extratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)entity, (Long)entity.getId(), (BigDecimal)entity.getSaldoAbertura(), (BigDecimal)entity.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.ABERTURA, (FormaPagamento)FormaPagamento.DINHEIRO));
        return entity;
    }

    public MovimentoCaixaSangria sangria(MovimentoCaixa movimentoCaixa, BigDecimal valor, FormaPagamento formaPagamento, String descricao) {
        MovimentoCaixaSangria sangria = this.getMovimentoCaixaSangria(movimentoCaixa, valor, formaPagamento, descricao);
        sangria = (MovimentoCaixaSangria)this.sangriaRepository.save((Object)sangria);
        movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.findById((Object)movimentoCaixa.getId()).get();
        movimentoCaixa.setValorEmCaixa(movimentoCaixa.getValorEmCaixa().subtract(valor));
        movimentoCaixa.setSangria(movimentoCaixa.getSangria().add(valor));
        movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)movimentoCaixa);
        this.extratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)movimentoCaixa, (Long)sangria.getId(), (BigDecimal)MaximaNumber.negativa((BigDecimal)valor), (BigDecimal)movimentoCaixa.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.SANGRIA, (FormaPagamento)formaPagamento));
        return sangria;
    }

    public MovimentoCaixa suprimento(MovimentoCaixa movimentoCaixa, BigDecimal valor, FormaPagamento formaPagamento, String descricao) {
        MovimentoCaixaSuprimento suprimento = this.getMovimentoCaixaSuprimento(movimentoCaixa, valor, formaPagamento, descricao);
        suprimento = (MovimentoCaixaSuprimento)this.suprimentoRepository.save((Object)suprimento);
        movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.findById((Object)movimentoCaixa.getId()).get();
        movimentoCaixa.setValorEmCaixa(movimentoCaixa.getValorEmCaixa().add(valor));
        movimentoCaixa.setSuprimento(movimentoCaixa.getSuprimento().add(valor));
        movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)movimentoCaixa);
        this.extratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)movimentoCaixa, (Long)suprimento.getId(), (BigDecimal)valor, (BigDecimal)movimentoCaixa.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.SUPRIMENTO, (FormaPagamento)formaPagamento));
        return movimentoCaixa;
    }

    public MovimentoCaixa update(MovimentoCaixa entity) {
        return (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)entity);
    }

    public void delete(MovimentoCaixa entity) {
        this.movimentoCaixaRepository.delete((Object)entity);
    }

    public void delete(Long id) {
        this.movimentoCaixaRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public MovimentoCaixa find(Long id) {
        return (MovimentoCaixa)this.movimentoCaixaRepository.findById((Object)id).get();
    }

    @Transactional(readOnly=true)
    public List<MovimentoCaixa> findAll() {
        return this.movimentoCaixaRepository.list();
    }

    public void deleteInBatch(List<MovimentoCaixa> users) {
        this.movimentoCaixaRepository.deleteInBatch(users);
    }

    @Transactional(readOnly=true)
    public MovimentoCaixa getCaixaAberto(long caixaid) {
        return this.movimentoCaixaRepository.getCaixaAberto(caixaid);
    }

    public void finaliza(MovimentoCaixa movimentoCaixa) throws MaximaException {
        try {
            movimentoCaixa.setDataFechamento(LocalDateTime.now());
            movimentoCaixa.setFechado(Boolean.TRUE);
            this.movimentoCaixaRepository.save((Object)movimentoCaixa);
        }
        catch (Exception e) {
            throw new MaximaException((Throwable)e);
        }
    }

    @Transactional(readOnly=true)
    public List<MovimentoCaixa> lista(LocalDateTime dataInicio, LocalDateTime dataFim, Caixa caixa) {
        if (caixa == null) {
            return new ArrayList<MovimentoCaixa>();
        }
        return this.movimentoCaixaRepository.lista(dataInicio, dataFim, caixa.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<MovimentoCaixaItemVendidoBean> itensVendidos(MovimentoCaixa movimentoCaixa, List<CategoriaProduto> categorias) {
        ArrayList<MovimentoCaixaItemVendidoBean> list = new ArrayList<MovimentoCaixaItemVendidoBean>();
        return list;
    }

    @Transactional(readOnly=true)
    public List<MovimentoCaixaRecebimentoBean> lista(MovimentoCaixa movimentoCaixa) {
        List lista = this.vendaProdutoFaturamentoRepository.listaPorCaixa(movimentoCaixa.getId());
        if (MaximaConfig.menuFood().booleanValue()) {
            lista = this.vendaProdutoFaturamentoRepository.listaPorCaixaFood(movimentoCaixa.getId());
        }
        ArrayList<MovimentoCaixaRecebimentoBean> recebimentos = new ArrayList<MovimentoCaixaRecebimentoBean>();
        lista.forEach(obj -> recebimentos.add(new MovimentoCaixaRecebimentoBean(String.valueOf(obj[0]), (BigDecimal)obj[1])));
        return recebimentos;
    }

    private MovimentoCaixaSangria getMovimentoCaixaSangria(MovimentoCaixa movimentoCaixa, BigDecimal valor, FormaPagamento formaPagamento, String descricao) {
        MovimentoCaixaSangria sangria = new MovimentoCaixaSangria();
        sangria.setCaixa(movimentoCaixa);
        sangria.setDescricao(descricao);
        sangria.setFormaPagamento(formaPagamento);
        sangria.setValor(valor);
        return sangria;
    }

    private MovimentoCaixaSuprimento getMovimentoCaixaSuprimento(MovimentoCaixa movimentoCaixa, BigDecimal valor, FormaPagamento formaPagamento, String descricao) {
        MovimentoCaixaSuprimento suprimento = new MovimentoCaixaSuprimento();
        suprimento.setCaixa(movimentoCaixa);
        suprimento.setDescricao(descricao);
        suprimento.setFormaPagamento(formaPagamento);
        suprimento.setValor(valor);
        return suprimento;
    }

    @Transactional(readOnly=true)
    public BigDecimal quantidadeVendas(MovimentoCaixa movimentoCaixa) {
        Long quantidade = this.vendaProdutoRepository.quantidadeVendasPorCaixa(movimentoCaixa.getId().longValue());
        if (quantidade == null) {
            quantidade = 0L;
        }
        return new BigDecimal(quantidade);
    }

    @Transactional(readOnly=true)
    public BigDecimal quantidadeItensVendidos(MovimentoCaixa movimentoCaixa) {
        Long quantidade = this.vendaProdutoItemRepository.quantidadeItensVendidos(movimentoCaixa.getId());
        if (quantidade == null) {
            quantidade = 0L;
        }
        return new BigDecimal(quantidade);
    }

    @Transactional(readOnly=true)
    public BigDecimal ticketVendas(MovimentoCaixa movimentoCaixa) {
        return this.vendaProdutoRepository.ticketMedioPorCaixa(movimentoCaixa.getId().longValue());
    }

    @Transactional(readOnly=true)
    public BigDecimal ticketProdutos(MovimentoCaixa movimentoCaixa) {
        return this.vendaProdutoItemRepository.ticketItensVendidos(movimentoCaixa.getId());
    }

    @Transactional(readOnly=true)
    public List<MovimentoCaixaSangria> sangrias(LocalDateTime dataInicio, LocalDateTime dataFim, String descricao) {
        if (descricao == null || descricao.isEmpty()) {
            return this.sangriaRepository.lista(dataInicio, dataFim);
        }
        return this.sangriaRepository.lista(dataInicio, dataFim, descricao);
    }

    @Transactional(readOnly=true)
    public void imprime(Long movimentoCaixaId) throws MaximaValidacaoException {
        Configuracao conf = this.configuracaoRepository.load();
        MovimentoCaixa movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.findById((Object)movimentoCaixaId).get();
        List recebimentos = this.lista(movimentoCaixa);
        List vendas = this.vendaProdutoRepository.listaPorMovimentoCaixa(movimentoCaixa.getId().longValue());
        BigDecimal valorCupons = BigDecimal.ZERO;
        Integer quantidadeCupons = 0;
        for (VendaProduto venda : vendas) {
            if (venda.getSatCFe() == null) continue;
            Integer n = quantidadeCupons;
            quantidadeCupons = quantidadeCupons + 1;
            Integer n2 = quantidadeCupons;
            valorCupons = valorCupons.add(venda.getSatCFe().getTotal());
        }
        List categorias = this.CategoriaProdutoRepository.list();
        List recebimentosCaixa = this.movimentacaoEntradaRepository.listaPorMovimentoCaixa(movimentoCaixa.getId());
        ArrayList<MovimentacaoEntrada> outrosRecebimentos = new ArrayList<MovimentacaoEntrada>();
        for (MovimentacaoEntrada rec : recebimentosCaixa) {
            boolean isVenda = false;
            for (VendaProduto vp : vendas) {
                if (vp.getContaReceber() == null || !vp.getContaReceber().getId().equals(rec.getContaReceberParcela().getContaReceber().getId()) || !rec.getFormaPagamento().equals((Object)rec.getContaReceberParcela().getFormaPagamento())) continue;
                isVenda = true;
                break;
            }
            if (isVenda) continue;
            outrosRecebimentos.add(rec);
        }
        MovimentoCaixaPrinter printer = new MovimentoCaixaPrinter();
        printer.setTotalEntradaProduto(this.entradaProdutoRepository.totalCaixa(movimentoCaixa.getId()));
        printer.setQuantidadeVendas(this.quantidadeVendas(movimentoCaixa));
        printer.setTicketMedioVenda(this.ticketVendas(movimentoCaixa));
        printer.setQuantidadeProdutos(this.quantidadeItensVendidos(movimentoCaixa));
        printer.setTicketMedioProduto(this.ticketProdutos(movimentoCaixa));
        printer.setVendas(vendas);
        printer.setValorCupons(valorCupons);
        printer.setOutrosRecebimentos(outrosRecebimentos);
        printer.setPedidosCancelados(this.pedidoRepository.pedidosCancelados(movimentoCaixaId));
        printer.setItensCancelados(this.pedidoItemRepository.listaCanceladosPorCaixa(movimentoCaixaId));
        if (MaximaConfig.menuFood().booleanValue()) {
            printer.setComandasCanceladas(this.mesaAbertaRepository.countComandasCanceladasPorCaixa(movimentoCaixaId));
            printer.setComandaItensCancelados(this.mesaAbertaItemRepository.countItensCanceladosPorCaixa(movimentoCaixaId));
        }
        printer.imprimeFechamentoCaixa(movimentoCaixa, recebimentos, categorias, this.listaProdutosPorMovimentoCaixa(movimentoCaixa), conf);
    }

    public List<MovimentoCaixaItemVendidoBean> listaProdutosPorMovimentoCaixa(MovimentoCaixa movimentoCaixa) {
        List list = this.vendaProdutoItemRepository.listaVendidos(movimentoCaixa.getId());
        ArrayList<MovimentoCaixaItemVendidoBean> retorno = new ArrayList<MovimentoCaixaItemVendidoBean>();
        list.forEach(obj -> retorno.add(new MovimentoCaixaItemVendidoBean((Long)obj[0], (String)obj[1], (BigDecimal)obj[2], new BigDecimal((Double)obj[3]), (BigDecimal)obj[4], (Long)obj[5])));
        return retorno;
    }
}

