/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.config;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.fiscal.certificado.CertificadoTipo;
import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import java.security.KeyStore;
import java.security.KeyStoreException;

public class NFeConfigMaxima
extends NFeConfig {
    private final Configuracao conf;
    public static String VERSAO_NFE = "4.00";
    private KeyStore keyStoreCertificado = null;
    private KeyStore keyStoreCadeia = null;

    public NFeConfigMaxima(Configuracao conf) {
        this.conf = conf;
    }

    public DFAmbiente getAmbiente() {
        String ambiente = MaximaConfig.getInstance().getProperty("nfambiente");
        if (ambiente == null || ambiente.isEmpty() || ambiente.equalsIgnoreCase("producao")) {
            return DFAmbiente.PRODUCAO;
        }
        return DFAmbiente.HOMOLOGACAO;
    }

    public String getCertificadoSenha() {
        return this.conf.getSenhaCertificado();
    }

    public String getCadeiaCertificadosSenha() {
        return this.conf.getSenhaCertificado();
    }

    public KeyStore getCertificadoKeyStore() throws KeyStoreException {
        return this.keyStoreCertificado;
    }

    public KeyStore getCadeiaCertificadosKeyStore() throws KeyStoreException {
        return this.keyStoreCadeia;
    }

    public DFUnidadeFederativa getCUF() {
        return DFUnidadeFederativa.valueOfCodigo((String)this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
    }

    public NFTipoEmissao getTipoEmissao() {
        return NFTipoEmissao.EMISSAO_NORMAL;
    }

    public CertificadoTipo getCertificadoTipo() {
        return CertificadoTipo.A3;
    }

    public String getCertificadoA3Senha() {
        return this.conf.getSenhaCertificado();
    }

    public int getTimeoutRequisicaoEmMillis() {
        return 60000;
    }

    public int getSoTimeoutEmMillis() {
        return 30000;
    }
}

