/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.certificado.MaximaCertificado;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.fiscal.controller.DownloadXmlController;
import br.com.maximasolutions.fiscal.modelo.ArquivoFiscal;
import br.com.maximasolutions.fiscal.service.ArquivoFiscalService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoDocumentoZip;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ArquivoFiscalController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnImporta;
    @FXML
    private Button btnDelete;
    @FXML
    private TableView<ArquivoFiscal> tabela;
    @FXML
    private TableColumn<ArquivoFiscal, String> colChaveAcesso;
    @FXML
    private TableColumn<ArquivoFiscal, String> colNota;
    @FXML
    private TableColumn<ArquivoFiscal, String> colData;
    @FXML
    private TableColumn<ArquivoFiscal, BigDecimal> colTotal;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private CheckBox ccbExcluida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ArquivoFiscalService arquivoFiscalService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private ObservableList<ArquivoFiscal> arquivoFiscalList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.arquivoFiscalList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void importaXml() {
        try {
            NFeConfigMaxima nfeConfigMaxima = new NFeConfigMaxima(this.conf);
            new MaximaCertificado().loadCertificado(this.conf.getAliasCertificado(), this.conf.getSenhaCertificado());
            NFStatusServicoConsultaRetorno retorno2 = new WSFacade((NFeConfig)nfeConfigMaxima).consultaStatus(DFUnidadeFederativa.SP, DFModelo.NFE);
            System.out.println(retorno2.getStatus());
            System.out.println(retorno2.getMotivo());
            new MaximaCertificado().loadCertificado(this.conf.getAliasCertificado(), this.conf.getSenhaCertificado());
            NFDistribuicaoIntRetorno retorno = new WSFacade((NFeConfig)nfeConfigMaxima).consultarDistribuicaoDFe(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCpf()), DFUnidadeFederativa.SP, "", MaximaUtils.completaZeroEsquerda((String)"51", (Integer)15), MaximaUtils.completaZeroEsquerda((String)"0", (Integer)15));
            if (retorno == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: N\u00e3o foi poss\u00edvel efetuar o download do arquivo.");
                return;
            }
            System.out.println("Retorno: " + retorno);
            if (!retorno.getCodigoStatusReposta().equalsIgnoreCase("138")) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel efetuar o download do arquivo.\n" + retorno.getMotivo()));
                return;
            }
            List documentos = retorno.getLote().getDocZip();
            int cont = 1;
            for (NFDistribuicaoDocumentoZip doc : documentos) {
                if (doc.getSchema().equals("resNFe_v1.01.xsd")) {
                    // empty if block
                }
                byte[] decoded = Base64.decodeBase64((byte[])doc.getValue().getBytes());
                String xml = DownloadXmlController.gZipToXml((byte[])decoded);
                MaximaFile.escreveTexto((String)("C:/Maxima/nota" + cont + ".xml"), (String)xml);
                ++cont;
            }
        }
        catch (MaximaException | IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(DownloadXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
        catch (Exception ex) {
            Logger.getLogger(DownloadXmlController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private void delete() {
        ArquivoFiscal arquivoFiscal = (ArquivoFiscal)this.tabela.getSelectionModel().getSelectedItem();
        if (arquivoFiscal == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um arquivo para remover.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja remover o arquivo?")) {
            return;
        }
        this.arquivoFiscalService.delete(arquivoFiscal);
        MaximaAlert.informe((StageManager)this.stageManager, (String)"Arquivo deletado com sucesso.");
        this.loadTabela();
    }

    private void setColumnProperties() {
        this.colNota.setCellValueFactory((Callback)new PropertyValueFactory("numero"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colChaveAcesso.setCellValueFactory((Callback)new PropertyValueFactory("chaveAcesso"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
    }

    private void loadTabela() {
        this.arquivoFiscalList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.arquivoFiscalService.lista();
        this.arquivoFiscalList.addAll((Collection)list);
        this.tabela.setItems(this.arquivoFiscalList);
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnImporta.setOnAction(event -> this.importaXml());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
    }
}

