/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.stereotype.Controller;

@Controller
public class CPFFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfCpf;
    @FXML
    private TextField tfNome;
    @FXML
    private Button btnSalva;
    private boolean finalizado;
    private String nome;
    private String cpf;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.finalizado = false;
    }

    public void inicializa() {
        this.finalizado = false;
        this.tfCpf.setText("");
        this.tfNome.setText("");
    }

    public void setCpf(String cpf) {
        this.tfCpf.setText(cpf);
    }

    public void setCliente(String cliente) {
        this.tfNome.setText(cliente);
    }

    public boolean isFinalizado() {
        return this.finalizado;
    }

    public String getNome() {
        if (this.nome == null) {
            return "";
        }
        return this.nome;
    }

    public String getCpf() {
        if (this.cpf == null) {
            return "";
        }
        return this.cpf;
    }

    private void confirma() {
        this.finalizado = true;
        this.nome = MaximaUtils.getText((String)this.tfNome.getText());
        this.cpf = MaximaUtils.removeCaracteres((String)MaximaUtils.getText((String)this.tfCpf.getText()));
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.confirma());
        this.tfCpf.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                String cpf = MaximaUtils.getText((String)this.tfCpf.getText());
                if (cpf != null && !cpf.isEmpty()) {
                    this.tfNome.requestFocus();
                } else {
                    this.confirma();
                }
            }
        });
        this.tfNome.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.confirma();
            }
        });
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }
}

