/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.controller.ConfiguracaoFiscalEntradaSaidaFormController;
import br.com.maximasolutions.fiscal.modelo.ConfiguracaoFiscalEntradaSaida;
import br.com.maximasolutions.fiscal.service.ConfiguracaoFiscalEntradaSaidaService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ConfiguracaoFiscalEntradaSaidaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<ConfiguracaoFiscalEntradaSaida> tabela;
    @FXML
    private TableColumn<ConfiguracaoFiscalEntradaSaida, String> colCfopEntrada;
    @FXML
    private TableColumn<ConfiguracaoFiscalEntradaSaida, String> colCfopSaida;
    @FXML
    private TableColumn<ConfiguracaoFiscalEntradaSaida, String> colCsosn;
    @Autowired
    private ConfiguracaoFiscalEntradaSaidaService configuracaoFiscalEntradaSaidaService;
    private ObservableList<ConfiguracaoFiscalEntradaSaida> configuracaoFiscalEntradaSaidaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.configuracaoFiscalEntradaSaidaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaConfiguracaoFiscalEntradaSaida();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void abreForm(ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/configuracaoFiscalEntradaSaida/ConfiguracaoFiscalEntradaSaidaForm.fxml", "Nova Configura\u00e7\u00e3o");
            ConfiguracaoFiscalEntradaSaidaFormController controller = (ConfiguracaoFiscalEntradaSaidaFormController)stage.getUserData();
            controller.inicializa(configuracaoFiscalEntradaSaida);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(ConfiguracaoFiscalEntradaSaidaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form tipo de configuracaoFiscalEntradaSaida.\n" + ex.getMessage()));
        }
    }

    private void novoConfiguracaoFiscalEntradaSaida() {
        this.abreForm(null);
        this.loadTabela();
    }

    private void editaConfiguracaoFiscalEntradaSaida() {
        ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida = (ConfiguracaoFiscalEntradaSaida)this.tabela.getSelectionModel().getSelectedItem();
        if (configuracaoFiscalEntradaSaida == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma configura\u00e7\u00e3o para editar.");
            return;
        }
        this.abreForm(configuracaoFiscalEntradaSaida);
        this.loadTabela();
    }

    private void deleteConfiguracaoFiscalEntradaSaida() {
        ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida = (ConfiguracaoFiscalEntradaSaida)this.tabela.getSelectionModel().getSelectedItem();
        if (configuracaoFiscalEntradaSaida == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma configuracaoFiscalEntradaSaida para remover.");
            return;
        }
        if (MaximaAlert.confirmacao((String)("Deseja remover a configura\u00e7\u00e3o: '" + configuracaoFiscalEntradaSaida.getCfopEntrada() + "'?"))) {
            this.configuracaoFiscalEntradaSaidaService.deleteById(configuracaoFiscalEntradaSaida.getId());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Configura\u00e7\u00e3o deletado com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.configuracaoFiscalEntradaSaidaList.clear();
        this.configuracaoFiscalEntradaSaidaList.addAll((Collection)this.configuracaoFiscalEntradaSaidaService.list());
        this.tabela.setItems(this.configuracaoFiscalEntradaSaidaList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colCfopEntrada.setCellValueFactory((Callback)new PropertyValueFactory("cfopEntrada"));
        this.colCfopSaida.setCellValueFactory((Callback)new PropertyValueFactory("cfopSaida"));
        this.colCsosn.setCellValueFactory((Callback)new PropertyValueFactory("csosn"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoConfiguracaoFiscalEntradaSaida());
        this.btnEdita.setOnAction(event -> this.editaConfiguracaoFiscalEntradaSaida());
        this.btnDelete.setOnAction(event -> this.deleteConfiguracaoFiscalEntradaSaida());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

