/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.modelo.ConfiguracaoFiscalEntradaSaida;
import br.com.maximasolutions.fiscal.service.ConfiguracaoFiscalEntradaSaidaService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaIPI;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ConfiguracaoFiscalEntradaSaidaFormController
extends MaximaController
implements Initializable {
    private ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoFiscalEntradaSaidaService configuracaoFiscalEntradaSaidaService;
    @FXML
    private TextField tfId;
    @FXML
    private CheckBox cbAtivo;
    @FXML
    private CheckBox cbEstoqueNegativo;
    @FXML
    private Button btnSalva;
    @FXML
    private TextField tfCfopEntrada;
    @FXML
    private TextField tfCfopSaida;
    @FXML
    private TextField tfCfopSaidaInterEstadual;
    @FXML
    private TextField tfAliquotaCreditoIcms;
    @FXML
    private TextField tfAliquotaPis;
    @FXML
    private TextField tfAliquotaCofins;
    @FXML
    private TextField tfAliquotaIpi;
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private ComboBox<NFOrigem> cbbOrigem;
    @FXML
    private ComboBox<NFNotaSituacaoOperacionalSimplesNacional> cbbCSOSN;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaPIS> cbbPis;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaCOFINS> cbbCofins;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaIPI> cbbIpi;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void salva() {
        this.configuracaoFiscalEntradaSaida = this.getConfiguracaoFiscalEntradaSaida();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.configuracaoFiscalEntradaSaida, new Class[0]);
        if (!this.validaForm()) {
            return;
        }
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return;
        }
        try {
            this.configuracaoFiscalEntradaSaidaService.save(this.configuracaoFiscalEntradaSaida);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Configura\u00e7\u00e3o salva com sucesso.");
            this.fechaForm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ConfiguracaoFiscalEntradaSaidaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private ConfiguracaoFiscalEntradaSaida getConfiguracaoFiscalEntradaSaida() {
        if (this.configuracaoFiscalEntradaSaida == null) {
            this.configuracaoFiscalEntradaSaida = new ConfiguracaoFiscalEntradaSaida();
        }
        this.configuracaoFiscalEntradaSaida.setCfopEntrada(MaximaUtils.removeCaracteres((String)this.tfCfopEntrada.getText()));
        this.configuracaoFiscalEntradaSaida.setCfopSaida(MaximaUtils.removeCaracteres((String)this.tfCfopSaida.getText()));
        this.configuracaoFiscalEntradaSaida.setCfopSaidaInterEstadual(MaximaUtils.removeCaracteres((String)this.tfCfopSaidaInterEstadual.getText()));
        this.configuracaoFiscalEntradaSaida.setAtivo(Boolean.valueOf(this.cbAtivo.isSelected()));
        this.configuracaoFiscalEntradaSaida.setOrigem((NFOrigem)this.cbbOrigem.getSelectionModel().getSelectedItem());
        this.configuracaoFiscalEntradaSaida.setCsosn((NFNotaSituacaoOperacionalSimplesNacional)this.cbbCSOSN.getSelectionModel().getSelectedItem());
        this.configuracaoFiscalEntradaSaida.setPis((NFNotaInfoSituacaoTributariaPIS)this.cbbPis.getSelectionModel().getSelectedItem());
        this.configuracaoFiscalEntradaSaida.setCofins((NFNotaInfoSituacaoTributariaCOFINS)this.cbbCofins.getSelectionModel().getSelectedItem());
        this.configuracaoFiscalEntradaSaida.setIpi((NFNotaInfoSituacaoTributariaIPI)this.cbbIpi.getSelectionModel().getSelectedItem());
        this.configuracaoFiscalEntradaSaida.setAliquotaCreditoICMS(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaCreditoIcms.getText()));
        this.configuracaoFiscalEntradaSaida.setAliquotaPis(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaPis.getText()));
        this.configuracaoFiscalEntradaSaida.setAliquotaCofins(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaCofins.getText()));
        this.configuracaoFiscalEntradaSaida.setAliquotaIpi(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaIpi.getText()));
        return this.configuracaoFiscalEntradaSaida;
    }

    public void inicializa(ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida1) {
        this.configuracaoFiscalEntradaSaida = configuracaoFiscalEntradaSaida1;
        if (this.configuracaoFiscalEntradaSaida != null) {
            this.cbAtivo.setSelected(this.configuracaoFiscalEntradaSaida.getAtivo().booleanValue());
            this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.configuracaoFiscalEntradaSaida.getUltimaAlteracao()));
            this.tfCfopEntrada.setText(this.configuracaoFiscalEntradaSaida.getCfopEntrada());
            this.tfCfopSaida.setText(this.configuracaoFiscalEntradaSaida.getCfopSaida());
            this.tfCfopSaidaInterEstadual.setText(this.configuracaoFiscalEntradaSaida.getCfopSaidaInterEstadual());
            this.cbbOrigem.getSelectionModel().select((Object)this.configuracaoFiscalEntradaSaida.getOrigem());
            this.cbbCSOSN.getSelectionModel().select((Object)this.configuracaoFiscalEntradaSaida.getCsosn());
            this.cbbPis.getSelectionModel().select((Object)this.configuracaoFiscalEntradaSaida.getPis());
            this.cbbCofins.getSelectionModel().select((Object)this.configuracaoFiscalEntradaSaida.getCofins());
            this.cbbIpi.getSelectionModel().select((Object)this.configuracaoFiscalEntradaSaida.getIpi());
            this.tfAliquotaCreditoIcms.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.configuracaoFiscalEntradaSaida.getAliquotaCreditoICMS(), (int)2));
            this.tfAliquotaPis.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.configuracaoFiscalEntradaSaida.getAliquotaPis(), (int)2));
            this.tfAliquotaCofins.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.configuracaoFiscalEntradaSaida.getAliquotaCofins(), (int)2));
            this.tfAliquotaIpi.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.configuracaoFiscalEntradaSaida.getAliquotaIpi(), (int)2));
        }
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfAliquotaCreditoIcms);
        MaximaMask.monetaryField((TextField)this.tfAliquotaPis);
        MaximaMask.monetaryField((TextField)this.tfAliquotaCofins);
        MaximaMask.monetaryField((TextField)this.tfAliquotaIpi);
    }

    private void loadCombos() {
        this.cbbOrigem.setItems(FXCollections.observableArrayList((Object[])NFOrigem.values()));
        this.cbbCSOSN.setItems(FXCollections.observableArrayList((Object[])NFNotaSituacaoOperacionalSimplesNacional.values()));
        this.cbbPis.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaPIS.values()));
        this.cbbCofins.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaCOFINS.values()));
        this.cbbIpi.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaIPI.values()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(t -> this.salva());
    }

    private boolean validaForm() {
        boolean valido = true;
        return valido;
    }
}

