/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.zip.GZIPInputStream;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class DownloadXmlController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfChaveAcesso;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
    }

    public void inicializa() {
        this.conf = this.configuracaoService.load();
        this.tfChaveAcesso.setText("");
        this.tfChaveAcesso.requestFocus();
    }

    private void downloadXml() {
    }

    private void carregaIcones() {
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void registraAcoes() {
        this.btnPesquisa.setOnAction(event -> this.downloadXml());
    }

    public static String gZipToXml(byte[] conteudo) throws IOException {
        String line;
        if (conteudo == null || conteudo.length == 0) {
            return "";
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(conteudo));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
        StringBuilder outStr = new StringBuilder();
        while ((line = bf.readLine()) != null) {
            outStr.append(line);
        }
        return outStr.toString();
    }
}

