/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.modelo.EntradaCTe;
import br.com.maximasolutions.fiscal.service.EntradaCTeService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfo;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeProcessado;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntradaCTeController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnEntradaManual;
    @FXML
    private Button btnImportaXml;
    @FXML
    private Button btnDelete;
    @FXML
    private TableView<EntradaCTe> tabela;
    @FXML
    private TableColumn<EntradaCTe, String> colFornecedor;
    @FXML
    private TableColumn<EntradaCTe, String> colNota;
    @FXML
    private TableColumn<EntradaCTe, String> colDestinatario;
    @FXML
    private TableColumn<EntradaCTe, String> colData;
    @FXML
    private TableColumn<EntradaCTe, BigDecimal> colTotal;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @FXML
    private CheckBox ccbExcluida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private EntradaCTeService entradaCTeService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    private ObservableList<EntradaCTe> entradaCTeList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.entradaCTeList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void importaXml() {
        CTeProcessado cteProcessado;
        boolean sucesso;
        if (this.conf.getCaminhoNFeEntrada() == null || this.conf.getCaminhoNFeEntrada().isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Caminho para nota fiscal de entrada n\u00e3o configurado.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
            return;
        }
        File diretorioXml = new File(this.conf.getCaminhoNFeEntrada());
        if (!diretorioXml.exists() && !(sucesso = diretorioXml.mkdir())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: Diret\u00f3rio para armazenar os XML de entrada n\u00e3o encontrado.\nN\u00e3o foi poss\u00edvel criar a pasta.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(diretorioXml);
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Nota Fiscal de Entrada", new String[]{".xml"}));
        File arquivoXml = fileChooser.showOpenDialog(this.btnImportaXml.getScene().getWindow());
        if (arquivoXml == null) {
            return;
        }
        try {
            cteProcessado = (CTeProcessado)new DFPersister().read(CTeProcessado.class, arquivoXml);
        }
        catch (Exception ex) {
            Logger.getLogger(EntradaCTeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel parsear o arquivo xml para objeto CT-e.\nVerifique se o arquivo xml \u00e9 um conhecimento de transporte eletr\u00f4nico.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
            return;
        }
        if (cteProcessado == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o foi poss\u00edvel salvar o CT-e.");
            return;
        }
        CTeNotaInfo cte = cteProcessado.getCte().getCteNotaInfo();
        EntradaCTe entradaCTe = new EntradaCTe();
        if (this.entradaCTeService.getByChaveAcesso(cte.getChaveAcesso()) != null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"CT-e j\u00e1 cadastrado no sistema.");
            return;
        }
        if (cte.getInformacoesRelativasImpostos() != null && cte.getInformacoesRelativasImpostos().getIcms() != null) {
            if (cte.getInformacoesRelativasImpostos().getIcms().getIcms00() != null) {
                entradaCTe.setAliquotaIcms(new BigDecimal(cte.getInformacoesRelativasImpostos().getIcms().getIcms00().getAliquotaICMS()));
                entradaCTe.setBaseCalculoIcms(new BigDecimal(cte.getInformacoesRelativasImpostos().getIcms().getIcms00().getBaseCalculoICMS()));
                entradaCTe.setValorIcms(new BigDecimal(cte.getInformacoesRelativasImpostos().getIcms().getIcms00().getValorICMS()));
                entradaCTe.setCst(cte.getInformacoesRelativasImpostos().getIcms().getIcms00().getCodigoSituacaoTributaria().getCodigo());
            }
            if (cte.getInformacoesRelativasImpostos().getIcms().getIcms20() != null) {
                entradaCTe.setAliquotaIcms(new BigDecimal(cte.getInformacoesRelativasImpostos().getIcms().getIcms20().getAliquotaICMS()));
                entradaCTe.setBaseCalculoIcms(new BigDecimal(cte.getInformacoesRelativasImpostos().getIcms().getIcms20().getBaseCalculoICMS()));
                entradaCTe.setValorIcms(new BigDecimal(cte.getInformacoesRelativasImpostos().getIcms().getIcms20().getValorICMS()));
                entradaCTe.setCst(cte.getInformacoesRelativasImpostos().getIcms().getIcms20().getCodigoSituacaoTributaria().getCodigo());
            }
        }
        String cfop = "1352";
        if (!cte.getDestinatario().getEndereco().getSiglaUF().equals(this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla())) {
            cfop = "2352";
        }
        entradaCTe.setCfop(cfop);
        entradaCTe.setChaveAcesso(cte.getChaveAcesso());
        entradaCTe.setCodigoMunicipioDestino(Integer.valueOf(Integer.parseInt(cte.getDestinatario().getEndereco().getCodigoMunicipio())));
        entradaCTe.setCodigoMunicipioOrigem(Integer.valueOf(Integer.parseInt(cte.getRemetente().getEndereco().getCodigoMunicipio())));
        entradaCTe.setDataEmissao(cte.getIdentificacao().getDataEmissao().toLocalDate());
        entradaCTe.setDataServico(cte.getIdentificacao().getDataEmissao().toLocalDate());
        entradaCTe.setDestinatario(cte.getDestinatario().getRazaoSocial());
        if (cte.getDestinatario().getCnpj() != null) {
            entradaCTe.setDestinatarioCnpj(cte.getDestinatario().getCnpj());
        } else {
            entradaCTe.setDestinatarioCnpj(cte.getDestinatario().getCpf());
        }
        entradaCTe.setEmitente(cte.getEmitente().getRazaoSocial());
        entradaCTe.setEmitenteBairro(cte.getEmitente().getEnderEmit().getBairro());
        entradaCTe.setEmitenteCnpj(cte.getEmitente().getCnpj());
        entradaCTe.setEmitenteCodigoIBGE(Integer.valueOf(Integer.parseInt(cte.getEmitente().getEnderEmit().getCodigoMunicipio())));
        entradaCTe.setEmitenteComplemento(cte.getEmitente().getEnderEmit().getComplemento());
        entradaCTe.setEmitenteEndereco(cte.getEmitente().getEnderEmit().getLogradouro());
        entradaCTe.setEmitenteIE(cte.getEmitente().getInscricaoEstadual());
        entradaCTe.setEmitenteNumero(cte.getEmitente().getEnderEmit().getNumero());
        entradaCTe.setExcluida(Boolean.FALSE);
        entradaCTe.setNumero(cte.getIdentificacao().getNumero());
        entradaCTe.setObservacao("");
        entradaCTe.setSerie(cte.getIdentificacao().getSerie());
        entradaCTe.setValor(new BigDecimal(cte.getValorPrestacaoServico().getValorTotalPrestacaoServico()));
        entradaCTe.setValorDesconto(BigDecimal.ZERO);
        entradaCTe.setValorNaoTribuado(BigDecimal.ZERO);
        entradaCTe.setValorServico(new BigDecimal(cte.getValorPrestacaoServico().getValorTotalPrestacaoServico()));
        this.entradaCTeService.salva(entradaCTe);
        MaximaAlert.informe((StageManager)this.stageManager, (String)"CT-e importado com sucesso.");
        this.loadTabela();
    }

    private void edita() {
        EntradaCTe entradaCTe = (EntradaCTe)this.tabela.getSelectionModel().getSelectedItem();
        if (entradaCTe == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma entrada de materiaPrima.");
            return;
        }
        if (entradaCTe.getExcluida() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Aviso: Entrada de materiaPrima j\u00e1 excluida do banco de dados.\nN\u00e3o pode ser editada.");
            return;
        }
        this.abreForm(entradaCTe);
    }

    private void entradaManual() {
        this.abreForm(null);
    }

    private void abreForm(EntradaCTe entradaCTe) {
    }

    private void delete() {
        EntradaCTe entradaCTe = (EntradaCTe)this.tabela.getSelectionModel().getSelectedItem();
        if (entradaCTe == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma entrada de materiaPrima para remover.");
            return;
        }
        if (!MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja remover a entrada de materiaPrima?")) {
            return;
        }
        this.entradaCTeService.delete(entradaCTe);
        MaximaAlert.informe((StageManager)this.stageManager, (String)"CT-e deletado com sucesso.");
        this.loadTabela();
    }

    private void setColumnProperties() {
        this.colNota.setCellValueFactory((Callback)new PropertyValueFactory("numero"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colFornecedor.setCellValueFactory((Callback)new PropertyValueFactory("emitente"));
        this.colDestinatario.setCellValueFactory((Callback)new PropertyValueFactory("destinatario"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.entradaCTeList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.entradaCTeService.lista(inicio, fim, Boolean.valueOf(this.ccbExcluida.isSelected()), filtro);
        this.entradaCTeList.addAll((Collection)list);
        this.tabela.setItems(this.entradaCTeList);
        this.lblTotal.setText("R$ " + MaximaNumber.bigDecimalToString((BigDecimal)this.entradaCTeService.totalLista(inicio, fim, Boolean.valueOf(this.ccbExcluida.isSelected()), filtro), (int)2));
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnEntradaManual.setGraphic((Node)maximaIcone.getIconeNovo());
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnEntradaManual.setOnAction(event -> this.entradaManual());
        this.btnImportaXml.setOnAction(event -> this.importaXml());
        this.btnDelete.setOnAction(event -> this.delete());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.edita();
            }
        });
    }
}

