/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.CarregaImagem;
import br.com.maximasolutions.core.Compactador;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.fiscal.controller.EnviaXmlContabilidadeController;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.modelo.NFeEvento;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.geral.modelo.Mes;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.nfe.controller.NotaFiscalController;
import br.com.maximasolutions.nfe.service.NotaFiscalService;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.service.SatCFeService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EnviaXmlContabilidadeController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFecha;
    @FXML
    private ComboBox<Mes> cbbMes;
    @FXML
    private ComboBox<Integer> cbbAno;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private NotaFiscalService notaFiscalService;
    @Autowired
    private NFCeService nFCeService;
    @Autowired
    private SatCFeService satService;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.btnSalva.setDisable(false);
        this.btnSalva.setText("Enviar");
    }

    private void confirma(Stage progress) {
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$confirma$0(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel processar a solicita\u00e7\u00e3o.");
            progress.close();
        });
        service.start();
    }

    private Integer enviaArquivosNFe(String mes, String ano, LocalDate dataInicio, LocalDate dataFinal) throws MaximaException {
        File nfeDir;
        List listaNotaFiscal = this.notaFiscalService.lista(dataInicio, dataFinal, "");
        if (listaNotaFiscal == null || listaNotaFiscal.isEmpty()) {
            return 0;
        }
        File tempDir = new File("temp");
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        if (!(nfeDir = new File(tempDir + "/nfe-" + mes + "-" + ano)).exists()) {
            nfeDir.mkdir();
        }
        for (NFeCabecalho nota : listaNotaFiscal) {
            String nomeArquivo;
            if (nota.getStatusNota().equals((Object)NFeStatus.AUTORIZADA) || nota.getStatusNota().equals((Object)NFeStatus.CANCELADA)) {
                nomeArquivo = nfeDir + "/" + nota.getChaveAcesso() + nota.getDigitoChaveAcesso() + "-NFe.xml";
                try {
                    FileOutputStream out = new FileOutputStream(nomeArquivo);
                    Object object = null;
                    try {
                        ((OutputStream)out).write(nota.getXmlTxt().getBytes("UTF-8"));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (out != null) {
                            if (object != null) {
                                try {
                                    ((OutputStream)out).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((OutputStream)out).close();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!nota.getStatusNota().equals((Object)NFeStatus.CANCELADA)) continue;
            nomeArquivo = nfeDir + "/" + nota.getChaveAcesso() + nota.getDigitoChaveAcesso() + "-NFe-Canc.xml";
            List eventos = this.notaFiscalService.listaEventos(nota);
            for (NFeEvento evento : eventos) {
                if (evento.getXmlCancelamento() == null || evento.getXmlCancelamento().isEmpty()) continue;
                try {
                    FileOutputStream out = new FileOutputStream(nomeArquivo);
                    Throwable throwable = null;
                    try {
                        ((OutputStream)out).write(evento.getXmlCancelamento().getBytes("UTF-8"));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        String caminhoAnoMes = ano + "-" + mes;
        String zipNFe = "NFe_" + caminhoAnoMes + ".zip";
        boolean retorno = new Compactador().zipar(nfeDir.getPath(), zipNFe);
        if (!retorno) {
            throw new MaximaException("Ops! Ocorreu um erro ao enviar as notas fiscais eletr\u00f4nicas.");
        }
        try {
            this.enviaArquivo(ano + "-" + mes + "-NFE", new File(zipNFe));
        }
        catch (Exception ex) {
            throw new MaximaException("Ops! Ocorreu um erro ao enviar as notas fiscais eletr\u00f4nicas.");
        }
        return listaNotaFiscal.size();
    }

    private Integer enviaArquivosNFCe(String mes, String ano, LocalDate dataInicio, LocalDate dataFinal) throws MaximaException {
        File nfeDir;
        List listaNotaFiscalConsumidor = this.nFCeService.lista(dataInicio.atStartOfDay(), dataFinal.atTime(23, 59, 59), "");
        if (listaNotaFiscalConsumidor == null || listaNotaFiscalConsumidor.isEmpty()) {
            return 0;
        }
        File tempDir = new File("temp");
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        if (!(nfeDir = new File(tempDir + "/nfce-" + mes + "-" + ano)).exists()) {
            nfeDir.mkdir();
        }
        for (NFCeCabecalho nota : listaNotaFiscalConsumidor) {
            Throwable throwable;
            FileOutputStream out;
            String nomeArquivo;
            if (nota.getStatusNota().equals((Object)NFeStatus.AUTORIZADA) || nota.getStatusNota().equals((Object)NFeStatus.CANCELADA)) {
                nomeArquivo = nfeDir + "/" + nota.getChaveAcesso() + nota.getDigitoChaveAcesso() + "-NFCe.xml";
                try {
                    out = new FileOutputStream(nomeArquivo);
                    throwable = null;
                    try {
                        ((OutputStream)out).write(nota.getXmlTxt().getBytes("UTF-8"));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)out).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((OutputStream)out).close();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!nota.getStatusNota().equals((Object)NFeStatus.CANCELADA)) continue;
            nomeArquivo = nfeDir + "/" + nota.getChaveAcesso() + nota.getDigitoChaveAcesso() + "-NFe-Canc.xml";
            try {
                out = new FileOutputStream(nomeArquivo);
                throwable = null;
                try {
                    ((OutputStream)out).write(nota.getXmlCancTxt().getBytes("UTF-8"));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        String caminhoAnoMes = ano + "-" + mes;
        String zipNFe = "NFCe_" + caminhoAnoMes + ".zip";
        boolean retorno = new Compactador().zipar(nfeDir.getPath(), zipNFe);
        if (!retorno) {
            throw new MaximaException("Ops! Ocorreu um erro ao enviar as notas fiscais consumidor eletr\u00f4nicas.");
        }
        try {
            this.enviaArquivo(ano + "-" + mes + "-NFCE", new File(zipNFe));
        }
        catch (Exception ex) {
            throw new MaximaException("Ops! Ocorreu um erro ao enviar as notas fiscais consumidor eletr\u00f4nicas.");
        }
        return listaNotaFiscalConsumidor.size();
    }

    private Integer enviaArquivosSat(String mes, String ano, LocalDate dataInicio, LocalDate dataFinal) throws MaximaException {
        File satDir;
        List listaCupomSat = this.satService.lista(dataInicio, dataFinal, "");
        if (listaCupomSat == null || listaCupomSat.isEmpty()) {
            return 0;
        }
        File tempDir = new File("temp");
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        if (!(satDir = new File(tempDir + "/sat-" + mes + "-" + ano)).exists()) {
            satDir.mkdir();
        }
        for (SatCFe nota : listaCupomSat) {
            Throwable throwable;
            FileOutputStream out;
            String nomeArquivo = satDir + "/" + nota.getChaveAcesso() + "-CFe.xml";
            try {
                out = new FileOutputStream(nomeArquivo);
                throwable = null;
                try {
                    ((OutputStream)out).write(nota.getXml().getArquivo());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!nota.getCancelado().booleanValue()) continue;
            nomeArquivo = satDir + "/" + nota.getChaveAcesso() + "-CFe-Canc.xml";
            try {
                out = new FileOutputStream(nomeArquivo);
                throwable = null;
                try {
                    ((OutputStream)out).write(nota.getXmlCancelamento().getArquivo());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        String caminhoAnoMes = ano + "-" + mes;
        String zipNFe = "SAT_" + caminhoAnoMes + ".zip";
        boolean retorno = new Compactador().zipar(satDir.getPath(), zipNFe);
        if (!retorno) {
            throw new MaximaException("Ops! Ocorreu um erro ao enviar os cupons fiscais SAT.");
        }
        try {
            this.enviaArquivo(ano + "-" + mes + "-SAT", new File(zipNFe));
        }
        catch (Exception ex) {
            throw new MaximaException("Ops! Ocorreu um erro ao enviar os cupons fiscais SAT.");
        }
        return listaCupomSat.size();
    }

    private void enviaArquivo(String nomeArquivo, File uploadFile) throws IOException, Exception {
        String requestURL = MaximaConfig.getInstance().getProperty("servidorContabilidade", "http://maximasis.com.br/controle/envia-arquivo");
        CarregaImagem multipart = new CarregaImagem(requestURL, "UTF-8");
        multipart.addHeaderField("User-Agent", "CodeJava");
        multipart.addHeaderField("Test-Header", "Header-Value");
        multipart.addFormField("chaveAcesso", MaximaConfig.getInstance().getProperty("chave"));
        multipart.addFormField("nomeArquivo", nomeArquivo);
        multipart.addFormField("tipoArquivo", "NFe");
        multipart.addFilePart("arquivo", uploadFile);
        List response = multipart.finish();
        System.out.println("SERVER REPLIED:" + response);
        String status = StringUtils.substringBetween((String)((String)response.get(0)), (String)"<status>", (String)"</status");
        if (status == null) {
            throw new Exception("Falha na comunica\u00e7\u00e3o com o servidor M\u00e1xima Solutions.");
        }
        if (!status.equals("1")) {
            throw new Exception(StringUtils.substringBetween((String)((String)response.get(0)), (String)"<motivo>", (String)"</motivo>"));
        }
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> {
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Enviando.......");
            progress.show();
            this.confirma(progress);
        });
        this.btnFecha.setOnAction(evt -> this.fechaForm());
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFecha.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void carregaCombos() {
        this.cbbMes.setItems(FXCollections.observableArrayList((Object[])Mes.values()));
        this.cbbAno.setItems(FXCollections.observableArrayList((Collection)this.listaAnos()));
    }

    private List<Integer> listaAnos() {
        ArrayList<Integer> lista = new ArrayList<Integer>();
        int anoInicial = LocalDate.now().getYear();
        lista.add(anoInicial);
        lista.add(anoInicial - 1);
        return lista;
    }

    private /* synthetic */ void lambda$confirma$0(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
            Stage form = (Stage)this.btnSalva.getScene().getWindow();
            form.close();
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ ComboBox access$000(EnviaXmlContabilidadeController x0) {
        return x0.cbbAno;
    }

    static /* synthetic */ ComboBox access$100(EnviaXmlContabilidadeController x0) {
        return x0.cbbMes;
    }

    static /* synthetic */ ConfiguracaoService access$200(EnviaXmlContabilidadeController x0) {
        return x0.configuracaoService;
    }

    static /* synthetic */ NFCeService access$300(EnviaXmlContabilidadeController x0) {
        return x0.nFCeService;
    }

    static /* synthetic */ NotaFiscalService access$400(EnviaXmlContabilidadeController x0) {
        return x0.notaFiscalService;
    }
}

