/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.fiscal.controller.EnviaXmlContabilidadeController_bck;
import br.com.maximasolutions.geral.modelo.Mes;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EnviaXmlContabilidadeController_bck
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnFecha;
    @FXML
    private ComboBox<Mes> cbbMes;
    @FXML
    private ComboBox<Integer> cbbAno;
    @Autowired
    private ConfiguracaoService configuracaoService;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.btnSalva.setDisable(false);
        this.btnSalva.setText("Enviar");
    }

    private void confirma(Stage progress) {
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$confirma$0(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel processar a solicita\u00e7\u00e3o.");
            progress.close();
        });
        service.start();
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> {
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Enviando.......");
            progress.show();
            this.confirma(progress);
        });
        this.btnFecha.setOnAction(evt -> this.fechaForm());
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnFecha.setGraphic((Node)new MaximaIcone().getIconeDelete());
    }

    private void carregaCombos() {
        this.cbbMes.setItems(FXCollections.observableArrayList((Object[])Mes.values()));
        this.cbbAno.setItems(FXCollections.observableArrayList((Collection)this.listaAnos()));
    }

    private List<Integer> listaAnos() {
        ArrayList<Integer> lista = new ArrayList<Integer>();
        int anoInicial = LocalDate.now().getYear();
        lista.add(anoInicial);
        lista.add(anoInicial - 1);
        return lista;
    }

    private /* synthetic */ void lambda$confirma$0(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
            Stage form = (Stage)this.btnSalva.getScene().getWindow();
            form.close();
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ ComboBox access$000(EnviaXmlContabilidadeController_bck x0) {
        return x0.cbbAno;
    }

    static /* synthetic */ ComboBox access$100(EnviaXmlContabilidadeController_bck x0) {
        return x0.cbbMes;
    }

    static /* synthetic */ ConfiguracaoService access$200(EnviaXmlContabilidadeController_bck x0) {
        return x0.configuracaoService;
    }
}

