/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.modelo.FiscalProduto;
import br.com.maximasolutions.fiscal.service.FiscalProdutoService;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class FiscalProdutoFormController
extends MaximaController
implements Initializable {
    @Autowired
    private FiscalProdutoService fiscalProdutoService;
    private FiscalProduto fiscalProduto;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfCodigoNcm;
    @FXML
    private TextField tfCfopDentroEstado;
    @FXML
    private TextField tfCfopForaEstado;
    @FXML
    private TextField tfAliquotaCreditoIcms;
    @FXML
    private TextField tfAliquotaIVA;
    @FXML
    private TextField tfAliquotaPis;
    @FXML
    private TextField tfAliquotaCofins;
    @FXML
    private ComboBox<NFOrigem> cbOrigem;
    @FXML
    private ComboBox<NFNotaSituacaoOperacionalSimplesNacional> cbCSOSN;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaPIS> cbPis;
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaCOFINS> cbCofins;
    @FXML
    private Button btnSalva;
    @FXML
    private AnchorPane frame;
    @Autowired
    @Lazy
    private StageManager stageManager;
    private Municipio municipio;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public FiscalProduto getFiscalProduto() {
        return this.fiscalProduto;
    }

    public void inicializa(FiscalProduto fiscalProduto) {
        this.fiscalProduto = null;
        if (fiscalProduto != null) {
            this.fiscalProduto = this.fiscalProdutoService.getById(fiscalProduto.getId());
            this.loadFiscalProduto(fiscalProduto);
        }
    }

    private void loadFiscalProduto(FiscalProduto fiscalProduto) {
        if (fiscalProduto != null) {
            this.tfId.setText(fiscalProduto.getId().toString());
            this.tfNome.setText(fiscalProduto.getNome());
            this.tfCodigoNcm.setText(fiscalProduto.getNcm());
            this.tfCfopDentroEstado.setText(fiscalProduto.getCfop());
            this.tfCfopForaEstado.setText(fiscalProduto.getCfopInterEstad());
            this.cbOrigem.getSelectionModel().select((Object)fiscalProduto.getOrigem());
            this.cbCSOSN.getSelectionModel().select((Object)fiscalProduto.getIcmsSN());
            this.cbPis.getSelectionModel().select((Object)fiscalProduto.getPis());
            this.cbCofins.getSelectionModel().select((Object)fiscalProduto.getCofins());
            this.tfAliquotaCreditoIcms.setText(MaximaNumber.bigDecimalToString((BigDecimal)fiscalProduto.getAliquotaCreditoICMS(), (int)2));
            this.tfAliquotaIVA.setText(MaximaNumber.bigDecimalToString((BigDecimal)fiscalProduto.getAliquotaIVA(), (int)2));
            this.tfAliquotaPis.setText(MaximaNumber.bigDecimalToString((BigDecimal)fiscalProduto.getAliquotaPis(), (int)2));
            this.tfAliquotaCofins.setText(MaximaNumber.bigDecimalToString((BigDecimal)fiscalProduto.getAliquotaCofins(), (int)2));
        }
    }

    private void save() {
        this.loadFiscalProduto();
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.fiscalProduto = this.fiscalProdutoService.save(this.fiscalProduto);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados do fiscalProduto salvos com sucesso.");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(FiscalProdutoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadFiscalProduto() {
        if (this.fiscalProduto == null) {
            this.fiscalProduto = new FiscalProduto();
        }
        this.fiscalProduto.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.fiscalProduto.setNcm(MaximaUtils.getText((String)this.tfCodigoNcm.getText()));
        this.fiscalProduto.setCfop(MaximaUtils.getText((String)this.tfCfopDentroEstado.getText()));
        this.fiscalProduto.setCfopInterEstad(MaximaUtils.getText((String)this.tfCfopForaEstado.getText()));
        this.fiscalProduto.setOrigem((NFOrigem)this.cbOrigem.getSelectionModel().getSelectedItem());
        this.fiscalProduto.setIcmsSN((NFNotaSituacaoOperacionalSimplesNacional)this.cbCSOSN.getSelectionModel().getSelectedItem());
        this.fiscalProduto.setPis((NFNotaInfoSituacaoTributariaPIS)this.cbPis.getSelectionModel().getSelectedItem());
        this.fiscalProduto.setCofins((NFNotaInfoSituacaoTributariaCOFINS)this.cbCofins.getSelectionModel().getSelectedItem());
        this.fiscalProduto.setAliquotaCreditoICMS(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaCreditoIcms.getText()));
        this.fiscalProduto.setAliquotaIVA(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaIVA.getText()));
        this.fiscalProduto.setAliquotaPis(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaPis.getText()));
        this.fiscalProduto.setAliquotaCofins(MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaCofins.getText()));
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadCombos() {
        this.cbOrigem.setItems(FXCollections.observableArrayList((Object[])NFOrigem.values()));
        this.cbCSOSN.setItems(FXCollections.observableArrayList((Object[])NFNotaSituacaoOperacionalSimplesNacional.values()));
        this.cbPis.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaPIS.values()));
        this.cbCofins.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoSituacaoTributariaCOFINS.values()));
    }

    private void setMascaras() {
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
    }

    private boolean validaForm() {
        boolean valido = true;
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.fiscalProduto, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }
}

