/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.dto.NcmDto;
import br.com.maximasolutions.fiscal.dto.TabelaNcmDto;
import br.com.maximasolutions.fiscal.modelo.Ncm;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.utils.MaximaUtils;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Controller
public class NcmController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Ncm> tabela;
    @FXML
    private TableColumn<Ncm, String> colNcm;
    @FXML
    private TableColumn<Ncm, String> colDescricao;
    @Autowired
    private NcmService ncmService;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void novo() {
        try {
            this.atualizaNcm();
        }
        catch (MaximaException ex) {
            Logger.getLogger(NcmController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void edita() {
    }

    public void atualizaNcm() throws MaximaException {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.99 Safari/537.36");
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange("http://maximasolutions.com.br/ncm.json", HttpMethod.GET, entity, String.class, new Object[0]);
        if (response.getStatusCodeValue() != 200) {
            throw new MaximaException("Ops, erro. Falha ao efetuar download do JSON.");
        }
        Gson gson = new Gson();
        TabelaNcmDto tabelaNcmDto = (TabelaNcmDto)gson.fromJson((String)response.getBody(), TabelaNcmDto.class);
        List itens = tabelaNcmDto.getNomenclaturas();
        if (itens != null) {
            int contador = 0;
            for (NcmDto ncmDto : itens) {
                String codigoNcm = ncmDto.getCodigo().replace(".", "");
                if (codigoNcm.length() != 8) continue;
                Ncm ncm = this.ncmService.loadByNCM(Long.parseLong(codigoNcm));
                if (ncm == null) {
                    ncm = new Ncm();
                    ncm.setAliqEstadual(new BigDecimal(18));
                    ncm.setAliqNac(new BigDecimal(13.45));
                    ncm.setAliqImp(new BigDecimal(0));
                    ncm.setAliqMunicipal(new BigDecimal(0));
                }
                ncm.setNcm(Long.valueOf(Long.parseLong(codigoNcm)));
                ncm.setDescricao(MaximaUtils.limitaTexto((String)ncmDto.getDescricao(), (int)255));
                ncm.setChave("04022022");
                ncm = this.ncmService.salva(ncm);
                System.out.println(ncm.getNcm());
                ++contador;
            }
            this.ncmService.deleteChaveDiferenteDe("04022022");
        }
    }

    private void loadTabela() {
        this.tabela.setItems(FXCollections.observableList((List)this.ncmService.lista(this.tfPesquisa.getText())));
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colNcm.setCellValueFactory((Callback)new PropertyValueFactory("ncm"));
        this.colDescricao.setCellValueFactory((Callback)new PropertyValueFactory("descricao"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novo());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.edita();
            }
        });
    }
}

