/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrima;
import br.com.maximasolutions.estoque.service.EntradaMateriaPrimaService;
import br.com.maximasolutions.estoque.service.MateriaPrimaService;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.fiscal.modelo.ConfiguracaoFiscalEntradaSaida;
import br.com.maximasolutions.fiscal.modelo.EntradaCTe;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.service.EntradaCTeService;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.nfe.service.NotaFiscalService;
import br.com.maximasolutions.sped.SpedBloco0;
import br.com.maximasolutions.sped.SpedBloco1;
import br.com.maximasolutions.sped.SpedBlocoB;
import br.com.maximasolutions.sped.SpedBlocoC;
import br.com.maximasolutions.sped.SpedBlocoD;
import br.com.maximasolutions.sped.SpedBlocoE;
import br.com.maximasolutions.sped.SpedBlocoG;
import br.com.maximasolutions.sped.SpedBlocoH;
import br.com.maximasolutions.sped.SpedBlocoK;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.swconsultoria.efd.icms.bo.GerarEfdIcms;
import br.com.swconsultoria.efd.icms.exception.EfdException;
import br.com.swconsultoria.efd.icms.registros.EfdIcms;
import br.com.swconsultoria.efd.icms.registros.blocoC.BlocoC;
import br.com.swconsultoria.efd.icms.registros.blocoE.BlocoE;
import br.com.swconsultoria.efd.icms.util.Util;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class SpedFormController
extends MaximaController
implements Initializable {
    private ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private EntradaMateriaPrimaService entradaMateriaPrimaService;
    @Autowired
    private NotaFiscalService notaFiscalService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private MateriaPrimaService materiaPrimaService;
    @Autowired
    private EntradaCTeService entradaCTeService;
    @FXML
    private Button btnSalva;
    @FXML
    private TextField tfDataInicial;
    @FXML
    private TextField tfDataFinal;
    @FXML
    private TextField tfDataArquivo;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void salva() {
        LocalDate dataInicial = MaximaDate.convertToLocalDate((String)this.tfDataInicial.getText());
        LocalDate dataFinal = MaximaDate.convertToLocalDate((String)this.tfDataFinal.getText());
        if (dataInicial == null || dataFinal == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data inicial e a data final para gera\u00e7\u00e3o do arquivo.");
            return;
        }
        if (dataInicial.isAfter(dataFinal)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data inicial deve ser anterior ou igual a data final.");
            return;
        }
        StringBuilder sb = new StringBuilder();
        EfdIcms efdIcms = new EfdIcms();
        Configuracao conf = this.configuracaoService.load();
        if (conf.getContador() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Contador n\u00e3o configurado.");
            return;
        }
        List tipoUnidadeEntrada = this.entradaMateriaPrimaService.listaSpedTipoUnidades(dataInicial, dataFinal);
        List tipoUnidadeSaida = this.notaFiscalService.listaSpedTipoUnidade(dataInicial, dataFinal);
        for (String unSaida : tipoUnidadeSaida) {
            Boolean existe = false;
            for (String unEntrada : tipoUnidadeEntrada) {
                if (!unSaida.equalsIgnoreCase(unEntrada)) continue;
                existe = true;
                break;
            }
            if (existe.booleanValue()) continue;
            tipoUnidadeEntrada.add(unSaida);
        }
        List emitentesCte = this.entradaCTeService.listaEmitenteSped(dataInicial, dataFinal);
        efdIcms.setBloco0(SpedBloco0.preencheBloco0((Configuracao)conf, (LocalDate)dataInicial, (LocalDate)dataFinal, (List)this.entradaMateriaPrimaService.listaSpedFornecedores(dataInicial, dataFinal), (List)this.notaFiscalService.listaSpedClientes(dataInicial, dataFinal), (List)tipoUnidadeEntrada, (List)this.entradaMateriaPrimaService.listaSpedMateriaPrima(dataInicial, dataFinal), (List)this.notaFiscalService.listaSpedProduto(dataInicial, dataFinal), (List)emitentesCte));
        BlocoC blocoC = SpedBlocoC.preencheBlocoC();
        List materiaPrimaLista = this.entradaMateriaPrimaService.listaSped(dataInicial, dataFinal);
        for (EntradaMateriaPrima emp : materiaPrimaLista) {
            List itens = this.entradaMateriaPrimaService.listSpedItens(emp);
            blocoC = SpedBlocoC.preencheRegistroC100((BlocoC)blocoC, (EntradaMateriaPrima)emp, (List)itens, (List)this.entradaMateriaPrimaService.listaSpedRegistro190(emp));
        }
        List notaFiscalEntradaLista = this.notaFiscalService.listaSped(dataInicial, dataFinal, NFTipo.ENTRADA);
        BigDecimal valorIcmsEntrada = BigDecimal.ZERO;
        BigDecimal valorIcmsSTEntrada = BigDecimal.ZERO;
        for (Object nfe : notaFiscalEntradaLista) {
            blocoC = SpedBlocoC.preencheRegistroC100NFEntrada((BlocoC)blocoC, (NFeCabecalho)nfe, (List)this.notaFiscalService.listaSpedRegistro190((NFeCabecalho)nfe, NFTipo.ENTRADA));
            valorIcmsEntrada = valorIcmsEntrada.add(nfe.getValorIcms());
            valorIcmsSTEntrada = valorIcmsSTEntrada.add(nfe.getValorIcmsSt());
        }
        List notaFiscalLista = this.notaFiscalService.listaSped(dataInicial, dataFinal, NFTipo.SAIDA);
        for (NFeCabecalho nfe : notaFiscalLista) {
            List itens = this.notaFiscalService.listaProdutos(nfe);
            blocoC = SpedBlocoC.preencheRegistroC100Saida((BlocoC)blocoC, (NFeCabecalho)nfe, (List)itens, (List)this.notaFiscalService.listaSpedRegistro190(nfe, NFTipo.SAIDA));
        }
        efdIcms.setBlocoB(SpedBlocoB.preencheBlocoB());
        efdIcms.setBlocoC(blocoC);
        List ctes = this.entradaCTeService.listaSped(dataInicial, dataFinal);
        efdIcms.setBlocoD(SpedBlocoD.preencheBlocoD((List)ctes));
        BigDecimal valorIcmsCte = BigDecimal.ZERO;
        for (EntradaCTe cte : ctes) {
            valorIcmsCte = valorIcmsCte.add(cte.getValorIcms());
        }
        BlocoE blocoE = SpedBlocoE.preencheBlocoE((LocalDate)dataInicial, (LocalDate)dataFinal, (BigDecimal)this.notaFiscalService.valorNotasSped(dataInicial, dataFinal, NFTipo.SAIDA), (BigDecimal)this.notaFiscalService.valorIcmsSped(dataInicial, dataFinal, NFTipo.SAIDA), (BigDecimal)this.entradaMateriaPrimaService.valorIcmsSped(dataInicial, dataFinal).add(valorIcmsEntrada), (BigDecimal)this.notaFiscalService.valorIcmsStSped(dataInicial, dataFinal, NFTipo.SAIDA).add(valorIcmsSTEntrada), (BigDecimal)valorIcmsCte);
        List estadosIcmsStSaida = this.notaFiscalService.listaUfIcmsStSped(dataInicial, dataFinal);
        for (Estado estado : estadosIcmsStSaida) {
            BigDecimal stSaida = this.notaFiscalService.valorUfIcmsStSped(dataInicial, dataFinal, estado.getSigla(), NFTipo.SAIDA);
            BigDecimal stEntrada = this.notaFiscalService.valorUfIcmsStSped(dataInicial, dataFinal, estado.getSigla(), NFTipo.ENTRADA);
            blocoE = SpedBlocoE.preencheRegistroE200((BlocoE)blocoE, (LocalDate)dataInicial, (LocalDate)dataFinal, (String)estado.getSigla(), (BigDecimal)stSaida, (BigDecimal)stEntrada);
        }
        efdIcms.setBlocoE(blocoE);
        efdIcms.setBlocoG(SpedBlocoG.preencheBlocoG());
        efdIcms.setBlocoH(SpedBlocoH.preencheBlocoH(new ArrayList(), (BigDecimal)BigDecimal.ZERO, new ArrayList()));
        efdIcms.setBlocoK(SpedBlocoK.preencheBlocoK((LocalDate)dataInicial, (LocalDate)dataFinal));
        efdIcms.setBloco1(SpedBloco1.preencheBloco1());
        sb = GerarEfdIcms.gerar((EfdIcms)efdIcms, (StringBuilder)sb);
        System.out.println(sb.toString());
        try {
            Util.criarPastaArquivo((String)"C:/Maxima/", (String)("efd_" + dataInicial.format(DateTimeFormatter.ofPattern("ddMMyyyy")) + "_" + dataFinal.format(DateTimeFormatter.ofPattern("ddMMyyyy")) + ".txt"), (String)sb.toString());
        }
        catch (EfdException ex) {
            Logger.getLogger(SpedFormController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setMascaras() {
        MaximaMask.dateField((TextField)this.tfDataInicial);
        MaximaMask.dateField((TextField)this.tfDataFinal);
        MaximaMask.dateField((TextField)this.tfDataArquivo);
    }

    private void loadCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(t -> this.salva());
    }

    private boolean validaForm() {
        boolean valido = true;
        return valido;
    }
}

