/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.fiscal.modelo.Contador;
import br.com.maximasolutions.fiscal.repository.ContadorRepository;
import br.com.maximasolutions.fiscal.service.ContadorService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class ContadorServiceImpl
implements ContadorService {
    @Autowired
    private ContadorRepository contadorRepository;

    @Transactional(readOnly=true)
    public Contador getById(Long id) {
        return (Contador)this.contadorRepository.findById((Object)id).get();
    }

    @Transactional(readOnly=true)
    public Contador getByCnpj(String cnpj) throws MaximaValidacaoException {
        List list = this.contadorRepository.getByCnpj(cnpj);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new MaximaValidacaoException("Existe mais de um contador cadastrado para o mesmo cnpj.");
        }
        return (Contador)list.get(0);
    }

    @Transactional(readOnly=true)
    public List<Contador> list(String pesquisa) {
        return this.contadorRepository.pesquisa("%" + pesquisa + "%");
    }

    public Contador save(Contador contador) throws MaximaException {
        return (Contador)this.contadorRepository.save((Object)contador);
    }

    public void delete(Contador contador) throws MaximaException {
        contador = (Contador)this.contadorRepository.getOne((Object)contador.getId());
        try {
            this.contadorRepository.delete((Object)contador);
            this.contadorRepository.flush();
        }
        catch (DataIntegrityViolationException e) {
            throw new MaximaException("Contador n\u00e3o pode ser exclu\u00eddo.\nExiste v\u00ednculos no banco de dados.");
        }
    }
}

