/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.fiscal.modelo.FiscalProduto;
import br.com.maximasolutions.fiscal.repository.FiscalProdutoRepository;
import br.com.maximasolutions.fiscal.service.FiscalProdutoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class FiscalProdutoServiceImpl
implements FiscalProdutoService {
    @Autowired
    private FiscalProdutoRepository fiscalProdutoRepository;

    @Transactional(readOnly=true)
    public FiscalProduto getById(Long id) {
        if (id == null) {
            return null;
        }
        Optional optional = this.fiscalProdutoRepository.findById((Object)id);
        if (optional.isPresent()) {
            return (FiscalProduto)optional.get();
        }
        return null;
    }

    @Transactional(readOnly=true)
    public List<FiscalProduto> list(String pesquisa) {
        return this.fiscalProdutoRepository.lista("%" + pesquisa + "%");
    }

    public FiscalProduto save(FiscalProduto fiscalProduto) throws MaximaException {
        return (FiscalProduto)this.fiscalProdutoRepository.save((Object)fiscalProduto);
    }

    public void delete(FiscalProduto fiscalProduto) throws MaximaException {
        this.fiscalProdutoRepository.delete((Object)fiscalProduto);
    }
}

