/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.food.controller.ComandaFormController;
import br.com.maximasolutions.food.controller.MesaFormController;
import br.com.maximasolutions.food.modelo.Comanda;
import br.com.maximasolutions.food.service.MesaService;
import br.com.maximasolutions.javafx.formatter.ColumnBooleanFormatter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ComandaController
extends MaximaController
implements Initializable {
    @FXML
    private Button btNovo;
    @FXML
    private Button btEdita;
    @FXML
    private Button btDelete;
    @FXML
    private Button btAtualiza;
    @FXML
    private TableView<Comanda> tabela;
    @FXML
    private TableColumn<Comanda, String> colNome;
    @FXML
    private TableColumn<Comanda, String> colMesa;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MesaService mesaService;
    private ObservableList<Comanda> mesaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.mesaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaComanda();
            }
        });
        this.setColumnProperties();
        this.registraAcoes();
    }

    public void inicializa() {
        this.loadTabela();
    }

    private void novaComanda() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/food/mesa/MesaForm.fxml", "Edi\u00e7\u00e3o de Comanda");
            MesaFormController controller = (MesaFormController)stage.getUserData();
            stage.setTitle("Cadastro de Mesa");
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ComandaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo para cadastrar nova comanda.");
        }
    }

    private void editaComanda() {
        Comanda comanda = (Comanda)this.tabela.getSelectionModel().getSelectedItem();
        if (comanda != null) {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/food/mesa/ComandaForm.fxml", "Edi\u00e7\u00e3o de Comanda");
                ComandaFormController controller = (ComandaFormController)stage.getUserData();
                controller.inicializa(comanda);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ComandaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void deleteComanda() {
        Comanda mesa = (Comanda)this.tabela.getSelectionModel().getSelectedItem();
        if (mesa != null && MaximaAlert.confirmacao((String)("Deseja remover a mesa: '" + mesa.getNome() + "'?"))) {
            this.mesaService.delete((Object)mesa);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Mesa removida com sucesso.");
        }
        this.loadTabela();
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colMesa.setCellValueFactory((Callback)new PropertyValueFactory("mesa"));
        this.colMesa.setCellFactory((Callback)new ColumnBooleanFormatter());
    }

    private void loadTabela() {
        this.mesaList.clear();
        this.mesaList.addAll((Collection)this.mesaService.findAll());
        this.tabela.setItems(this.mesaList);
    }

    private void carregaIcones() {
        this.btNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void registraAcoes() {
        this.btNovo.setOnAction(evt -> this.novaComanda());
        this.btEdita.setOnAction(evt -> this.editaComanda());
        this.btDelete.setOnAction(evt -> this.deleteComanda());
        this.btAtualiza.setOnAction(evt -> this.loadTabela());
    }
}

