/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.food.modelo.Comanda;
import br.com.maximasolutions.food.service.MesaService;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ComandaFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfNumeroComanda;
    @FXML
    private CheckBox ccbMesa;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private Button btnSalva;
    @Autowired
    private MesaService mesaService;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private Comanda comanda;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
    }

    public void inicializa(Comanda comanda) {
        this.comanda = comanda;
        this.setForm();
    }

    private void fecha() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void setForm() {
        if (this.comanda == null) {
            return;
        }
        this.tfNumeroComanda.setText(this.comanda.getNome());
        this.ccbAtivo.setSelected(this.comanda.getAtivo().booleanValue());
        this.ccbMesa.setSelected(this.comanda.getMesa().booleanValue());
    }

    private void getForm() {
        if (this.comanda == null) {
            this.comanda = new Comanda();
        }
        this.comanda.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        this.comanda.setNome(MaximaUtils.getText((String)this.tfNumeroComanda.getText()));
        this.comanda.setMesa(Boolean.valueOf(this.ccbMesa.isSelected()));
    }

    private void salva() {
        this.getForm();
        this.mesaService.save((Object)this.comanda);
        MaximaAlert.informe((StageManager)this.stageManager, (String)"Comanda alterada com sucesso.");
        this.fecha();
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(evt -> this.salva());
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }
}

