/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.food.controller.DepartamentoImpressoraFormController;
import br.com.maximasolutions.food.modelo.DepartamentoImpressora;
import br.com.maximasolutions.food.service.DepartamentoImpressoraService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class DepartamentoImpressoraController
extends MaximaController
implements Initializable {
    @FXML
    private Button btNovo;
    @FXML
    private Button btEdita;
    @FXML
    private Button btDelete;
    @FXML
    private Button btAtualiza;
    @FXML
    private TableView<DepartamentoImpressora> tabela;
    @FXML
    private TableColumn<DepartamentoImpressora, String> colNome;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private DepartamentoImpressoraService departamentoImpressoraService;
    private ObservableList<DepartamentoImpressora> departamentoImpressoraList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.departamentoImpressoraList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaDepartamentoImpressora();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
    }

    @FXML
    private void edita(ActionEvent event) {
        this.editaDepartamentoImpressora();
    }

    @FXML
    private void delete(ActionEvent event) {
        DepartamentoImpressora departamentoImpressora = (DepartamentoImpressora)this.tabela.getSelectionModel().getSelectedItem();
        if (departamentoImpressora != null && MaximaAlert.confirmacao((String)("Deseja remover o departamento: '" + departamentoImpressora.getNome() + "'?"))) {
            this.departamentoImpressoraService.delete((Object)departamentoImpressora);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Departamento removido com sucesso.");
        }
        this.loadTabela();
    }

    @FXML
    private void atualiza(ActionEvent event) {
        this.loadTabela();
    }

    @FXML
    private void novo(ActionEvent event) throws IOException {
        Stage stage = this.createWindowForm();
        DepartamentoImpressoraFormController controller = (DepartamentoImpressoraFormController)stage.getUserData();
        controller.setDepartamentoImpressora(null);
        stage.setTitle("Cadastro de Departamento/Impressora");
        stage.showAndWait();
        this.loadTabela();
    }

    private void editaDepartamentoImpressora() {
        DepartamentoImpressora departamentoImpressora = (DepartamentoImpressora)this.tabela.getSelectionModel().getSelectedItem();
        if (departamentoImpressora != null) {
            try {
                Stage stage = this.createWindowForm();
                DepartamentoImpressoraFormController controller = (DepartamentoImpressoraFormController)stage.getUserData();
                controller.setDepartamentoImpressora(departamentoImpressora);
                stage.setTitle("Edi\u00e7\u00e3o de Departamento/Impressora");
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(DepartamentoImpressoraController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Stage createWindowForm() throws IOException {
        FXMLLoader loader = this.stageManager.loader("/fxml/food/departamentoImpressora/DepartamentoImpressoraForm.fxml");
        AnchorPane content = (AnchorPane)loader.load();
        Scene scene = new Scene((Parent)content);
        DepartamentoImpressoraFormController controller = (DepartamentoImpressoraFormController)loader.getController();
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setUserData((Object)controller);
        stage.initStyle(StageStyle.DECORATED);
        stage.initOwner((Window)this.stageManager.getStage());
        stage.setScene(scene);
        return stage;
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
    }

    private void loadTabela() {
        this.departamentoImpressoraList.clear();
        this.departamentoImpressoraList.addAll((Collection)this.departamentoImpressoraService.findAll());
        this.tabela.setItems(this.departamentoImpressoraList);
    }

    private void carregaIcones() {
        this.btNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }
}

