/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.food.controller.ComandaController;
import br.com.maximasolutions.food.controller.GarcomFormController;
import br.com.maximasolutions.food.modelo.Garcon;
import br.com.maximasolutions.food.service.GarcomService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class GarcomController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    GarcomService garcomService;
    @FXML
    TableView<Garcon> tabela;
    @FXML
    TableColumn<Garcon, String> colNome;
    @FXML
    TableColumn<Garcon, String> colTelefone;
    @FXML
    Button btNovo;
    @FXML
    Button btEdita;
    @FXML
    Button btDelete;
    @FXML
    Button btAtualiza;
    @FXML
    Button btnPesquisa;
    @FXML
    TextField tfPesquisa;
    @FXML
    CheckBox ccbAtivo;
    ObservableList<Garcon> garcomList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcone();
        this.registraAcoes();
        this.garcomList = FXCollections.observableArrayList();
        this.setColumnProperties();
    }

    public void inicializa() {
        this.loadTabela();
    }

    public void carregaIcone() {
        this.btNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
        this.btEdita.setGraphic((Node)new MaximaIcone().edita());
    }

    private void novo() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/food/garcom/GarcomForm.fxml", "Edi\u00e7\u00e3o de Gar\u00e7om");
            GarcomFormController controller = (GarcomFormController)stage.getUserData();
            controller.inicializa(null);
            stage.setTitle("Cadastro de Gar\u00e7om");
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ComandaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo para cadastrar novo Gar\u00e7om.");
        }
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colTelefone.setCellValueFactory((Callback)new PropertyValueFactory("telefone"));
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.garcomList.clear();
        this.garcomList.addAll((Collection)this.garcomService.listaPorNome(valorPesquisa, this.ccbAtivo.isSelected()));
        this.tabela.setItems(this.garcomList);
    }

    private void editaGarcom() {
        Garcon garcom = (Garcon)this.tabela.getSelectionModel().getSelectedItem();
        if (garcom != null) {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/food/garcom/GarcomForm.fxml", "Edi\u00e7\u00e3o de Gar\u00e7om");
                GarcomFormController controller = (GarcomFormController)stage.getUserData();
                controller.inicializa(garcom);
                stage.setTitle("Cadastro de Gar\u00e7om");
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ComandaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void deleteGarcom() {
        Garcon garcom = (Garcon)this.tabela.getSelectionModel().getSelectedItem();
        if (garcom != null && MaximaAlert.confirmacao((String)("Deseja remover o gar\u00e7om: '" + garcom.getNome() + "'?"))) {
            garcom.setAtivo(Boolean.FALSE);
            this.garcomService.save((Object)garcom);
        }
        this.loadTabela();
    }

    private void registraAcoes() {
        this.btNovo.setOnAction(event -> this.novo());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaGarcom();
            }
        });
        this.btAtualiza.setOnAction(evt -> this.loadTabela());
        this.btEdita.setOnAction(evt -> this.editaGarcom());
        this.btDelete.setOnAction(evt -> this.deleteGarcom());
        this.btnPesquisa.setOnAction(evt -> this.loadTabela());
    }
}

