/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.food.modelo.Comanda;
import br.com.maximasolutions.food.service.MesaService;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MesaFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfQuantidade;
    @FXML
    private TextField tfNumeroInicial;
    @FXML
    private TextField tfDigitos;
    @FXML
    private CheckBox ccbMesa;
    @FXML
    private Button btnSalva;
    private Comanda mesa;
    @Autowired
    private MesaService mesaService;
    @Lazy
    @Autowired
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
    }

    public void inicializa() {
        this.tfQuantidade.setText("");
        this.tfNumeroInicial.setText("");
        this.tfDigitos.setText("3");
        this.ccbMesa.setSelected(true);
    }

    private void fecha() {
        Stage stage = (Stage)this.tfQuantidade.getScene().getWindow();
        stage.close();
    }

    private void salva() {
        Integer quantidade = null;
        Integer numeroInicial = null;
        Integer digitos = null;
        try {
            quantidade = Integer.parseInt(this.tfQuantidade.getText());
            numeroInicial = Integer.parseInt(this.tfNumeroInicial.getText());
            digitos = Integer.parseInt(this.tfDigitos.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe um n\u00famero inteiro v\u00e1lido.");
            return;
        }
        try {
            this.mesaService.geraComandas(quantidade.intValue(), numeroInicial.intValue(), digitos.intValue(), this.ccbMesa.isSelected());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Comandas geradas com sucesso.");
            this.fecha();
        }
        catch (MaximaException ex) {
            Logger.getLogger(MesaFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Erro ao gerar as comandas.\n" + ex.getMessage()));
        }
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(evt -> this.salva());
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }
}

