/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.food.modelo.Comanda;
import br.com.maximasolutions.food.repository.MesaRepository;
import br.com.maximasolutions.food.service.MesaService;
import br.com.maximasolutions.utils.MaximaUtils;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class MesaServiceImpl
implements MesaService {
    @Autowired
    private MesaRepository mesaRepository;

    public Comanda save(Comanda entity) {
        if (entity.getId() == null) {
            entity.setOcupado(Boolean.FALSE);
            entity.setAtivo(Boolean.TRUE);
        } else {
            Comanda mesaAberta = (Comanda)this.mesaRepository.findById((Object)entity.getId()).get();
            entity.setOcupado(mesaAberta.getOcupado());
            entity.setImpresso(mesaAberta.getImpresso());
            entity.setResponsavel(mesaAberta.getResponsavel());
        }
        entity.setUltimaAlteracao(LocalDateTime.now());
        return (Comanda)this.mesaRepository.save((Object)entity);
    }

    public Comanda update(Comanda entity) {
        entity.setUltimaAlteracao(LocalDateTime.now());
        return (Comanda)this.mesaRepository.save((Object)entity);
    }

    public void delete(Comanda entity) {
        this.mesaRepository.delete((Object)entity);
    }

    public void delete(Long id) {
        this.mesaRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public Comanda find(Long id) {
        return (Comanda)this.mesaRepository.findById((Object)id).get();
    }

    @Transactional(readOnly=true)
    public List<Comanda> findAll() {
        return this.mesaRepository.findAll();
    }

    public void deleteInBatch(List<Comanda> users) {
        this.mesaRepository.deleteInBatch(users);
    }

    public void geraComandas(int quantidade, int numeroInicial, int digitos, boolean mesa) throws MaximaException {
        for (int i = 1; i <= quantidade; ++i) {
            String nome = MaximaUtils.completaZeroEsquerda((String)String.valueOf(numeroInicial), (Integer)digitos);
            if (!this.mesaRepository.listaPorNome(nome).isEmpty()) {
                throw new MaximaException("N\u00e3o \u00e9 poss\u00edvel cadastrar mesas a partir do n\u00famero inicial informado.\nComanda [ " + nome + " ] j\u00e1 cadastrada no sistema.");
            }
            Comanda comanda = new Comanda();
            comanda.setNome(nome);
            comanda.setAtivo(Boolean.TRUE);
            comanda.setImpresso(Boolean.FALSE);
            comanda.setOcupado(Boolean.FALSE);
            comanda.setResponsavel("");
            comanda.setUltimaAlteracao(LocalDateTime.now());
            comanda.setMesa(Boolean.valueOf(mesa));
            this.mesaRepository.save((Object)comanda);
            ++numeroInicial;
        }
    }

    public List<Comanda> listaOcupadas() {
        return this.mesaRepository.listaComandasOcupadas();
    }

    @Transactional(readOnly=true)
    public List<Comanda> listaOcupadasOrderEmissao() {
        return this.mesaRepository.listaComandasOcupadasOrderEmissao();
    }
}

