/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.ClienteFormController;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ClienteController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private TableView<Cliente> tabela;
    @FXML
    private TableColumn<Cliente, String> colCnpj;
    @FXML
    private TableColumn<Cliente, String> colNome;
    @FXML
    private TableColumn<Cliente, String> colEndereco;
    @FXML
    private TableColumn<Cliente, String> colTelefone;
    @FXML
    private TableColumn<Cliente, String> colCidade;
    @FXML
    private TableColumn<Cliente, Long> colId;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Cliente> clienteList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.clienteList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaCliente();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Cliente);
    }

    private void novoCliente() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formCliente(null);
        this.loadTabela();
    }

    private void editaCliente() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Cliente cliente = (Cliente)this.tabela.getSelectionModel().getSelectedItem();
        if (cliente == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um cliente para editar.");
            return;
        }
        this.formCliente(cliente);
        this.loadTabela();
    }

    private void formCliente(Cliente cliente) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/cliente/ClienteForm.fxml", "Edita Cliente");
            ClienteFormController controller = (ClienteFormController)stage.getUserData();
            controller.inicializa(cliente);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(ClienteController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form cliente.\n" + ex.getMessage()));
        }
    }

    private void deleteCliente() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Cliente cliente = (Cliente)this.tabela.getSelectionModel().getSelectedItem();
        if (cliente == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um cliente para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o cliente: '" + cliente.getNome() + "'?"))) {
            try {
                this.clienteService.delete(cliente);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Cliente deletado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaException ex) {
                Logger.getLogger(ClienteController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void loadTabela() {
        this.clienteList.clear();
        this.clienteList.addAll((Collection)this.clienteService.list(this.tfPesquisa.getText().trim(), Boolean.valueOf(this.ccbAtivo.isSelected())));
        this.tabela.setItems(this.clienteList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colCnpj.setCellValueFactory((Callback)new PropertyValueFactory("cpf"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colEndereco.setCellValueFactory((Callback)new PropertyValueFactory("enderecoNumeroBairro"));
        this.colTelefone.setCellValueFactory((Callback)new PropertyValueFactory("telefone"));
        this.colCidade.setCellValueFactory((Callback)new PropertyValueFactory("municipio"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoCliente());
        this.btnEdita.setOnAction(event -> this.editaCliente());
        this.btnDelete.setOnAction(event -> this.deleteCliente());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

