/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.MunicipioPesquisaController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.service.FornecedorService;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import java.io.IOException;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class FornecedorFormController
extends MaximaController
implements Initializable {
    @Autowired
    private FornecedorService fornecedorService;
    @Autowired
    private MunicipioService municipioService;
    private Fornecedor fornecedor;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfRazaoSocial;
    @FXML
    private TextField tfNomeFantasia;
    @FXML
    private TextField tfCnpj;
    @FXML
    private TextField tfInscEstadual;
    @FXML
    private TextField tfEndereco;
    @FXML
    private TextField tfEnderecoNumero;
    @FXML
    private TextField tfBairro;
    @FXML
    private TextField tfCep;
    @FXML
    private TextField tfTelefone;
    @FXML
    private TextField tfTelefone2;
    @FXML
    private TextField tfComplemento;
    @FXML
    private TextField tfEmail;
    @FXML
    private TextField tfDataNascimento;
    @FXML
    private TextField tfMunicipioCodigo;
    @FXML
    private TextField tfMunicipioDescricao;
    @FXML
    private TextArea tfObservacao;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnMunicipio;
    @FXML
    private AnchorPane frame;
    @Autowired
    @Lazy
    private StageManager stageManager;
    private Municipio municipio;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public Fornecedor getFornecedor() {
        return this.fornecedor;
    }

    public void inicializa() {
        this.municipio = null;
        this.fornecedor = null;
    }

    public void inicializa(Fornecedor fornecedor) {
        if (fornecedor != null && fornecedor.getId() != null) {
            this.fornecedor = this.fornecedorService.getById(fornecedor.getId());
            this.loadFornecedor(fornecedor);
        }
    }

    private void loadFornecedor(Fornecedor fornecedor) {
        if (fornecedor != null) {
            this.tfId.setText(fornecedor.getId().toString());
            this.tfRazaoSocial.setText(fornecedor.getNome());
            this.tfNomeFantasia.setText(fornecedor.getFantasia());
            this.tfTelefone.setText(fornecedor.getTelefone());
            this.tfTelefone2.setText(fornecedor.getCelular1());
            this.tfCnpj.setText(fornecedor.getCpf());
            this.tfInscEstadual.setText(fornecedor.getRg());
            this.tfDataNascimento.setText(fornecedor.getDataNascimento() == null ? "" : fornecedor.getDataNascimento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            this.tfEndereco.setText(fornecedor.getEndereco());
            this.tfEnderecoNumero.setText(fornecedor.getNumero());
            this.tfBairro.setText(fornecedor.getBairro());
            this.tfComplemento.setText(fornecedor.getComplemento());
            this.tfCep.setText(fornecedor.getCep());
            this.municipio = fornecedor.getMunicipio();
            this.tfEmail.setText(fornecedor.getEmail());
            this.tfObservacao.setText(fornecedor.getObservacao());
            this.tfMunicipioCodigo.setText(fornecedor.getMunicipio().getId().toString());
            this.tfMunicipioDescricao.setText(fornecedor.getMunicipio().getNome() + " - " + fornecedor.getMunicipio().getEstado().getSigla());
        }
    }

    private void save() {
        this.loadFornecedor();
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.fornecedor = this.fornecedorService.save(this.fornecedor);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados do fornecedor salvos com sucesso.");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(FornecedorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadFornecedor() {
        if (this.fornecedor == null) {
            this.fornecedor = new Fornecedor();
        }
        this.fornecedor.setAtivo(Boolean.TRUE);
        this.fornecedor.setNome(MaximaUtils.getText((String)this.tfRazaoSocial.getText()));
        this.fornecedor.setFantasia(MaximaUtils.getText((String)this.tfNomeFantasia.getText()));
        this.fornecedor.setTelefone(MaximaUtils.removeCaracteres((String)this.tfTelefone.getText()));
        this.fornecedor.setCelular1(MaximaUtils.removeCaracteres((String)this.tfTelefone2.getText()));
        this.fornecedor.setCpf(MaximaUtils.removeCaracteres((String)this.tfCnpj.getText()));
        this.fornecedor.setRg(MaximaUtils.removeAcentos((String)this.tfInscEstadual.getText()));
        this.fornecedor.setDataNascimento(MaximaDate.convertToLocalDate((String)this.tfDataNascimento.getText()));
        this.fornecedor.setEndereco(MaximaUtils.getText((String)this.tfEndereco.getText()));
        this.fornecedor.setNumero(MaximaUtils.getText((String)this.tfEnderecoNumero.getText()));
        this.fornecedor.setBairro(MaximaUtils.getText((String)this.tfBairro.getText()));
        this.fornecedor.setComplemento(MaximaUtils.getText((String)this.tfComplemento.getText()));
        this.fornecedor.setCep(MaximaUtils.removeCaracteres((String)this.tfCep.getText()));
        this.fornecedor.setMunicipio(this.municipio);
        this.fornecedor.setEmail(MaximaUtils.getText((String)this.tfEmail.getText()));
        this.fornecedor.setObservacao(this.tfObservacao.getText());
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadCombos() {
    }

    private void setMascaras() {
        MaximaMask.cnpjField((TextField)this.tfCnpj);
        MaximaMask.dateField((TextField)this.tfDataNascimento);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
        this.btnMunicipio.setOnAction(event -> this.pesquisaMunicipioForm());
        this.tfMunicipioCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMunicipio();
            }
        });
    }

    private void pesquisaMunicipio() {
        String municipioCodigo = this.tfMunicipioCodigo.getText().trim();
        if (municipioCodigo.isEmpty()) {
            return;
        }
        try {
            Long municipioCodigoNumero = Long.valueOf(municipioCodigo);
            Municipio municipioPesquisa = this.municipioService.load(municipioCodigoNumero.longValue());
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaMunicipioForm();
    }

    private void pesquisaMunicipioForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioPesquisa.fxml", "Pesquisa de cidades");
            MunicipioPesquisaController controller = (MunicipioPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMunicipioCodigo.getText().trim());
            stage.showAndWait();
            Municipio municipioPesquisa = controller.getMunicipioSelecionado();
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosMunicipio() {
        if (this.municipio != null) {
            this.tfMunicipioCodigo.setText(this.municipio.getId().toString());
            this.tfMunicipioDescricao.setText(this.municipio.getNome().toUpperCase() + " - " + this.municipio.getEstado().getSigla());
            this.tfEmail.requestFocus();
        } else {
            this.tfMunicipioCodigo.setText("");
            this.tfMunicipioDescricao.setText("");
            this.tfMunicipioCodigo.requestFocus();
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.fornecedor.getNome() == null || this.fornecedor.getNome().isEmpty()) {
            this.tfRazaoSocial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfRazaoSocial.getStyleClass().remove((Object)"error");
        }
        if (this.fornecedor.getTelefone() == null || this.fornecedor.getTelefone().isEmpty()) {
            valido = false;
            this.tfTelefone.getStyleClass().add((Object)"error");
        } else {
            this.tfTelefone.getStyleClass().remove((Object)"error");
        }
        if (this.fornecedor.getMunicipio() == null) {
            valido = false;
            this.tfMunicipioCodigo.getStyleClass().add((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().add((Object)"error");
        } else {
            this.tfMunicipioCodigo.getStyleClass().remove((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.fornecedor, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }
}

