/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.FornecedorFormController;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.service.FornecedorService;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class FornecedorPesquisaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnSelecionar;
    @FXML
    private Button btnNovo;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Fornecedor> tabela;
    @FXML
    private TableColumn<Fornecedor, String> colNome;
    @FXML
    private TableColumn<Fornecedor, String> colEndereco;
    @FXML
    private TableColumn<Fornecedor, String> colCidade;
    @FXML
    private TableColumn<Fornecedor, String> colTelefone;
    @Autowired
    private FornecedorService fornecedorService;
    private ObservableList<Fornecedor> fornecedorList;
    private Fornecedor fornecedorSelecionado;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.fornecedorList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
    }

    private void novo() {
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/fornecedor/FornecedorForm.fxml", "Cadastro de Fornecedor");
            FornecedorFormController controller = (FornecedorFormController)form.getUserData();
            controller.inicializa(null);
            form.showAndWait();
            if (controller.getFornecedor() != null && controller.getFornecedor().getId() != null) {
                this.tfPesquisa.setText(controller.getFornecedor().getNome());
                this.loadTabela();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FornecedorPesquisaController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Fornecedor getFornecedorSelecionado() {
        return this.fornecedorSelecionado;
    }

    public void setValorPesquisa(String valor) {
        this.tfPesquisa.setText(valor);
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
        if (valor != null && !valor.isEmpty()) {
            this.loadTabela();
        }
    }

    private void seleciona() {
        this.fornecedorSelecionado = (Fornecedor)this.tabela.getSelectionModel().getSelectedItem();
        if (this.fornecedorSelecionado == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um fornecedor para continuar.");
            return;
        }
        this.fechaForm();
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.fornecedorList.clear();
        List list = new ArrayList();
        if (!valorPesquisa.isEmpty()) {
            list = this.fornecedorService.list(valorPesquisa);
        }
        this.fornecedorList.addAll(list);
        this.tabela.setItems(this.fornecedorList);
    }

    private void carregaIcones() {
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
        this.btnSelecionar.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colEndereco.setCellValueFactory((Callback)new PropertyValueFactory("enderecoCompleto"));
        this.colCidade.setCellValueFactory((Callback)new PropertyValueFactory("municipio"));
        this.colTelefone.setCellValueFactory((Callback)new PropertyValueFactory("telefone"));
    }

    private void registraAcoes() {
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.btnNovo.setOnAction(event -> this.novo());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
            if (event.getCode() == KeyCode.DOWN) {
                this.tabela.requestFocus();
            }
        });
        this.btnSelecionar.setOnAction(event -> this.seleciona());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.seleciona();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER && this.tabela.getSelectionModel().getSelectedItem() != null) {
                this.seleciona();
            }
        });
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnPesquisa.getScene().getWindow();
        stage.close();
    }
}

