/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.service.EstadoService;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MunicipioFormController
extends MaximaController
implements Initializable {
    @Autowired
    private MunicipioService municipioService;
    @Autowired
    private EstadoService estadoService;
    private Municipio municipio;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfCodigoIbge;
    @FXML
    private ComboBox<Estado> cbbEstado;
    @FXML
    private Button btnSalva;
    @FXML
    private AnchorPane frame;
    @Autowired
    @Lazy
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public void inicializa(Municipio municipio) {
        this.municipio = municipio;
        if (municipio != null) {
            this.municipio = this.municipioService.load(municipio.getId().longValue());
            this.loadMunicipio(municipio);
        }
    }

    private void loadMunicipio(Municipio municipio) {
        if (municipio != null) {
            this.tfId.setText(municipio.getId().toString());
            this.tfNome.setText(municipio.getNome());
            this.tfCodigoIbge.setText(municipio.getCodigoIBGE());
            this.cbbEstado.getSelectionModel().select((Object)municipio.getEstado());
        }
    }

    private void save() {
        this.loadMunicipio();
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.municipio = this.municipioService.save(this.municipio);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados do municipio salvos com sucesso.");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(MunicipioFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadMunicipio() {
        if (this.municipio == null) {
            this.municipio = new Municipio();
        }
        this.municipio.setNome(MaximaUtils.getText((String)this.tfNome.getText()));
        this.municipio.setCodigoIBGE(MaximaUtils.getText((String)this.tfCodigoIbge.getText()));
        this.municipio.setEstado((Estado)this.cbbEstado.getSelectionModel().getSelectedItem());
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadCombos() {
        this.cbbEstado.setItems(FXCollections.observableArrayList((Collection)this.estadoService.list()));
    }

    private void setMascaras() {
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.municipio.getNome() == null || this.municipio.getNome().isEmpty()) {
            this.tfNome.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNome.getStyleClass().remove((Object)"error");
        }
        if (this.municipio.getCodigoIBGE() == null || this.municipio.getCodigoIBGE().isEmpty()) {
            valido = false;
            this.tfCodigoIbge.getStyleClass().add((Object)"error");
        } else {
            this.tfCodigoIbge.getStyleClass().remove((Object)"error");
        }
        if (this.municipio.getEstado() == null) {
            valido = false;
            this.cbbEstado.getStyleClass().add((Object)"error");
        } else {
            this.cbbEstado.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.municipio, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }
}

