/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.controller.TransportadoraFormController;
import br.com.maximasolutions.geral.modelo.Transportadora;
import br.com.maximasolutions.geral.service.TransportadoraService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class TransportadoraController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private TableView<Transportadora> tabela;
    @FXML
    private TableColumn<Transportadora, String> colCnpj;
    @FXML
    private TableColumn<Transportadora, String> colNome;
    @FXML
    private TableColumn<Transportadora, String> colEndereco;
    @FXML
    private TableColumn<Transportadora, String> colTelefone;
    @FXML
    private TableColumn<Transportadora, String> colCidade;
    @FXML
    private TableColumn<Transportadora, Long> colId;
    @Autowired
    private TransportadoraService transportadoraService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<Transportadora> transportadoraList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.transportadoraList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaTransportadora();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Transportadora);
    }

    private void novoTransportadora() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formTransportadora(null);
        this.loadTabela();
    }

    private void editaTransportadora() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        Transportadora transportadora = (Transportadora)this.tabela.getSelectionModel().getSelectedItem();
        if (transportadora == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um transportadora para editar.");
            return;
        }
        this.formTransportadora(transportadora);
        this.loadTabela();
    }

    private void formTransportadora(Transportadora transportadora) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/transportadora/TransportadoraForm.fxml", "Novo Transportadora");
            TransportadoraFormController controller = (TransportadoraFormController)stage.getUserData();
            controller.inicializa(transportadora);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(TransportadoraController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form transportadora.\n" + ex.getMessage()));
        }
    }

    private void deleteTransportadora() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        Transportadora transportadora = (Transportadora)this.tabela.getSelectionModel().getSelectedItem();
        if (transportadora == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um transportadora para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o transportadora: '" + transportadora.getNome() + "'?"))) {
            try {
                this.transportadoraService.delete(transportadora);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Transportadora deletado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaException ex) {
                Logger.getLogger(TransportadoraController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void loadTabela() {
        this.transportadoraList.clear();
        this.transportadoraList.addAll((Collection)this.transportadoraService.list(this.tfPesquisa.getText().trim(), Boolean.valueOf(this.ccbAtivo.isSelected())));
        this.tabela.setItems(this.transportadoraList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colCnpj.setCellValueFactory((Callback)new PropertyValueFactory("cpf"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colEndereco.setCellValueFactory((Callback)new PropertyValueFactory("enderecoCompleto"));
        this.colTelefone.setCellValueFactory((Callback)new PropertyValueFactory("telefone"));
        this.colCidade.setCellValueFactory((Callback)new PropertyValueFactory("municipio"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoTransportadora());
        this.btnEdita.setOnAction(event -> this.editaTransportadora());
        this.btnDelete.setOnAction(event -> this.deleteTransportadora());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

