/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class VendedorPesquisaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnSelecionar;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Vendedor> tabela;
    @FXML
    private TableColumn<Vendedor, String> colNome;
    @FXML
    private TableColumn<Vendedor, String> colCodigo;
    @FXML
    private TableColumn<Vendedor, String> colLogin;
    @Autowired
    private VendedorService vendedorService;
    private ObservableList<Vendedor> vendedorList;
    private Vendedor vendedorSelecionado;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.vendedorList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
    }

    public Vendedor getVendedorSelecionado() {
        return this.vendedorSelecionado;
    }

    public void setValorPesquisa(String valor) {
        this.tfPesquisa.setText(valor);
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
        if (valor != null && !valor.isEmpty()) {
            this.loadTabela();
        }
    }

    private void seleciona() {
        this.vendedorSelecionado = (Vendedor)this.tabela.getSelectionModel().getSelectedItem();
        if (this.vendedorSelecionado == null) {
            MaximaAlert.alerta((String)"Selecione um vendedor para continuar.");
            return;
        }
        this.fechaForm();
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.vendedorList.clear();
        List list = new ArrayList();
        if (!valorPesquisa.isEmpty()) {
            list = this.vendedorService.pesquisa(valorPesquisa);
        }
        this.vendedorList.addAll(list);
        this.tabela.setItems(this.vendedorList);
    }

    private void carregaIcones() {
        this.btnSelecionar.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colLogin.setCellValueFactory((Callback)new PropertyValueFactory("login"));
    }

    private void registraAcoes() {
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
            if (event.getCode() == KeyCode.DOWN) {
                this.tabela.requestFocus();
            }
        });
        this.btnSelecionar.setOnAction(event -> this.seleciona());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.seleciona();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER && this.tabela.getSelectionModel().getSelectedItem() != null) {
                this.seleciona();
            }
        });
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnPesquisa.getScene().getWindow();
        stage.close();
    }
}

