/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.geral.controller.MunicipioPesquisaController;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.relatorio.controller.RelatorioClienteCidadeBean;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioClienteController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private MunicipioService municipioService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private VendedorService vendedorService;
    private Municipio municipio;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnMunicipio;
    @FXML
    private TextField tfMunicipioCodigo;
    @FXML
    private TextField tfMunicipioDescricao;
    @FXML
    private ComboBox<Vendedor> comboVendedor;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.RelatorioCliente);
    }

    private void geraRelatorio() {
        List clientes = this.clienteService.lista(this.municipio, (Vendedor)this.comboVendedor.getSelectionModel().getSelectedItem());
        Configuracao conf = this.configuracaoService.load();
        ArrayList list = new ArrayList();
        clientes.stream().map(cliente -> {
            RelatorioClienteCidadeBean bean = new RelatorioClienteCidadeBean();
            bean.setEndereco(cliente.getEnderecoCompleto());
            bean.setCliente(cliente.getNome().toUpperCase());
            if (cliente.getFantasia() != null && !cliente.getFantasia().isEmpty()) {
                bean.setCliente(bean.getCliente() + " ( " + cliente.getFantasia() + " )");
            }
            bean.setTelefone(cliente.getTelefone());
            bean.setCelular(cliente.getCelular1());
            bean.setMunicipioId(cliente.getMunicipio().getId());
            bean.setMunicipio(cliente.getMunicipio().getNome());
            bean.setCodigo(cliente.getId());
            return bean;
        }).forEachOrdered(bean -> list.add(bean));
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("DESCRICAO", "CLIENTES - POR CIDADE");
            params.put("EMPRESA", conf.getNomeEmpresa() + " | " + conf.getTelefoneEmpresa());
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource(list);
            new PrintReport().showReport("/jasper/geral/cliente/clientes_2.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioClienteController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void carregaIcones() {
        this.btnGeraRelatorio.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.btnMunicipio.setOnAction(event -> this.pesquisaMunicipioForm());
        this.tfMunicipioCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMunicipio();
            }
        });
    }

    private void pesquisaMunicipio() {
        String municipioCodigo = this.tfMunicipioCodigo.getText().trim();
        if (municipioCodigo.isEmpty()) {
            return;
        }
        try {
            Long municipioCodigoNumero = Long.valueOf(municipioCodigo);
            Municipio municipioPesquisa = this.municipioService.load(municipioCodigoNumero.longValue());
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaMunicipioForm();
    }

    private void pesquisaMunicipioForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioPesquisa.fxml", "Pesquisa de cidades");
            MunicipioPesquisaController controller = (MunicipioPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMunicipioCodigo.getText().trim());
            stage.showAndWait();
            Municipio municipioPesquisa = controller.getMunicipioSelecionado();
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosMunicipio() {
        if (this.municipio != null) {
            this.tfMunicipioCodigo.setText(this.municipio.getId().toString());
            this.tfMunicipioDescricao.setText(this.municipio.getNome().toUpperCase() + " - " + this.municipio.getEstado().getSigla());
        } else {
            this.tfMunicipioCodigo.setText("");
            this.tfMunicipioDescricao.setText("");
            this.tfMunicipioCodigo.requestFocus();
        }
    }

    private void loadCombos() {
        ArrayList lista = new ArrayList();
        lista.add(null);
        lista.addAll(this.vendedorService.pesquisa(""));
        this.comboVendedor.setItems(FXCollections.observableArrayList(lista));
    }
}

