/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.service;

import br.com.maximasolutions.controller.ClienteImportaDto;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.repository.ClienteRepository;
import br.com.maximasolutions.geral.repository.MunicipioRepository;
import br.com.maximasolutions.geral.service.ClienteService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class ClienteServiceImpl
implements ClienteService {
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private MunicipioRepository municipioRepository;

    @Transactional(readOnly=true)
    public List<Cliente> listaDeAniversariantes(int mes) {
        return this.clienteRepository.listaDeAniversariantes(mes);
    }

    @Transactional(readOnly=true)
    public Cliente getById(Long id) {
        Optional cliente = this.clienteRepository.findById((Object)id);
        if (cliente.isPresent()) {
            return (Cliente)cliente.get();
        }
        return null;
    }

    @Transactional(readOnly=true)
    public Cliente getByCpf(String cpf) throws MaximaException {
        List clientes = this.clienteRepository.listaPorCpf(cpf);
        if (clientes.isEmpty()) {
            return null;
        }
        if (clientes.size() == 1) {
            return (Cliente)clientes.get(0);
        }
        throw new MaximaException("Mais de um cliente cadastrado para o CPF/CNPJ informado.");
    }

    @Transactional(readOnly=true)
    public List<Cliente> list(String pesquisa, Boolean ativo) {
        if (ativo == null || ativo.booleanValue()) {
            return this.clienteRepository.pesquisa("%" + pesquisa + "%");
        }
        return this.clienteRepository.pesquisaTodos("%" + pesquisa + "%");
    }

    @Transactional(readOnly=true)
    public List<Cliente> list(Long municipioId, String pesquisa, Boolean ativo) {
        if (ativo == null || ativo.booleanValue()) {
            return this.clienteRepository.pesquisa("%" + pesquisa + "%", municipioId);
        }
        return this.clienteRepository.pesquisaTodos("%" + pesquisa + "%", municipioId);
    }

    public Cliente save(Cliente cliente) throws MaximaException {
        if (cliente.getId() != null) {
            Cliente clienteBD = (Cliente)this.clienteRepository.findById((Object)cliente.getId()).get();
            cliente.setVale(clienteBD.getVale());
            cliente.setBonus(clienteBD.getBonus());
        }
        cliente.setSincronizado(Boolean.FALSE);
        cliente = (Cliente)this.clienteRepository.save((Object)cliente);
        return cliente;
    }

    public void delete(Cliente cliente) throws MaximaException {
        cliente = (Cliente)this.clienteRepository.getOne((Object)cliente.getId());
        try {
            this.clienteRepository.delete((Object)cliente);
            this.clienteRepository.flush();
        }
        catch (DataIntegrityViolationException e) {
            throw new MaximaException("Cliente n\u00e3o pode ser exclu\u00eddo.\nExiste v\u00ednculos no banco de dados.");
        }
    }

    @Transactional(readOnly=true)
    public List<Cliente> pesquisa(String valor) {
        return this.clienteRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public List<Cliente> listaPorCidades(String pesquisa) {
        return this.clienteRepository.listaPorCidades("%" + pesquisa + "%");
    }

    @Transactional(readOnly=true)
    public List<Cliente> listaSincronizar() {
        return this.clienteRepository.sincronizar();
    }

    @Transactional(readOnly=true)
    public List<Cliente> lista(Municipio municipio, Vendedor vendedor) {
        return this.clienteRepository.relatorio(municipio, vendedor);
    }

    public Cliente importa(ClienteImportaDto clienteDto) {
        Municipio municipio = this.municipioRepository.getByIbge(clienteDto.getCodigoIbge());
        if (municipio == null) {
            municipio = (Municipio)this.municipioRepository.findById((Object)14839L).get();
        }
        Cliente cliente = clienteDto.converter(municipio);
        return (Cliente)this.clienteRepository.save((Object)cliente);
    }
}

