/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.geral.repository.EstadoRepository;
import br.com.maximasolutions.geral.service.EstadoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class EstadoServiceImpl
implements EstadoService {
    @Autowired
    private EstadoRepository estadoRepository;

    public List<Estado> list() {
        return this.estadoRepository.list();
    }

    @Transactional(readOnly=true)
    public Estado load(long id) {
        Optional estado = this.estadoRepository.findById((Object)id);
        if (estado.isPresent()) {
            return (Estado)estado.get();
        }
        return null;
    }

    public Estado save(Estado estado) throws MaximaException {
        estado.setSincronizado(Boolean.FALSE);
        estado = (Estado)this.estadoRepository.save((Object)estado);
        return estado;
    }

    public void deleteById(Long id) throws MaximaException {
        this.estadoRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<Estado> lista(String valor) {
        return this.estadoRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public List<Estado> listaSincronizar() {
        return this.estadoRepository.sincronizar();
    }
}

