/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.service;

import br.com.maximasolutions.controller.ClienteImportaDto;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.repository.FornecedorRepository;
import br.com.maximasolutions.geral.repository.MunicipioRepository;
import br.com.maximasolutions.geral.service.FornecedorService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class FornecedorServiceImpl
implements FornecedorService {
    @Autowired
    private MunicipioRepository municipioRepository;
    @Autowired
    private FornecedorRepository fornecedorRepository;

    @Transactional(readOnly=true)
    public Fornecedor getById(Long id) {
        Optional fornecedor = this.fornecedorRepository.findById((Object)id);
        if (fornecedor.isPresent()) {
            return (Fornecedor)fornecedor.get();
        }
        return null;
    }

    @Transactional(readOnly=true)
    public Fornecedor getByCnpj(String cnpj) throws MaximaValidacaoException {
        List list = this.fornecedorRepository.getByCnpj(cnpj);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new MaximaValidacaoException("Existe mais de um fornecedor cadastrado para o mesmo cnpj.");
        }
        return (Fornecedor)list.get(0);
    }

    @Transactional(readOnly=true)
    public List<Fornecedor> list(String pesquisa) {
        return this.fornecedorRepository.pesquisa("%" + pesquisa + "%");
    }

    public Fornecedor save(Fornecedor fornecedor) throws MaximaException {
        return (Fornecedor)this.fornecedorRepository.save((Object)fornecedor);
    }

    public void delete(Fornecedor fornecedor) throws MaximaException {
        fornecedor = (Fornecedor)this.fornecedorRepository.findById((Object)fornecedor.getId()).get();
        fornecedor.setAtivo(Boolean.FALSE);
        this.fornecedorRepository.save((Object)fornecedor);
    }

    public Fornecedor importa(ClienteImportaDto clienteDto) {
        Municipio municipio = this.municipioRepository.getByCidadeUF(clienteDto.getMunicipio(), clienteDto.getUf());
        Fornecedor cliente = clienteDto.converterToFornecedor(municipio);
        return (Fornecedor)this.fornecedorRepository.save((Object)cliente);
    }
}

