/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.geral.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.geral.modelo.Transportadora;
import br.com.maximasolutions.geral.repository.TransportadoraRepository;
import br.com.maximasolutions.geral.service.TransportadoraService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class TransportadoraServiceImpl
implements TransportadoraService {
    @Autowired
    private TransportadoraRepository transportadoraRepository;

    @Transactional(readOnly=true)
    public Transportadora getById(Long id) {
        Optional transportadora = this.transportadoraRepository.findById((Object)id);
        if (transportadora.isPresent()) {
            return (Transportadora)transportadora.get();
        }
        return null;
    }

    @Transactional(readOnly=true)
    public Transportadora getByCpf(String cpf) throws MaximaException {
        List transportadoras = this.transportadoraRepository.listaPorCpf(cpf);
        if (transportadoras.isEmpty()) {
            return null;
        }
        if (transportadoras.size() == 1) {
            return (Transportadora)transportadoras.get(0);
        }
        throw new MaximaException("Mais de um transportadora cadastrado para o CPF/CNPJ informado.");
    }

    @Transactional(readOnly=true)
    public List<Transportadora> list(String pesquisa, Boolean ativo) {
        if (ativo == null || ativo.booleanValue()) {
            return this.transportadoraRepository.pesquisa("%" + pesquisa + "%");
        }
        return this.transportadoraRepository.pesquisaTodos("%" + pesquisa + "%");
    }

    @Transactional(readOnly=true)
    public List<Transportadora> list(Long municipioId, String pesquisa, Boolean ativo) {
        if (ativo == null || ativo.booleanValue()) {
            return this.transportadoraRepository.pesquisa("%" + pesquisa + "%", municipioId);
        }
        return this.transportadoraRepository.pesquisaTodos("%" + pesquisa + "%", municipioId);
    }

    public Transportadora save(Transportadora transportadora) throws MaximaException {
        transportadora = (Transportadora)this.transportadoraRepository.save((Object)transportadora);
        return transportadora;
    }

    public void delete(Transportadora transportadora) throws MaximaException {
        transportadora = (Transportadora)this.transportadoraRepository.getOne((Object)transportadora.getId());
        try {
            this.transportadoraRepository.delete((Object)transportadora);
            this.transportadoraRepository.flush();
        }
        catch (DataIntegrityViolationException e) {
            throw new MaximaException("Transportadora n\u00e3o pode ser exclu\u00eddo.\nExiste v\u00ednculos no banco de dados.");
        }
    }

    @Transactional(readOnly=true)
    public List<Transportadora> pesquisa(String valor) {
        return this.transportadoraRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public List<Transportadora> listaPorCidades(String pesquisa) {
        return this.transportadoraRepository.listaPorCidades("%" + pesquisa + "%");
    }

    public List<Transportadora> combo() {
        ArrayList<Transportadora> lista = new ArrayList<Transportadora>();
        lista.add(null);
        lista.addAll(this.transportadoraRepository.pesquisa("%%"));
        return lista;
    }
}

