/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfce.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.controller.GetNumeroFormController;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.fiscal.certificado.AssinaturaDigitalA3;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.nfce.controller.NFCeInutilizacaoXml;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.service.NFCeService;
import br.com.maximasolutions.nfce.service.NFCeServiceImpl;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteIndicadorProcessamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class NFCeController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnImprime;
    @FXML
    private TableView<NFCeCabecalho> tabela;
    @FXML
    private TableColumn<NFCeCabecalho, String> colSerie;
    @FXML
    private TableColumn<NFCeCabecalho, String> colNumero;
    @FXML
    private TableColumn<NFCeCabecalho, String> colData;
    @FXML
    private TableColumn<NFCeCabecalho, String> colNaturezaOperacao;
    @FXML
    private TableColumn<NFCeCabecalho, String> colDestinatario;
    @FXML
    private TableColumn<NFCeCabecalho, String> colStatus;
    @FXML
    private TableColumn<NFCeCabecalho, BigDecimal> colValor;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnInutilizar;
    @FXML
    private Button btnXml;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private NFCeService nFCeService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<NFCeCabecalho> notaFiscalList;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.carregaIcones();
        this.tfInicio.setValue((Object)LocalDate.now());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.notaFiscalList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.NotaFiscal);
    }

    private void inutilizarNumero() {
        String xml;
        Integer numero = null;
        try {
            Stage form = new MaximaDialogFX().createWindowUndecaredForm_(this.stageManager, (Stage)this.btnInutilizar.getScene().getWindow(), "/fxml/GetNumeroForm.fxml", "");
            GetNumeroFormController controller = (GetNumeroFormController)form.getUserData();
            form.showAndWait();
            Long retorno = controller.getNumero();
            if (retorno != null) {
                numero = retorno.intValue();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: Falha ao abrir form get n\u00famero.");
            return;
        }
        if (numero == null) {
            return;
        }
        String cnpj = MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCpf());
        DFUnidadeFederativa uf = DFUnidadeFederativa.valueOfCodigo((String)this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
        String serie = MaximaConfig.getInstance().getProperty("nfserie", "1");
        try {
            xml = new NFCeInutilizacaoXml().geraXml(cnpj, serie, String.valueOf(numero), uf, this.conf);
        }
        catch (Exception ex) {
            Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel gerar o XML de inutiliza\u00e7\u00e3o.\n" + ex.getMessage()));
            return;
        }
        try {
            MaximaFile.escreveTexto((String)"C:/Maxima/inut.txt", (String)xml);
        }
        catch (IOException ex) {
            Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.nFCeService.inutiliza(xml);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Inutiliza\u00e7\u00e3o efetuada com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel transmitir inutiliza\u00e7\u00e3o da NFCe.\n" + ex.getMessage()));
        }
    }

    private void imprimeNota() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_IMPRIMIR).booleanValue()) {
            return;
        }
        NFCeCabecalho nfce = (NFCeCabecalho)this.tabela.getSelectionModel().getSelectedItem();
        if (nfce == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um cupom fiscal para imprimir.");
            return;
        }
        try {
            this.nFCeService.imprime(nfce, this.conf);
        }
        catch (MaximaException ex) {
            Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: Cupom Fiscal N\u00e3o Impresso.\n" + ex.getMessage()));
        }
    }

    private void consultarXmlSefaz() {
        ObservableList nfceLista = this.tabela.getItems();
        for (NFCeCabecalho nfce : nfceLista) {
            try {
                NFNotaProcessada notaProcessada = (NFNotaProcessada)new DFPersister().read(NFNotaProcessada.class, nfce.getXmlTxt());
                ArrayList<NFNota> notas = new ArrayList<NFNota>();
                notas.add(notaProcessada.getNota());
                NFLoteEnvio lote = new NFLoteEnvio();
                lote.setIndicadorProcessamento(NFLoteIndicadorProcessamento.PROCESSAMENTO_SINCRONO);
                lote.setNotas(notas);
                lote.setVersao(NFeConfigMaxima.VERSAO_NFE);
                lote.setIdLote(nfce.getNumero());
                String documentoAssinado = new AssinaturaDigitalA3().assinaEnviNFe(lote.toString(), this.conf.getSenhaCertificado(), this.conf.getAliasCertificado());
                NFLoteEnvio loteAssinado = (NFLoteEnvio)new DFPersister().read(NFLoteEnvio.class, documentoAssinado);
                notaProcessada.setNota((NFNota)loteAssinado.getNotas().get(0));
                try {
                    MaximaFile.escreveTexto((String)("C:/Maxima/hmadu/" + nfce.getChaveAcesso() + nfce.getDigitoChaveAcesso() + "-NFCe.xml"), (String)notaProcessada.toString());
                }
                catch (IOException ex) {
                    Logger.getLogger(NFCeServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(NFCeController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void registraAcoes() {
        this.btnXml.setOnAction(evt -> this.consultarXmlSefaz());
        this.btnInutilizar.setOnAction(evt -> this.inutilizarNumero());
        this.btnImprime.setOnAction(evt -> this.imprimeNota());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }

    private void setColumnProperties() {
        this.colSerie.setCellValueFactory((Callback)new PropertyValueFactory("serie"));
        this.colNumero.setCellValueFactory((Callback)new PropertyValueFactory("numero"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataEmissao"));
        this.colNaturezaOperacao.setCellValueFactory((Callback)new PropertyValueFactory("naturezaOperacao"));
        this.colDestinatario.setCellValueFactory((Callback)new PropertyValueFactory("destinatario"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("statusNota"));
        this.colValor.setCellValueFactory((Callback)new PropertyValueFactory("valorTotal"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colValor.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.notaFiscalList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.nFCeService.lista(inicio.atTime(0, 0, 0), fim.atTime(23, 59, 59), filtro);
        BigDecimal valorNotasAutorizadas = BigDecimal.ZERO;
        this.notaFiscalList.addAll((Collection)list);
        this.tabela.setItems(this.notaFiscalList);
        for (NFCeCabecalho nfe : list) {
            valorNotasAutorizadas = valorNotasAutorizadas.add(nfe.getValorTotal());
        }
        this.lblTotal.setText("R$ " + MaximaNumber.bigDecimalToString((BigDecimal)valorNotasAutorizadas, (int)2));
    }

    private void carregaIcones() {
    }
}

