/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfce.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.nfce.controller.NFCeCodigoHash;
import br.com.maximasolutions.nfce.modelo.NFCeCabecalho;
import br.com.maximasolutions.nfce.modelo.NFCeDestinatario;
import br.com.maximasolutions.nfce.modelo.NFCeDetalhe;
import br.com.maximasolutions.nfce.modelo.NFCeEmitente;
import br.com.maximasolutions.nfce.modelo.NFCePagamento;
import br.com.maximasolutions.nfe.controller.NotaFiscalGeraXml;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFEndereco;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFIndicadorFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.NFModalidadeFrete;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaIPI;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFProcessoEmissor;
import com.fincatto.documentofiscal.nfe400.classes.NFProdutoCompoeValorNota;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import com.fincatto.documentofiscal.nfe400.classes.NFTipoImpressao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIdentificadorLocalDestinoOperacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorIEDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorPresencaComprador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFMeioPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCartao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCobranca;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoICMSTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoIdentificacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoInformacoesAdicionais;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItem;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImposto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSAliquota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSNaoTributavel;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSOutrasOperacoes;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS00;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS10;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS20;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS40;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS60;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS90;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN101;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN102;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN201;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN202;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN500;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN900;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPI;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPITributado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPIS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISAliquota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISNaoTributado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISOutrasOperacoes;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProduto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoResponsavelTecnico;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoSuplementar;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFTipoIntegracaoPagamento;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NFCeGeraXml {
    private final Configuracao conf;

    public NFCeGeraXml(Configuracao conf1) {
        this.conf = conf1;
    }

    public NFNotaInfoResponsavelTecnico getResponsavelTecnico() {
        NFNotaInfoResponsavelTecnico responsavel = new NFNotaInfoResponsavelTecnico();
        responsavel.setCnpj("09439300000146");
        responsavel.setContatoNome("M\u00e1xima Sistemas e Solu\u00e7\u00f5es");
        responsavel.setEmail("contato@maximasolutions.com.br");
        responsavel.setTelefone("18997636459");
        return responsavel;
    }

    public NFNota getNFCe(NFCeCabecalho nfce, List<NFCeDetalhe> listDetalhe, NFCeEmitente emitente, NFCeDestinatario destinatario, List<NFCePagamento> pagamentos) throws MaximaException {
        NFNota nota = new NFNota();
        NFNotaInfo notaInfo = new NFNotaInfo();
        notaInfo.setIdentificador(nfce.getChaveAcesso() + nfce.getDigitoChaveAcesso());
        notaInfo.setVersao(new BigDecimal(NFeConfigMaxima.VERSAO_NFE));
        notaInfo.setIdentificacao(this.getIdentificacao(nfce, emitente, this.conf));
        notaInfo.setEmitente(this.getEmitente(emitente, this.conf));
        notaInfo.setDestinatario(this.getDestinatario(destinatario));
        notaInfo.setPagamento(this.getPagamentos(nfce, pagamentos));
        notaInfo.setCobranca(this.getCobranca(nfce));
        notaInfo.setTransporte(this.getTransporte());
        notaInfo.setInformacaoResposavelTecnico(this.getResponsavelTecnico());
        NFNotaInfoInformacoesAdicionais infoAdd = new NFNotaInfoInformacoesAdicionais();
        String infAdd = MaximaUtils.removeAcentos((String)nfce.getInformacoesAddContribuinte());
        if (infAdd == null) {
            infAdd = "";
        }
        ArrayList<NFNotaInfoItem> itens = new ArrayList<NFNotaInfoItem>();
        for (NFCeDetalhe i : listDetalhe) {
            try {
                itens.add(this.getItem(nfce, destinatario, i, this.conf));
            }
            catch (Exception ex) {
                Logger.getLogger(NotaFiscalGeraXml.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException(ex.getMessage());
            }
        }
        notaInfo.setItens(itens);
        notaInfo.setTotal(this.getTotal(nfce, listDetalhe));
        if (!infAdd.isEmpty()) {
            infAdd = infAdd.replace("\n", "#");
            infoAdd.setInformacoesComplementaresInteresseContribuinte(infAdd.trim());
        }
        notaInfo.setInformacoesAdicionais(infoAdd);
        nota.setInfo(notaInfo);
        if (nfce.getTipoEmissao().equals((Object)NFTipoEmissao.EMISSAO_NORMAL)) {
            nota.setInfoSuplementar(this.getInfoSuplementar(nfce, nota, emitente));
        }
        return nota;
    }

    public NFNotaInfoSuplementar getInfoSuplementar(NFCeCabecalho nfce, NFNota nota, NFCeEmitente emitente) {
        String parametros;
        NFNotaInfoSuplementar nfnis = new NFNotaInfoSuplementar();
        String qrcode = "";
        String urlConsulta = "";
        String ambiente = "";
        if (nota.getInfo().getIdentificacao().getAmbiente().equals((Object)DFAmbiente.HOMOLOGACAO)) {
            qrcode = DFUnidadeFederativa.valueOfCodigo((String)emitente.getMunicipio().getEstado().getSigla()).getQrCodeHomologacao() + "?p=";
            urlConsulta = DFUnidadeFederativa.valueOfCodigo((String)emitente.getMunicipio().getEstado().getSigla()).getConsultaChaveAcessoHomologacao();
            ambiente = "2";
        } else {
            qrcode = DFUnidadeFederativa.valueOfCodigo((String)emitente.getMunicipio().getEstado().getSigla()).getQrCodeProducao() + "?p=";
            urlConsulta = DFUnidadeFederativa.valueOfCodigo((String)emitente.getMunicipio().getEstado().getSigla()).getConsultaChaveAcessoProducao();
            ambiente = "1";
        }
        String nfceCscId = MaximaConfig.getNfceCscId();
        if (nota.getInfo().getIdentificacao().getTipoEmissao().equals((Object)NFTipoEmissao.EMISSAO_NORMAL)) {
            parametros = nfce.getChaveAcesso() + nfce.getDigitoChaveAcesso() + "|2|" + ambiente + "|" + nfceCscId;
        } else {
            String diaDataEmissao = String.valueOf(nota.getInfo().getIdentificacao().getDataHoraEmissao().getDayOfMonth());
            parametros = nfce.getChaveAcesso() + nfce.getDigitoChaveAcesso() + "|2|" + ambiente + "|" + MaximaUtils.completaZeroEsquerda((String)diaDataEmissao, (Integer)2) + "|" + nota.getInfo().getTotal().getIcmsTotal().getValorTotalNFe() + "|" + this.toHex(nota.getAssinatura().getSignedInfo().getReference().getDigestValue()) + "|" + nfceCscId;
        }
        qrcode = qrcode + parametros + "|";
        String nfceCsc = MaximaConfig.getNfceCsc();
        String hexa = NFCeCodigoHash.calcula((String)(parametros + nfceCsc));
        nfnis.setQrCode(qrcode + hexa.toUpperCase());
        nfnis.setUrlConsultaChaveAcesso(urlConsulta);
        return nfnis;
    }

    public String toHex(String arg) {
        return String.format("%040x", new BigInteger(1, arg.getBytes(Charset.forName("UTF-8"))));
    }

    private NFNotaInfoTransporte getTransporte() {
        NFNotaInfoTransporte transporte = new NFNotaInfoTransporte();
        transporte.setModalidadeFrete(NFModalidadeFrete.SEM_OCORRENCIA_TRANSPORTE);
        return transporte;
    }

    private NFNotaInfoCobranca getCobranca(NFCeCabecalho nfe) {
        return null;
    }

    private NFNotaInfoTotal getTotal(NFCeCabecalho info, List<NFCeDetalhe> itens) {
        NFNotaInfoTotal total = new NFNotaInfoTotal();
        NFNotaInfoICMSTotal iCMSTotal = new NFNotaInfoICMSTotal();
        iCMSTotal.setBaseCalculoICMS(info.getBaseCalculoIcms());
        iCMSTotal.setBaseCalculoICMSST(info.getBaseCalculoIcmsSt());
        iCMSTotal.setOutrasDespesasAcessorias(BigDecimal.ZERO);
        iCMSTotal.setValorCOFINS(info.getValorCofins());
        iCMSTotal.setValorICMSDesonerado(BigDecimal.ZERO);
        iCMSTotal.setValorPIS(info.getValorPis());
        if (info.getValorDesconto() != BigDecimal.ZERO) {
            iCMSTotal.setValorTotalDesconto(info.getValorDesconto());
        }
        iCMSTotal.setValorTotalDosProdutosServicos(info.getValorTotalProdutos());
        if (info.getValorFrete() != BigDecimal.ZERO) {
            iCMSTotal.setValorTotalFrete(info.getValorFrete());
        } else {
            iCMSTotal.setValorTotalFrete(BigDecimal.ZERO);
        }
        if (info.getValorDespesasAcessorias() != BigDecimal.ZERO) {
            iCMSTotal.setOutrasDespesasAcessorias(info.getValorDespesasAcessorias());
        }
        iCMSTotal.setValorTotalNFe(info.getValorTotal());
        iCMSTotal.setValorTotalTributos(BigDecimal.ZERO);
        iCMSTotal.setValorTotalICMS(info.getValorIcms());
        iCMSTotal.setValorTotalICMSST(info.getValorIcmsSt());
        iCMSTotal.setValorTotalII(BigDecimal.ZERO);
        iCMSTotal.setValorTotalIPI(info.getValorIpi());
        iCMSTotal.setValorTotalSeguro(BigDecimal.ZERO);
        iCMSTotal.setValorTotalFundoCombatePobreza(BigDecimal.ZERO);
        iCMSTotal.setValorTotalFundoCombatePobrezaST(BigDecimal.ZERO);
        iCMSTotal.setValorTotalFundoCombatePobrezaSTRetido(BigDecimal.ZERO);
        iCMSTotal.setValorTotalIPIDevolvido(BigDecimal.ZERO);
        iCMSTotal.setValorICMSFundoCombatePobreza(BigDecimal.ZERO);
        iCMSTotal.setValorICMSPartilhaDestinatario(BigDecimal.ZERO);
        iCMSTotal.setValorICMSPartilhaRementente(BigDecimal.ZERO);
        iCMSTotal.setValorTotalTributos(info.getValorTotalTributos());
        total.setIcmsTotal(iCMSTotal);
        return total;
    }

    private NFNotaInfoItem getItem(NFCeCabecalho nota, NFCeDestinatario destinatario, NFCeDetalhe det, Configuracao conf) throws Exception {
        NFNotaInfoItem item = new NFNotaInfoItem();
        item.setImposto(this.getImposto(nota, destinatario, det, conf));
        item.setNumeroItem(det.getNumeroItem());
        item.setProduto(this.getProduto(det));
        String infAdProd = det.getInformacoesAdicionais();
        if (infAdProd != null && !infAdProd.isEmpty()) {
            item.setInformacoesAdicionais(infAdProd.trim());
        }
        return item;
    }

    private NFNotaInfoItemImposto getImposto(NFCeCabecalho nota, NFCeDestinatario destinatario, NFCeDetalhe item, Configuracao conf) throws Exception {
        NFNotaInfoItemImposto imposto = new NFNotaInfoItemImposto();
        System.out.println("== Total tributos item: " + item.getValorTotalTributos());
        imposto.setValorTotalTributos(item.getValorTotalTributos());
        if (item.getProduto().getPis() != null && item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_SUBSTITUICAO_TRIBUTARIA)) {
            NFNotaInfoItemImpostoPISST pisST = new NFNotaInfoItemImpostoPISST();
            pisST.setQuantidadeVendida(item.getQuantidadeComercial());
            pisST.setValorAliquota(BigDecimal.ZERO);
            pisST.setValorBaseCalculo(item.getValorTotal());
            pisST.setValorTributo(BigDecimal.ZERO);
            imposto.setPisst(pisST);
        } else {
            imposto.setPis(this.getPis(item, conf));
        }
        if (item.getProduto().getCofins() != null && item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_SUBSTITUICAO_TRIBUTARIA)) {
            NFNotaInfoItemImpostoCOFINSST cofinsST = new NFNotaInfoItemImpostoCOFINSST();
            cofinsST.setPercentualAliquota(BigDecimal.ZERO);
            cofinsST.setQuantidadeVendida(item.getQuantidadeComercial());
            cofinsST.setValorBaseCalculo(item.getValorTotal());
            cofinsST.setValorCOFINS(BigDecimal.ZERO);
            imposto.setCofinsst(cofinsST);
        } else {
            imposto.setCofins(this.getCofins(item, conf));
        }
        if (item.getCstIpi() != null && !item.getCstIpi().isEmpty()) {
            imposto.setIpi(this.getIPI(item, conf));
        }
        imposto.setIcms(this.getIcms(item, conf));
        return imposto;
    }

    private NFNotaInfoItemProduto getProduto(NFCeDetalhe item) {
        NFNotaInfoItemProduto produto = new NFNotaInfoItemProduto();
        produto.setCompoeValorNota(NFProdutoCompoeValorNota.SIM);
        produto.setCfop(item.getCfop().toString().trim());
        produto.setCodigo(item.getCodigoProduto().trim());
        produto.setDescricao(MaximaUtils.removeAcentos((String)item.getNomeProduto()).trim());
        produto.setNcm(item.getNcm().trim());
        produto.setQuantidadeComercial(item.getQuantidadeComercial().setScale(4, RoundingMode.HALF_EVEN));
        produto.setQuantidadeTributavel(item.getQuantidadeTributavel());
        produto.setUnidadeComercial(item.getUnidadeComercial());
        produto.setUnidadeTributavel(item.getUnidadeTributavel());
        produto.setValorUnitario(item.getValorUnitarioComercial());
        produto.setValorUnitarioTributavel(item.getValorUnitarioTributacao());
        produto.setValorTotalBruto(item.getValorBrutoProdutos().setScale(2, RoundingMode.HALF_EVEN));
        if (item.getValorFrete() != null && item.getValorFrete().compareTo(BigDecimal.ZERO) > 0) {
            produto.setValorFrete(item.getValorFrete());
        }
        if (item.getValorDesconto() != null && item.getValorDesconto().compareTo(BigDecimal.ZERO) > 0) {
            produto.setValorDesconto(item.getValorDesconto());
        }
        if (item.getValorOutrasDespesas() != null && item.getValorOutrasDespesas().compareTo(BigDecimal.ZERO) > 0) {
            produto.setValorOutrasDespesasAcessorias(item.getValorOutrasDespesas());
        }
        if (item.getProduto().getCest() != null && !item.getProduto().getCest().isEmpty()) {
            produto.setCodigoEspecificadorSituacaoTributaria(item.getProduto().getCest());
        }
        produto.setCodigoDeBarras("SEM GTIN");
        produto.setCodigoDeBarrasTributavel("SEM GTIN");
        return produto;
    }

    private NFNotaInfoItemImpostoICMS getIcms(NFCeDetalhe item, Configuracao configuracao) throws Exception {
        NFNotaInfoItemImpostoICMS icms = new NFNotaInfoItemImpostoICMS();
        if (configuracao.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.NAO_TRIBUTADA) || NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SEM_PERMISSAO_CREDITO) || NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.IMUNE)) {
                NFNotaInfoItemImpostoICMSSN102 icms102 = new NFNotaInfoItemImpostoICMSSN102();
                icms102.setOrigem(item.getProduto().getOrigem());
                icms102.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()));
                icms.setIcmssn102(icms102);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_COM_PERMISSAO_CREDITO)) {
                NFNotaInfoItemImpostoICMSSN101 icms101 = new NFNotaInfoItemImpostoICMSSN101();
                icms101.setOrigem(item.getProduto().getOrigem());
                icms101.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_COM_PERMISSAO_CREDITO);
                icms101.setPercentualAliquotaAplicavelCalculoCreditoSN(item.getProduto().getAliquotaCreditoICMS());
                icms101.setValorCreditoICMSSN(item.getProduto().getAliquotaCreditoICMS().multiply(item.getValorTotal()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
                icms.setIcmssn101(icms101);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SIMPLES_NACIONAL_COM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA)) {
                NFNotaInfoItemImpostoICMSSN201 icms201 = new NFNotaInfoItemImpostoICMSSN201();
                icms201.setOrigem(item.getProduto().getOrigem());
                icms201.setPercentualAliquotaAplicavelCalculoCreditoSN(item.getProduto().getAliquotaCreditoICMS());
                icms201.setValorCreditoICMSSN(item.getProduto().getAliquotaCreditoICMS().multiply(item.getValorTotal()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
                icms201.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO);
                icms201.setPercentualAliquotaImpostoICMSST(item.getAliquotaIcmsSt());
                icms201.setPercentualMargemValorAdicionadoICMSST(item.getPercentualMvaIcmsSt());
                icms201.setPercentualReducaoBCICMSST(BigDecimal.ZERO);
                icms201.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SIMPLES_NACIONAL_COM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA);
                icms201.setValorBCICMSST(item.getBaseCalculoIcmsSt());
                icms201.setValorICMSST(item.getValorIcmsSt());
                icms.setIcmssn201(icms201);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SIMPLES_NACIONAL_SEM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA)) {
                NFNotaInfoItemImpostoICMSSN202 icms202 = new NFNotaInfoItemImpostoICMSSN202();
                icms202.setOrigem(item.getProduto().getOrigem());
                icms202.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO);
                icms202.setPercentualAliquotaImpostoICMSST(item.getAliquotaIcmsSt());
                icms202.setPercentualMargemValorAdicionadoICMSST(item.getPercentualMvaIcmsSt());
                icms202.setPercentualReducaoBCICMSST(BigDecimal.ZERO);
                icms202.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SIMPLES_NACIONAL_SEM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA);
                icms202.setValorBCICMSST(item.getBaseCalculoIcmsSt());
                icms202.setValorICMSST(item.getValorIcmsSt());
                icms.setIcmssn202(icms202);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO)) {
                NFNotaInfoItemImpostoICMSSN500 icms500 = new NFNotaInfoItemImpostoICMSSN500();
                icms500.setOrigem(item.getProduto().getOrigem());
                icms500.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO);
                icms.setIcmssn500(icms500);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.OUTROS)) {
                NFNotaInfoItemImpostoICMSSN900 icms900 = new NFNotaInfoItemImpostoICMSSN900();
                icms900.setOrigem(item.getProduto().getOrigem());
                icms900.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.OUTROS);
                if (item.getBaseCalculoIcms() != null && item.getBaseCalculoIcms().compareTo(BigDecimal.ZERO) > 0) {
                    icms900.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.VALOR_OPERACAO);
                    icms900.setValorBCICMS(item.getBaseCalculoIcms());
                    icms900.setPercentualAliquotaImposto(item.getAliquotaIcms());
                    icms900.setValorICMS(item.getValorIcms());
                }
                if (item.getBaseCalculoIcmsSt() != null && item.getBaseCalculoIcmsSt().compareTo(BigDecimal.ZERO) > 0) {
                    icms900.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO);
                    icms900.setPercentualAliquotaImpostoICMSST(item.getAliquotaIcmsSt());
                    icms900.setPercentualMargemValorAdicionadoICMSST(item.getPercentualMvaIcmsSt());
                    icms900.setPercentualReducaoBCICMSST(BigDecimal.ZERO);
                    icms900.setValorBCICMSST(item.getBaseCalculoIcmsSt());
                    icms900.setValorICMSST(item.getValorIcmsSt());
                }
                icms.setIcmssn900(icms900);
            }
        } else {
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.OUTROS)) {
                NFNotaInfoItemImpostoICMS90 iCMS90 = new NFNotaInfoItemImpostoICMS90();
                iCMS90.setOrigem(item.getProduto().getOrigem());
                iCMS90.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.OUTROS);
                icms.setIcms90(iCMS90);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.TRIBUTACAO_INTEGRALMENTE)) {
                NFNotaInfoItemImpostoICMS00 iCMS00 = new NFNotaInfoItemImpostoICMS00();
                iCMS00.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.VALOR_OPERACAO);
                iCMS00.setOrigem(item.getProduto().getOrigem());
                iCMS00.setPercentualAliquota(item.getAliquotaIcms());
                iCMS00.setValorBaseCalculo(item.getBaseCalculoIcms());
                iCMS00.setValorTributo(item.getValorIcms());
                iCMS00.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.TRIBUTACAO_INTEGRALMENTE);
                icms.setIcms00(iCMS00);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA)) {
                System.out.println("======= ICMS 10 ==========");
                NFNotaInfoItemImpostoICMS10 iCMS10 = new NFNotaInfoItemImpostoICMS10();
                iCMS10.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.VALOR_OPERACAO);
                iCMS10.setOrigem(item.getProduto().getOrigem());
                iCMS10.setPercentualAliquota(item.getAliquotaIcms());
                iCMS10.setValorBaseCalculo(item.getBaseCalculoIcms());
                iCMS10.setValorTributo(item.getValorIcms());
                iCMS10.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA);
                iCMS10.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO);
                iCMS10.setValorBCICMSST(item.getBaseCalculoIcmsSt());
                iCMS10.setPercentualAliquotaImpostoICMSST(item.getAliquotaIcmsSt());
                iCMS10.setValorICMSST(item.getValorIcmsSt());
                icms.setIcms10(iCMS10);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.COM_REDUCAO_BASE_CALCULO)) {
                System.out.println("======= ICMS 20 ==========");
                NFNotaInfoItemImpostoICMS20 iCMS20 = new NFNotaInfoItemImpostoICMS20();
                iCMS20.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)item.getModalidadeBcIcms()));
                iCMS20.setOrigem(item.getProduto().getOrigem());
                iCMS20.setPercentualAliquota(item.getAliquotaIcms());
                iCMS20.setValorBCICMS(item.getBaseCalculoIcms());
                iCMS20.setValorTributo(item.getValorIcms());
                iCMS20.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.COM_REDUCAO_BASE_CALCULO);
                iCMS20.setPercentualReducaoBC(item.getTaxaReducaoBcIcms());
                icms.setIcms20(iCMS20);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.ISENTA) || NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.NAO_TRIBUTADO)) {
                NFNotaInfoItemImpostoICMS40 iCMS40 = new NFNotaInfoItemImpostoICMS40();
                iCMS40.setOrigem(item.getProduto().getOrigem());
                iCMS40.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()));
                icms.setIcms40(iCMS40);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA)) {
                System.out.println("======= ICMS 60 ==========");
                NFNotaInfoItemImpostoICMS60 iCMS60 = new NFNotaInfoItemImpostoICMS60();
                iCMS60.setOrigem(item.getProduto().getOrigem());
                iCMS60.setSituacaoTributaria(item.getProduto().getTributacaoICMS());
                iCMS60.setValorBCICMSSTRetido(BigDecimal.ZERO);
                iCMS60.setValorICMSSTRetido(BigDecimal.ZERO);
                iCMS60.setPercentualAliquotaICMSSTConsumidorFinal(BigDecimal.ZERO);
                icms.setIcms60(iCMS60);
            }
        }
        return icms;
    }

    private NFNotaInfoItemImpostoCOFINS getCofins(NFCeDetalhe item, Configuracao conf) {
        System.out.println("***** CONFINS: " + item.getProduto().getCofins());
        if (conf.getEmpresaNFe().getLucroPresumido().booleanValue()) {
            NFNotaInfoSituacaoTributariaCOFINS situacaoTributaria = NFNotaInfoSituacaoTributariaCOFINS.valueOfCodigo((String)item.getCstCofins());
            if (NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO.equals((Object)situacaoTributaria) || NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_ALIQUOTA_DIFERENCIADA.equals((Object)situacaoTributaria)) {
                NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
                NFNotaInfoItemImpostoCOFINSAliquota aliquota = new NFNotaInfoItemImpostoCOFINSAliquota();
                aliquota.setPercentualAliquota(item.getAliquotaPisPercentual());
                aliquota.setSituacaoTributaria(situacaoTributaria);
                aliquota.setValorBaseCalculo(item.getBaseCalculoCofins());
                aliquota.setValor(item.getValorCofins());
                cofins.setAliquota(aliquota);
                return cofins;
            }
            NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSOutrasOperacoes cofinsOutrasOperacoes = new NFNotaInfoItemImpostoCOFINSOutrasOperacoes();
            cofinsOutrasOperacoes.setPercentualCOFINS(item.getAliquotaCofinsPercentual());
            cofinsOutrasOperacoes.setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS.OUTRAS_OPERACOES);
            cofinsOutrasOperacoes.setValorBaseCalculo(item.getBaseCalculoCofins());
            cofinsOutrasOperacoes.setValorCOFINS(item.getValorCofins());
            cofins.setOutrasOperacoes(cofinsOutrasOperacoes);
            return cofins;
        }
        if (item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO)) {
            NFNotaInfoItemImpostoCOFINS pis = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSNaoTributavel pISNaoTributado = new NFNotaInfoItemImpostoCOFINSNaoTributavel();
            pISNaoTributado.setSituacaoTributaria(item.getProduto().getCofins());
            pis.setNaoTributavel(pISNaoTributado);
            return pis;
        }
        if (item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_ISENTA_CONTRIBUICAO) || item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_SEM_INCIDENCIA_CONTRIBUICAO) || item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_ALIQUOTA_ZERO)) {
            NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSNaoTributavel cOFINSNaoTributavel = new NFNotaInfoItemImpostoCOFINSNaoTributavel();
            cOFINSNaoTributavel.setSituacaoTributaria(item.getProduto().getCofins());
            cofins.setNaoTributavel(cOFINSNaoTributavel);
            return cofins;
        }
        if (item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO)) {
            NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSAliquota aliquota = new NFNotaInfoItemImpostoCOFINSAliquota();
            aliquota.setPercentualAliquota(item.getAliquotaCofinsPercentual());
            aliquota.setSituacaoTributaria(item.getProduto().getCofins());
            aliquota.setValorBaseCalculo(item.getBaseCalculoCofins());
            aliquota.setValor(item.getValorCofins());
            cofins.setAliquota(aliquota);
            return cofins;
        }
        if (item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OUTRAS_OPERACOES)) {
            NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSOutrasOperacoes pISOutrasOperacoes = new NFNotaInfoItemImpostoCOFINSOutrasOperacoes();
            pISOutrasOperacoes.setPercentualCOFINS(BigDecimal.ZERO);
            pISOutrasOperacoes.setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS.OUTRAS_OPERACOES);
            pISOutrasOperacoes.setValorBaseCalculo(BigDecimal.ZERO);
            pISOutrasOperacoes.setValorCOFINS(BigDecimal.ZERO);
            cofins.setOutrasOperacoes(pISOutrasOperacoes);
            return cofins;
        }
        return null;
    }

    private NFNotaInfoItemImpostoIPI getIPI(NFCeDetalhe item, Configuracao conf) {
        if (item.getCstIpi().equals(NFNotaInfoSituacaoTributariaIPI.OUTRAS_SAIDAS.getCodigo())) {
            NFNotaInfoItemImpostoIPI ipi = new NFNotaInfoItemImpostoIPI();
            NFNotaInfoItemImpostoIPITributado iPITributado = new NFNotaInfoItemImpostoIPITributado();
            iPITributado.setPercentualAliquota(item.getAliquotaIpi());
            iPITributado.setSituacaoTributaria(NFNotaInfoSituacaoTributariaIPI.OUTRAS_SAIDAS);
            iPITributado.setValorBaseCalculo(item.getBaseCalculoIpi());
            iPITributado.setValorTributo(item.getValorIpi());
            ipi.setCodigoEnquadramento("999");
            ipi.setTributado(iPITributado);
            return ipi;
        }
        return null;
    }

    private NFNotaInfoItemImpostoPIS getPis(NFCeDetalhe item, Configuracao conf) {
        if (conf.getEmpresaNFe().getLucroPresumido().booleanValue()) {
            NFNotaInfoSituacaoTributariaPIS situacaoTributaria = NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis());
            if (NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO.equals((Object)situacaoTributaria) || NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_ALIQUOTA_DIFERENCIADA.equals((Object)situacaoTributaria)) {
                NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
                NFNotaInfoItemImpostoPISAliquota aliquota = new NFNotaInfoItemImpostoPISAliquota();
                aliquota.setPercentualAliquota(item.getAliquotaPisPercentual());
                aliquota.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis()));
                aliquota.setValorBaseCalculo(item.getValorBaseCalculoPis());
                aliquota.setValorTributo(item.getValorPis());
                pis.setAliquota(aliquota);
                return pis;
            }
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISOutrasOperacoes pISOutrasOperacoes = new NFNotaInfoItemImpostoPISOutrasOperacoes();
            pISOutrasOperacoes.setPercentualAliquota(item.getAliquotaPisPercentual());
            pISOutrasOperacoes.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.OUTRAS_OPERACOES);
            pISOutrasOperacoes.setValorBaseCalculo(item.getValorBaseCalculoPis());
            pISOutrasOperacoes.setValorTributo(item.getValorPis());
            pis.setOutrasOperacoes(pISOutrasOperacoes);
            return pis;
        }
        if (NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO.equals((Object)NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis())) || NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_ALIQUOTA_DIFERENCIADA.equals((Object)NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis()))) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISAliquota aliquota = new NFNotaInfoItemImpostoPISAliquota();
            aliquota.setPercentualAliquota(item.getAliquotaPisPercentual());
            aliquota.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis()));
            aliquota.setValorBaseCalculo(item.getValorBaseCalculoPis());
            aliquota.setValorTributo(item.getValorPis());
            pis.setAliquota(aliquota);
            return pis;
        }
        if (item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO)) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISNaoTributado pISNaoTributado = new NFNotaInfoItemImpostoPISNaoTributado();
            pISNaoTributado.setSituacaoTributaria(item.getProduto().getPis());
            pis.setNaoTributado(pISNaoTributado);
            return pis;
        }
        if (item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_ISENTA_CONTRIBUICAO) || item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_SEM_INCIDENCIA_CONTRIBUICAO) || item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_ALIQUOTA_ZERO)) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISNaoTributado pISNaoTributado = new NFNotaInfoItemImpostoPISNaoTributado();
            pISNaoTributado.setSituacaoTributaria(item.getProduto().getPis());
            pis.setNaoTributado(pISNaoTributado);
            return pis;
        }
        if (item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO)) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISAliquota aliquota = new NFNotaInfoItemImpostoPISAliquota();
            aliquota.setPercentualAliquota(item.getAliquotaPisPercentual());
            aliquota.setSituacaoTributaria(item.getProduto().getPis());
            aliquota.setValorBaseCalculo(item.getValorBaseCalculoPis());
            aliquota.setValorTributo(item.getValorPis());
            pis.setAliquota(aliquota);
            return pis;
        }
        if (item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OUTRAS_OPERACOES)) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISOutrasOperacoes pISOutrasOperacoes = new NFNotaInfoItemImpostoPISOutrasOperacoes();
            pISOutrasOperacoes.setPercentualAliquota(BigDecimal.ZERO);
            pISOutrasOperacoes.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.OUTRAS_OPERACOES);
            pISOutrasOperacoes.setValorBaseCalculo(BigDecimal.ZERO);
            pISOutrasOperacoes.setValorTributo(BigDecimal.ZERO);
            pis.setOutrasOperacoes(pISOutrasOperacoes);
            return pis;
        }
        return null;
    }

    private NFNotaInfoIdentificacao getIdentificacao(NFCeCabecalho info, NFCeEmitente emitente, Configuracao conf) throws MaximaException {
        NFeConfigMaxima maxima = new NFeConfigMaxima(conf);
        NFNotaInfoIdentificacao ident = new NFNotaInfoIdentificacao();
        ident.setAmbiente(maxima.getAmbiente());
        ident.setCodigoMunicipio(emitente.getMunicipio().getCodigoIBGE());
        ident.setCodigoRandomico(info.getCodigoNumerico());
        ident.setDataHoraEmissao(MaximaDate.convert((LocalDateTime)info.getDataEmissao()));
        ident.setDigitoVerificador(Integer.valueOf(Integer.parseInt(info.getDigitoChaveAcesso())));
        ident.setFinalidade(NFFinalidade.valueOfCodigo((String)info.getFinalidadeEmissao().getCodigo()));
        ident.setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao.OPERACAO_INTERNA);
        ident.setIndicadorPresencaComprador(NFIndicadorPresencaComprador.OPERACAO_PRESENCIAL);
        ident.setModelo(DFModelo.NFCE);
        ident.setNaturezaOperacao(info.getNaturezaOperacao());
        ident.setNumeroNota(info.getNumero().trim());
        ident.setOperacaoConsumidorFinal(info.getConsumidorFinal());
        ident.setProgramaEmissor(NFProcessoEmissor.CONTRIBUINTE);
        Integer serie = Integer.parseInt(info.getSerie());
        ident.setSerie(serie.toString());
        ident.setTipo(info.getTipoOperacao());
        ident.setTipoEmissao(info.getTipoEmissao());
        ident.setTipoImpressao(NFTipoImpressao.DANFE_NFCE);
        ident.setUf(DFUnidadeFederativa.valueOfCodigo((String)emitente.getMunicipio().getEstado().getSigla()));
        ident.setVersaoEmissor("5.10");
        ident.setIndicadorPresencaComprador(NFIndicadorPresencaComprador.OPERACAO_PRESENCIAL);
        if (ident.getTipoEmissao().equals((Object)NFTipoEmissao.CONTIGENCIA_OFFLINE)) {
            ident.setDataHoraContigencia(MaximaDate.convert((LocalDateTime)LocalDateTime.now()));
            ident.setJustificativaEntradaContingencia("Falha na comunica\u00e7\u00e3o com a sefaz por problema de hardware.");
        }
        return ident;
    }

    private NFNotaInfoPagamento getPagamentos(NFCeCabecalho nfce, List<NFCePagamento> pagamentos) {
        NFNotaInfoPagamento pgto = new NFNotaInfoPagamento();
        ArrayList<NFNotaInfoFormaPagamento> detalhamentoFormasPagamento = new ArrayList<NFNotaInfoFormaPagamento>();
        BigDecimal valorTroco = BigDecimal.ZERO;
        for (NFCePagamento pagamento : pagamentos) {
            NFNotaInfoFormaPagamento formaPagamento = new NFNotaInfoFormaPagamento();
            formaPagamento.setMeioPagamento(NFMeioPagamento.valueOfCodigo((String)pagamento.getCondicaoRecebimento().getFormaPagamento().getCodigoNFe()));
            if (pagamento.getCondicaoRecebimento().getFormaPagamento().getCodigoNFe().equals("99")) {
                formaPagamento.setDescricaoMeioPagamento(pagamento.getCondicaoRecebimento().getNome().toUpperCase());
            }
            formaPagamento.setValorPagamento(pagamento.getValor().add(pagamento.getValorTroco()));
            formaPagamento.setIndicadorFormaPagamento(NFIndicadorFormaPagamento.valueOfCodigo((String)pagamento.getCondicaoRecebimento().getTipo().getCodigo()));
            if (formaPagamento.getMeioPagamento().equals((Object)NFMeioPagamento.CARTAO_DEBITO) || formaPagamento.getMeioPagamento().equals((Object)NFMeioPagamento.CARTAO_CREDITO) || formaPagamento.getMeioPagamento().equals((Object)NFMeioPagamento.PIX)) {
                NFNotaInfoCartao inforCartao = new NFNotaInfoCartao();
                inforCartao.setTipoIntegracao(NFTipoIntegracaoPagamento.SEPARADO);
                formaPagamento.setCartao(inforCartao);
            }
            detalhamentoFormasPagamento.add(formaPagamento);
            if (pagamento.getValorTroco() == null || pagamento.getValorTroco().compareTo(BigDecimal.ZERO) <= 0) continue;
            valorTroco = valorTroco.add(pagamento.getValorTroco());
        }
        if (valorTroco.compareTo(BigDecimal.ZERO) > 0) {
            pgto.setValorTroco(valorTroco);
        }
        pgto.setDetalhamentoFormasPagamento(detalhamentoFormasPagamento);
        return pgto;
    }

    private NFNotaInfoDestinatario getDestinatario(NFCeDestinatario destinatario) {
        if (destinatario == null) {
            return null;
        }
        NFNotaInfoDestinatario dest = new NFNotaInfoDestinatario();
        if (destinatario.getCpfCnpj().length() < 14) {
            dest.setCpf(MaximaUtils.removeCaracteres((String)destinatario.getCpfCnpj()));
        } else {
            dest.setCnpj(MaximaUtils.removeCaracteres((String)destinatario.getCpfCnpj()));
        }
        String razaoSocial = destinatario.getRazaoSocial() == null || destinatario.getRazaoSocial().trim().isEmpty() ? "CONSUMIDOR" : destinatario.getRazaoSocial();
        dest.setRazaoSocial(razaoSocial);
        dest.setIndicadorIEDestinatario(NFIndicadorIEDestinatario.NAO_CONTRIBUINTE);
        return dest;
    }

    private NFNotaInfoEmitente getEmitente(NFCeEmitente emitente, Configuracao conf) {
        NFEndereco endereco = new NFEndereco();
        endereco.setBairro(MaximaUtils.getText((String)emitente.getBairro()));
        endereco.setCep(MaximaUtils.removeCaracteres((String)emitente.getCep()));
        endereco.setCodigoMunicipio(emitente.getMunicipio().getCodigoIBGE());
        endereco.setCodigoPais("1058");
        endereco.setDescricaoMunicipio(MaximaUtils.getText((String)emitente.getMunicipio().getNome()));
        endereco.setDescricaoPais("BRASIL");
        endereco.setLogradouro(MaximaUtils.getText((String)emitente.getLogradouro()));
        endereco.setNumero(MaximaUtils.getText((String)emitente.getNumero()));
        endereco.setTelefone(MaximaUtils.removeCaracteres((String)emitente.getTelefone()));
        endereco.setUf(DFUnidadeFederativa.valueOfCodigo((String)conf.getEmpresaNFe().getMunicipio().getEstado().getSigla()));
        NFNotaInfoEmitente emit = new NFNotaInfoEmitente();
        emit.setCnpj(MaximaUtils.removeCaracteres((String)emitente.getCpfCnpj()));
        if (conf.getEmpresaNFe().getInscMunicipal() != null && !conf.getEmpresaNFe().getInscMunicipal().isEmpty()) {
            emit.setInscricaoMunicipal(MaximaUtils.removeCaracteres((String)conf.getEmpresaNFe().getInscMunicipal()));
        }
        emit.setEndereco(endereco);
        emit.setInscricaoEstadual(MaximaUtils.removeCaracteres((String)emitente.getIe()));
        emit.setRazaoSocial(MaximaUtils.getText((String)emitente.getRazaoSocial()));
        emit.setRegimeTributario(conf.getEmpresaNFe().getRegime());
        return emit;
    }
}

