/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.fiscal.certificado.AssinaturaDigitalA3;
import br.com.maximasolutions.fiscal.certificado.MaximaCertificado;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEvento;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFInfoEvento;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFTipoEvento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cartacorrecao.NFEnviaEventoCartaCorrecao;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotaFiscalCorrecaoXml {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String EVENTO_CODIGO = "110110";
    private static final String EVENTO_DESCRICAO = "Carta de Correcao";
    private static final String EVENTO_CONDICAO_USO = "A Carta de Correcao e disciplinada pelo paragrafo 1o-A do art. 7o do Convenio S/N, de 15 de dezembro de 1970 e pode ser utilizada para regularizacao de erro ocorrido na emissao de documento fiscal, desde que o erro nao esteja relacionado com: I - as variaveis que determinam o valor do imposto tais como: base de calculo, aliquota, diferenca de preco, quantidade, valor da operacao ou da prestacao; II - a correcao de dados cadastrais que implique mudanca do remetente ou do destinatario; III - a data de emissao ou de saida.";

    public String geraXml(NFeCabecalho nf, String motivo, Configuracao conf, int numeroEvento) throws Exception {
        try {
            NFeConfigMaxima config = new NFeConfigMaxima(conf);
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            String xml = this.gerarDadosCartaCorrecao(nf.getChaveAcesso() + nf.getDigitoChaveAcesso(), motivo, numeroEvento).toString();
            xml = xml.replace("\n", "#");
            return new AssinaturaDigitalA3().assinaCancNFe(xml, config.getCertificadoA3Senha(), conf.getAliasCertificado());
        }
        catch (Exception e) {
            Logger.getLogger(NotaFiscalCorrecaoXml.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new Exception(e);
        }
    }

    public NFEnviaEventoCartaCorrecao gerarDadosCartaCorrecao(String chaveAcesso, String textoCorrecao, int numeroSequencialEvento) {
        NotaFiscalChaveParser chaveParser = new NotaFiscalChaveParser(chaveAcesso);
        NFTipoEvento cartaCorrecao = new NFTipoEvento();
        cartaCorrecao.setVersao(VERSAO_LEIAUTE);
        cartaCorrecao.setDescricaoEvento(EVENTO_DESCRICAO);
        cartaCorrecao.setCondicaoUso(EVENTO_CONDICAO_USO);
        cartaCorrecao.setTextoCorrecao(textoCorrecao);
        DFAmbiente ambiente = DFAmbiente.PRODUCAO;
        if (MaximaConfig.getInstance().getProperty("nfambiente") != null && MaximaConfig.getInstance().getProperty("nfambiente").equalsIgnoreCase("homologacao")) {
            ambiente = DFAmbiente.HOMOLOGACAO;
        }
        NFInfoEvento infoEvento = new NFInfoEvento();
        infoEvento.setAmbiente(ambiente);
        infoEvento.setDadosEvento(cartaCorrecao);
        infoEvento.setChave(chaveAcesso);
        infoEvento.setCnpj(chaveParser.getCnpjEmitente());
        infoEvento.setDataHoraEvento(ZonedDateTime.now());
        infoEvento.setId(String.format("ID%s%s0%s", EVENTO_CODIGO, chaveAcesso, numeroSequencialEvento));
        infoEvento.setNumeroSequencialEvento(numeroSequencialEvento);
        infoEvento.setOrgao(chaveParser.getNFUnidadeFederativa());
        infoEvento.setTipoEvento(EVENTO_CODIGO);
        infoEvento.setVersaoEvento(VERSAO_LEIAUTE);
        NFEvento evento = new NFEvento();
        evento.setInfoEvento(infoEvento);
        evento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCartaCorrecao enviaEvento = new NFEnviaEventoCartaCorrecao();
        enviaEvento.setEvento(Collections.singletonList(evento));
        enviaEvento.setIdLote(Long.toString(System.currentTimeMillis()));
        enviaEvento.setVersao(VERSAO_LEIAUTE);
        return enviaEvento;
    }
}

