/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class NotaFiscalEmail {
    public static void sendMail(NFeCabecalho nfe, Configuracao conf) throws MaximaException {
        String path = MaximaConfig.getInstance().getProperty("fileexport", "C:/Maxima/");
        try {
            MaximaFile.validaDiretorio((String)path);
        }
        catch (MaximaException ex) {
            throw new MaximaException(ex.getMessage());
        }
        String filePdf = path + nfe.getNumero() + "-" + nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso() + "-NFe.pdf";
        String fileXml = path + nfe.getNumero() + "-" + nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso() + "-NFe.xml";
        try {
            PrintReport.exportaPdfXml((String)nfe.getXmlTxt(), (String)filePdf, (String)fileXml);
        }
        catch (MaximaException ex) {
            throw new MaximaException(ex.getMessage());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<h3>").append(conf.getEmpresaNFe().getNome()).append("</h3>");
        builder.append("<p>").append(conf.getEmpresaNFe().getEndereco()).append(" - ").append(conf.getEmpresaNFe().getNumero()).append(" - ").append(conf.getEmpresaNFe().getBairro()).append("</p>");
        builder.append("<p>").append(conf.getEmpresaNFe().getCep()).append(" - ").append(conf.getEmpresaNFe().getMunicipio().getNome()).append("/").append(conf.getEmpresaNFe().getMunicipio().getEstado().getSigla()).append("</p> <br/>");
        builder.append("<h2>ENVIO DE NFE EMITIDA</h2>");
        builder.append("<p>").append("Chave de acesso: <b>").append(nfe.getChaveAcesso()).append(nfe.getDigitoChaveAcesso()).append("</b></p>");
        String username = conf.getEmail();
        String password = conf.getEmailSenha();
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", conf.getEmailHost());
        props.put("mail.smtp.port", conf.getEmailPorta());
        props.put("mail.smtp.ssl.protocols", "TLSv1.2");
        Session session = Session.getInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(username));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(nfe.getCliente().getEmail(), nfe.getCliente().getNome()));
            msg.setSubject("Nota Fiscal Eletr\u00f4nica: " + nfe.getNumero());
            FileDataSource sourceXML = new FileDataSource(fileXml);
            MimeBodyPart messageBodyPartXML = new MimeBodyPart();
            messageBodyPartXML.setContent((Object)builder.toString(), "text/html; charset=utf-8");
            messageBodyPartXML.setDataHandler(new DataHandler((DataSource)sourceXML));
            messageBodyPartXML.setFileName(nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso() + "-NFe.xml");
            FileDataSource sourcePDF = new FileDataSource(filePdf);
            MimeBodyPart messageBodyPartPDF = new MimeBodyPart();
            messageBodyPartPDF.setContent((Object)builder, "text/html; charset=utf-8");
            messageBodyPartPDF.setDataHandler(new DataHandler((DataSource)sourcePDF));
            messageBodyPartPDF.setFileName(nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso() + "-NFe.pdf");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPartXML);
            multipart.addBodyPart((BodyPart)messageBodyPartPDF);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        catch (AddressException e) {
            throw new MaximaException("Ops, falha ao enviar e-mail. " + e.getMessage());
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new MaximaException("Ops, falha ao enviar e-mail. " + e.getMessage());
        }
    }
}

