/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.controller.ProdutoPesquisaController;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoMva;
import br.com.maximasolutions.estoque.service.ProdutoService;
import br.com.maximasolutions.estoque.validacao.ProdutoValidacao;
import br.com.maximasolutions.financeiro.controller.ContaPagarFormController;
import br.com.maximasolutions.fiscal.core.NFeUtil;
import br.com.maximasolutions.fiscal.form.NFIcms900Form;
import br.com.maximasolutions.fiscal.form.NFIpiForm;
import br.com.maximasolutions.fiscal.modelo.GrupoICMS;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.modelo.NFeCobranca;
import br.com.maximasolutions.fiscal.modelo.NFeDestinatario;
import br.com.maximasolutions.fiscal.modelo.NFeDetalhe;
import br.com.maximasolutions.fiscal.modelo.NFeDocumento;
import br.com.maximasolutions.fiscal.modelo.NFeEmitente;
import br.com.maximasolutions.fiscal.modelo.NFeEvento;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.fiscal.modelo.NFeTransportadora;
import br.com.maximasolutions.fiscal.modelo.NFeVeiculo;
import br.com.maximasolutions.fiscal.modelo.Ncm;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Transportadora;
import br.com.maximasolutions.geral.modelo.Veiculo;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.TransportadoraService;
import br.com.maximasolutions.geral.service.VeiculoService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.nfe.controller.NotaFiscalCancelaFormController;
import br.com.maximasolutions.nfe.controller.NotaFiscalController;
import br.com.maximasolutions.nfe.controller.NotaFiscalCorrecaoFormController;
import br.com.maximasolutions.nfe.controller.NotaFiscalFormController;
import br.com.maximasolutions.nfe.controller.NotaFiscalGeraXml;
import br.com.maximasolutions.nfe.controller.NotaFiscalIcmsFormController;
import br.com.maximasolutions.nfe.controller.NotaFiscalIpiFormController;
import br.com.maximasolutions.nfe.controller.NotaFiscalValorFormController;
import br.com.maximasolutions.nfe.repository.GrupoICMSRepository;
import br.com.maximasolutions.nfe.service.GrupoICMSService;
import br.com.maximasolutions.nfe.service.NotaFiscalService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFIndicadorFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.NFModalidadeFrete;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFMeioPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperacaoConsumidorFinal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class NotaFiscalFormController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnEnvia;
    @FXML
    private Button btnImprime;
    @FXML
    private Button btnDestPesquisa;
    @FXML
    private Button btnConsulta;
    @FXML
    private Button btnCancela;
    @FXML
    private Button btnCartaCorrecao;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabDadosGerais;
    @FXML
    private Tab tabDestinatario;
    @FXML
    private Tab tabProdutos;
    @FXML
    private AnchorPane paneDadosGerais;
    @FXML
    private AnchorPane paneDestinatario;
    @FXML
    private AnchorPane paneProdutos;
    @FXML
    private AnchorPane paneCobranca;
    @FXML
    private AnchorPane paneTransporte;
    @FXML
    private AnchorPane paneNfeVinculada;
    @FXML
    private TextField tfStatusNota;
    @FXML
    private TextField tfChaveAcesso;
    @FXML
    private TextField tfSerie;
    @FXML
    private TextField tfNumero;
    @FXML
    private TextField tfDataEmissao;
    @FXML
    private TextField tfDataEntradaSaida;
    @FXML
    private TextField tfHoraEntradaSaida;
    @FXML
    private TextField tfNaturezaOperacao;
    @FXML
    private TextField tfBaseCalculoICMS;
    @FXML
    private TextField tfValorICMS;
    @FXML
    private TextField tfBaseCalculoICMSST;
    @FXML
    private TextField tfValorICMSST;
    @FXML
    private TextField tfValorPIS;
    @FXML
    private TextField tfValorCOFINS;
    @FXML
    private TextField tfValorIPI;
    @FXML
    private TextField tfValorProdutos;
    @FXML
    private TextField tfValorFrete;
    @FXML
    private TextField tfValorOutrasDespesas;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField txtChaveCupom;
    @FXML
    private TextArea tfInfContribuinte;
    @FXML
    private TextArea tfInfFisco;
    @FXML
    private ComboBox<NFTipo> cbbTipoOperacao;
    @FXML
    private ComboBox<NFFinalidade> cbbFinalidade;
    @FXML
    private ComboBox<NFOperacaoConsumidorFinal> cbbConsumidorFinal;
    @FXML
    private TableView<NFeEvento> tabelaEventos;
    @FXML
    private TableColumn<NFeEvento, String> colEventoData;
    @FXML
    private TableColumn<NFeEvento, String> colEventoTipo;
    @FXML
    private TableColumn<NFeEvento, String> colEventoProtocolo;
    @FXML
    private TableColumn<NFeEvento, String> colEventoNumero;
    @FXML
    private TextField tfDestPesquisa;
    @FXML
    private TextField tfDestRazaoSocial;
    @FXML
    private TextField tfDestFantasia;
    @FXML
    private TextField tfDestCnpj;
    @FXML
    private TextField tfDestInscEstadual;
    @FXML
    private TextField tfDestTelefone;
    @FXML
    private TextField tfDestEndereco;
    @FXML
    private TextField tfDestNumero;
    @FXML
    private TextField tfDestBairro;
    @FXML
    private TextField tfDestComplemento;
    @FXML
    private TextField tfDestCep;
    @FXML
    private TextField tfDestMunicipio;
    @FXML
    private TextField tfDestEmail;
    @FXML
    private TextField tfProdutoPesquisa;
    @FXML
    private TextField tfProdutoDescricao;
    @FXML
    private TextField tfProdutoCfop;
    @FXML
    private TextField tfProdutoQuantidade;
    @FXML
    private TextField tfProdutoValorUnitario;
    @FXML
    private TextField tfProdutoValorTotal;
    @FXML
    private ComboBox<Object> cbbProdutoCstCsosn;
    @FXML
    private Button btnProdutoPesquisa;
    @FXML
    private Button btnProdutoAdd;
    @FXML
    private TableView<NFeDetalhe> tabelaProdutos;
    @FXML
    private TableColumn<NFeDetalhe, String> colProdutoItem;
    @FXML
    private TableColumn<NFeDetalhe, String> colProdutoCodigo;
    @FXML
    private TableColumn<NFeDetalhe, String> colProdutoDescricao;
    @FXML
    private TableColumn<NFeDetalhe, String> colProdutoCst;
    @FXML
    private TableColumn<NFeDetalhe, String> colProdutoCfop;
    @FXML
    private TableColumn<NFeDetalhe, String> colProdutoUnidade;
    @FXML
    private TableColumn<NFeDetalhe, BigDecimal> colProdutoQuantidade;
    @FXML
    private TableColumn<NFeDetalhe, BigDecimal> colProdutoValorUnitario;
    @FXML
    private TableColumn<NFeDetalhe, BigDecimal> colProdutoValorTotal;
    @FXML
    private ComboBox<NFIndicadorFormaPagamento> cbbCobrancaCondicaoPagamento;
    @FXML
    private ComboBox<NFMeioPagamento> cbbCobrancaFormaPagamento;
    @FXML
    private Button btnCobrancaAdd;
    @FXML
    private TextField tfCobrancaVencimento;
    @FXML
    private TextField tfCobrancaValor;
    @FXML
    private TableView<NFeCobranca> tabelaCobranca;
    @FXML
    private TableColumn<NFeCobranca, String> colCobrancaNumero;
    @FXML
    private TableColumn<NFeCobranca, String> colCobrancaVencimento;
    @FXML
    private TableColumn<NFeCobranca, String> colCobrancaValor;
    @FXML
    private ComboBox<NFModalidadeFrete> cbbTransporteModalidade;
    @FXML
    private ComboBox<Transportadora> cbbTransporteTransportadora;
    @FXML
    private ComboBox<Veiculo> cbbTransporteVeiculo;
    @FXML
    private TextField tfTransporteEspecie;
    @FXML
    private TextField tfTransporteQuantidade;
    @FXML
    private TextField tfTransportePesoBruto;
    @FXML
    private TextField tfTransportePesoLiquido;
    @FXML
    private TextField tfNfeVinculadaChave;
    @FXML
    private Button btnNfeVinculadaAdd;
    @FXML
    private TableView<NFeDocumento> tabelaNfeVinculada;
    @FXML
    private TableColumn<NFeDocumento, String> colNfeVinculadaChave;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private NotaFiscalService notaFiscalService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private TransportadoraService transportadoraService;
    @Autowired
    private VeiculoService veiculoService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private GrupoICMSService grupoICMSService;
    @Autowired
    private GrupoICMSRepository iCMSRepository;
    @Autowired
    private NcmService ncmService;
    private Configuracao conf;
    private Cliente cliente;
    private NFeCabecalho nfe;
    private NFeEmitente emitente;
    private NFeDestinatario destinatario;
    private NFeTransportadora transportadora;
    private NFeVeiculo veiculo;
    private Produto produto;
    private List<NFeDetalhe> produtoLista;
    private List<NFeCobranca> cobrancaLista;
    private List<NFeDocumento> documentoLista;
    private ObservableList<NFeDetalhe> produtoListaTabela;
    private ObservableList<NFeCobranca> cobrancaListaTabela;
    private ObservableList<NFeDocumento> documentoListaTabela;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaMascaras();
    }

    public void inicializa(Scene scene) {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.NotaFiscal);
        this.carregaAtalhos(scene);
    }

    private void carregaAtalhos(Scene scene) {
        KeyCodeCombination kcF1 = new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]);
        Runnable rnF1 = () -> {
            NFeDetalhe item = (NFeDetalhe)this.tabelaProdutos.getSelectionModel().getSelectedItem();
            NFIpiForm ipiForm = null;
            try {
                Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/nfe/NotaFiscalIpiForm.fxml", "IPI - Valores");
                NotaFiscalIpiFormController controller = (NotaFiscalIpiFormController)form.getUserData();
                controller.inicializa();
                form.showAndWait();
                ipiForm = controller.getIcms900Form();
            }
            catch (IOException ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo para edi\u00e7\u00e3o de icms 900.\n" + ex.getMessage()));
            }
            if (ipiForm != null) {
                this.nfe.setValorIpiDev(ipiForm.getValorDev());
                this.nfe = this.notaFiscalService.atualiza(this.nfe);
                this.loadTabelaProdutos();
            }
        };
        scene.getAccelerators().put((Object)kcF1, (Object)rnF1);
    }

    public boolean inicializa(NFeCabecalho nfe) {
        this.produtoListaTabela = FXCollections.observableArrayList();
        this.cobrancaListaTabela = FXCollections.observableArrayList();
        this.documentoListaTabela = FXCollections.observableArrayList();
        this.conf = this.configuracaoService.load();
        this.carregaCombos();
        if (nfe == null) {
            this.novo();
        } else {
            try {
                nfe = this.notaFiscalService.getById(nfe.getId());
            }
            catch (MaximaValidacaoException ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o foi poss\u00edvel carregar os dados da nota fiscal.");
                return false;
            }
            this.detalha(nfe);
        }
        this.setColumnProperties();
        this.loadBotoes();
        this.loadTabelaProdutos();
        this.loadTabelaCobrancas();
        this.loadTabelaDocumentos();
        return true;
    }

    private void addProduto() throws MaximaException {
        GrupoICMS grupoICMS;
        if (!this.validaProduto().booleanValue()) {
            return;
        }
        MaximaResposta validacaoProdutoResposta = ProdutoValidacao.validaFiscalSimplesNacional((Produto)this.produto);
        if (!validacaoProdutoResposta.getSucesso().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)validacaoProdutoResposta.getMensagem());
            return;
        }
        if (this.produtoLista == null) {
            this.produtoLista = new ArrayList();
        }
        NFeDetalhe item = new NFeDetalhe();
        item.setNumeroItem(Integer.valueOf(this.produtoLista.size() + 1));
        item.setProduto(this.produto);
        item.setNomeProduto(this.produto.getNome().toUpperCase());
        item.setCodigoProduto(this.produto.getCodigo());
        item.setQuantidadeComercial(MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoQuantidade.getText()));
        item.setUnidadeComercial(this.produto.getUnidade().getSigla());
        item.setValorUnitarioComercial(MaximaNumber.moneyToBigDecimal((String)this.tfProdutoValorUnitario.getText()));
        item.setValorBrutoProdutos(MaximaNumber.moneyToBigDecimal((String)this.tfProdutoValorTotal.getText()));
        item.setValorTotal(MaximaNumber.moneyToBigDecimal((String)this.tfProdutoValorTotal.getText()));
        item.setUnidadeTributavel(this.produto.getUnidade().getSigla().toUpperCase());
        item.setQuantidadeTributavel(item.getQuantidadeComercial());
        item.setValorUnitarioTributacao(item.getValorUnitarioComercial());
        item.setValorSubtotal(item.getValorTotal());
        item.setInformacoesAdicionais(this.produto.getInfAdd());
        item.setCfop(Integer.valueOf(this.tfProdutoCfop.getText()));
        item.setNcm(MaximaUtils.getText((String)this.produto.getNcm()));
        item.setOrigemMercadoria(this.produto.getOrigem().getCodigo());
        if (this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            item.setCsosn(((NFNotaSituacaoOperacionalSimplesNacional)this.cbbProdutoCstCsosn.getSelectionModel().getSelectedItem()).getCodigo());
        } else {
            item.setCstIcms(((NFNotaInfoImpostoTributacaoICMS)this.cbbProdutoCstCsosn.getSelectionModel().getSelectedItem()).getCodigo());
        }
        if (this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            item.setCstPis(this.produto.getPis().getCodigo());
            item.setCstCofins(this.produto.getCofins().getCodigo());
        } else {
            item.setValorBaseCalculoPis(item.getValorTotal());
            item.setAliquotaPisPercentual(this.produto.getAliquotaPis());
            item.setValorPis(item.getValorBaseCalculoPis().multiply(item.getAliquotaPisPercentual()).divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_EVEN));
            item.setCstPis(this.produto.getPis().getCodigo());
            item.setBaseCalculoCofins(item.getValorTotal());
            item.setAliquotaCofinsPercentual(this.produto.getAliquotaCofins());
            item.setValorCofins(item.getBaseCalculoCofins().multiply(item.getAliquotaCofinsPercentual()).divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_EVEN));
            item.setCstCofins(this.produto.getCofins().getCodigo());
        }
        if (this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            if (item.getCsosn().equals("202") || item.getCsosn().equals("201")) {
                System.out.println("--- get estado: " + this.destinatario.getMunicipio().getEstado());
                grupoICMS = this.grupoICMSService.getByEstado(this.destinatario.getMunicipio().getEstado());
                item.setAliquotaIcmsSt(grupoICMS.getIcmsInterEstadual());
                item.setPercentualMvaIcmsSt(this.produto.getAliquotaIVA());
                item.setBaseCalculoIcmsSt(item.getValorTotal().multiply(this.produto.getAliquotaIVA().divide(new BigDecimal("100"))).setScale(2, RoundingMode.HALF_UP).add(item.getValorTotal()));
                BigDecimal valorIcms = item.getBaseCalculoIcmsSt().multiply(grupoICMS.getIcmsIntraEstadual().divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
                BigDecimal valorIcmsProprio = item.getValorSubtotal().multiply(grupoICMS.getIcmsInterEstadual().divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
                BigDecimal valorIcmsST = valorIcms.subtract(valorIcmsProprio);
                item.setValorIcmsSt(valorIcmsST);
            }
        } else {
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.TRIBUTACAO_INTEGRALMENTE)) {
                item.setBaseCalculoIcms(item.getValorTotal());
                item.setAliquotaIcms(this.produto.getAliquotaICMS());
                item.setValorIcms(item.getBaseCalculoIcms().multiply(item.getAliquotaIcms()).divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_EVEN));
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA)) {
                item.setCstIcms(NFNotaInfoImpostoTributacaoICMS.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA.getCodigo());
                item.setBaseCalculoIcms(BigDecimal.ZERO);
                item.setAliquotaIcms(BigDecimal.ZERO);
                item.setValorIcms(BigDecimal.ZERO);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA) && !this.cliente.getMunicipio().getEstado().getId().equals(this.conf.getEmpresaNFe().getMunicipio().getEstado().getId())) {
                System.out.println("--- teste 1" + this.destinatario.getMunicipio().getEstado());
                System.out.println("--- teste 2" + this.grupoICMSService);
                grupoICMS = this.grupoICMSService.getByEstado(this.destinatario.getMunicipio().getEstado());
                item.setCstIcms(NFNotaInfoImpostoTributacaoICMS.TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA.getCodigo());
                item.setBaseCalculoIcms(item.getValorTotal());
                item.setAliquotaIcms(grupoICMS.getIcmsInterEstadual());
                item.setValorIcms(item.getBaseCalculoIcms().multiply(item.getAliquotaIcms()).divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_EVEN));
                ProdutoMva mva = this.produtoService.getMva(item.getProduto().getId(), this.destinatario.getMunicipio().getEstado());
                item.setAliquotaIcmsSt(grupoICMS.getIcmsInterEstadual());
                item.setPercentualMvaIcmsSt(mva.getAliquotaIva());
                item.setBaseCalculoIcmsSt(item.getValorTotal().multiply(mva.getAliquotaIva().divide(new BigDecimal("100"))).setScale(2, RoundingMode.HALF_UP).add(item.getValorTotal()));
                BigDecimal valorIcmsProprio = item.getValorSubtotal().multiply(grupoICMS.getIcmsInterEstadual().divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
                BigDecimal valorIcms = item.getBaseCalculoIcmsSt().multiply(grupoICMS.getIcmsIntraEstadual().divide(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP));
                System.out.println("Base Calculo ST: " + item.getBaseCalculoIcmsSt());
                System.out.println("Valor ICMS:" + valorIcms);
                System.out.println("Valor ICMS Pr\u00f3prio: " + valorIcmsProprio);
                BigDecimal valorIcmsST = valorIcms.subtract(valorIcmsProprio);
                item.setValorIcmsSt(valorIcmsST);
            }
        }
        try {
            Ncm ncm = this.ncmService.loadByNCM(Long.parseLong(item.getNcm()));
            if (ncm == null) {
                throw new MaximaException("NCM n\u00e3o encontrado na tabela do banco de dados.");
            }
            item.setTributoNacional(ncm.getAliqNac().multiply(item.getValorTotal()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
            item.setTributoEstadual(ncm.getAliqEstadual().multiply(item.getValorTotal()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MaximaException("NCM n\u00e3o encontrado na tabela do banco de dados.");
        }
        this.produtoLista.add(item);
        this.loadTabelaProdutos();
        this.inicializaItem();
    }

    private void deleteProduto() {
        NFeDetalhe item = (NFeDetalhe)this.tabelaProdutos.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        int count = 0;
        for (NFeDetalhe i : this.produtoLista) {
            if (i.getNumeroItem().equals(item.getNumeroItem())) {
                this.produtoLista.remove(count);
                break;
            }
            ++count;
        }
        this.loadTabelaProdutos();
        this.inicializaItem();
    }

    private void produtoCalculaTotal() {
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfProdutoValorTotal.setText("0,00");
            return;
        }
        BigDecimal valorUnitario = MaximaNumber.moneyToBigDecimal((String)this.tfProdutoValorUnitario.getText());
        if (valorUnitario == null || valorUnitario.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfProdutoValorTotal.setText("0,00");
            return;
        }
        BigDecimal valorTotalItem = quantidade.multiply(valorUnitario).setScale(2, RoundingMode.HALF_EVEN);
        this.tfProdutoValorTotal.setText(MaximaNumber.formataNumero((BigDecimal)valorTotalItem));
    }

    private Boolean validaProduto() {
        boolean valido = true;
        if (this.produto == null) {
            this.tfProdutoPesquisa.getStyleClass().add((Object)"error");
            this.tfProdutoDescricao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoPesquisa.getStyleClass().remove((Object)"error");
            this.tfProdutoDescricao.getStyleClass().remove((Object)"error");
        }
        if (this.cbbProdutoCstCsosn.getSelectionModel().getSelectedItem() == null) {
            this.cbbProdutoCstCsosn.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbProdutoCstCsosn.getStyleClass().remove((Object)"error");
        }
        if (this.tfProdutoCfop.getText() == null || this.tfProdutoCfop.getText().length() != 4) {
            this.tfProdutoCfop.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoCfop.getStyleClass().remove((Object)"error");
        }
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoQuantidade.getText());
        if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfProdutoQuantidade.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoQuantidade.getStyleClass().remove((Object)"error");
        }
        BigDecimal valorUnitario = MaximaNumber.quantidadeToBigDecimal((String)this.tfProdutoValorUnitario.getText());
        if (valorUnitario == null || valorUnitario.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfProdutoValorUnitario.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfProdutoValorUnitario.getStyleClass().remove((Object)"error");
        }
        if (!valido) {
            this.tabPane.getSelectionModel().select((Object)this.tabProdutos);
        }
        return valido;
    }

    private Boolean validaDadosGerais() {
        boolean valido = true;
        try {
            Integer serie = Integer.parseInt(this.tfSerie.getText());
            this.tfSerie.getStyleClass().remove((Object)"error");
        }
        catch (NumberFormatException numberFormatException) {
            this.tfSerie.getStyleClass().add((Object)"error");
            valido = false;
        }
        try {
            Integer numero = Integer.parseInt(this.tfNumero.getText());
            this.tfNumero.getStyleClass().remove((Object)"error");
        }
        catch (NumberFormatException numberFormatException) {
            this.tfNumero.getStyleClass().add((Object)"error");
            valido = false;
        }
        LocalDate dataEmissao = MaximaDate.convertToLocalDate((String)this.tfDataEmissao.getText());
        if (dataEmissao == null) {
            this.tfDataEmissao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataEmissao.getStyleClass().remove((Object)"error");
        }
        String naturezaOperacao = MaximaUtils.getText((String)this.tfNaturezaOperacao.getText());
        if (naturezaOperacao == null || naturezaOperacao.isEmpty()) {
            this.tfNaturezaOperacao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNaturezaOperacao.getStyleClass().remove((Object)"error");
        }
        if (!valido) {
            this.tabPane.getSelectionModel().select((Object)this.tabDadosGerais);
        }
        if (this.cliente == null) {
            this.tabDestinatario.getStyleClass().add((Object)"error");
            if (valido) {
                this.tabPane.getSelectionModel().select((Object)this.tabDestinatario);
            }
            valido = false;
        } else {
            this.tabDestinatario.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaCliente() {
        String endereco;
        boolean valido = true;
        String cpf = MaximaUtils.removeCaracteres((String)this.cliente.getCpf());
        if (cpf == null || cpf.isEmpty()) {
            valido = false;
            this.tfDestCnpj.getStyleClass().add((Object)"error");
        } else {
            this.tfDestCnpj.getStyleClass().remove((Object)"error");
        }
        if (valido && cpf != null && cpf.length() > 11) {
            String inscEstadual = MaximaUtils.removeCaracteres((String)this.cliente.getRg());
            if (inscEstadual == null || inscEstadual.isEmpty()) {
                valido = false;
                this.tfDestInscEstadual.getStyleClass().add((Object)"error");
            } else {
                this.tfDestInscEstadual.getStyleClass().remove((Object)"error");
            }
        }
        if ((endereco = MaximaUtils.getText((String)this.cliente.getEndereco())) == null || endereco.isEmpty()) {
            valido = false;
            this.tfDestEndereco.getStyleClass().add((Object)"error");
        } else {
            this.tfDestEndereco.getStyleClass().remove((Object)"error");
        }
        String numero = MaximaUtils.getText((String)this.cliente.getNumero());
        if (numero == null || numero.isEmpty()) {
            valido = false;
            this.tfDestNumero.getStyleClass().add((Object)"error");
        } else {
            this.tfDestNumero.getStyleClass().remove((Object)"error");
        }
        String bairro = MaximaUtils.getText((String)this.cliente.getBairro());
        if (bairro == null || bairro.isEmpty()) {
            valido = false;
            this.tfDestBairro.getStyleClass().add((Object)"error");
        } else {
            this.tfDestBairro.getStyleClass().remove((Object)"error");
        }
        String cep = MaximaUtils.removeCaracteres((String)this.cliente.getCep());
        if (cep == null || cep.isEmpty()) {
            valido = false;
            this.tfDestCep.getStyleClass().add((Object)"error");
        } else {
            this.tfDestCep.getStyleClass().remove((Object)"error");
        }
        if (this.cliente.getMunicipio() == null) {
            valido = false;
            this.tfDestMunicipio.getStyleClass().add((Object)"error");
        } else {
            this.tfDestMunicipio.getStyleClass().remove((Object)"error");
        }
        if (!valido) {
            this.tabPane.getSelectionModel().select((Object)this.tabDestinatario);
        }
        return valido;
    }

    private Boolean validaTransporteCarga() {
        boolean valido = true;
        String especie = MaximaUtils.getText((String)this.tfTransporteEspecie.getText());
        BigDecimal quantidade = MaximaNumber.quantidadeToBigDecimal((String)this.tfTransporteQuantidade.getText());
        BigDecimal pesoBruto = MaximaNumber.quantidadeToBigDecimal((String)this.tfTransportePesoBruto.getText());
        BigDecimal pesoLiquido = MaximaNumber.quantidadeToBigDecimal((String)this.tfTransportePesoLiquido.getText());
        if (especie != null && !especie.isEmpty() || quantidade != null && quantidade.compareTo(BigDecimal.ZERO) > 0 || pesoBruto != null && pesoBruto.compareTo(BigDecimal.ZERO) > 0 || pesoLiquido != null && pesoLiquido.compareTo(BigDecimal.ZERO) > 0) {
            if (especie == null || especie.isEmpty()) {
                valido = false;
                this.tfTransporteEspecie.getStyleClass().add((Object)"error");
            } else {
                this.tfTransporteEspecie.getStyleClass().remove((Object)"error");
            }
            if (quantidade == null || quantidade.compareTo(BigDecimal.ZERO) <= 0) {
                valido = false;
                this.tfTransporteQuantidade.getStyleClass().add((Object)"error");
            } else {
                this.tfTransporteQuantidade.getStyleClass().remove((Object)"error");
            }
            if (pesoBruto == null || pesoBruto.compareTo(BigDecimal.ZERO) <= 0) {
                valido = false;
                this.tfTransportePesoBruto.getStyleClass().add((Object)"error");
            } else {
                this.tfTransportePesoBruto.getStyleClass().remove((Object)"error");
            }
            if (pesoLiquido == null || pesoLiquido.compareTo(BigDecimal.ZERO) <= 0) {
                valido = false;
                this.tfTransportePesoLiquido.getStyleClass().add((Object)"error");
            } else {
                this.tfTransportePesoLiquido.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private String getCodigoNumero() {
        long cod = (long)(Math.random() * 9.9999999E7);
        String codigo = String.valueOf(cod);
        while (codigo.length() < 8) {
            cod = (long)(Math.random() * 9.9999999E7);
            codigo = String.valueOf(cod);
        }
        return codigo;
    }

    private void setChaveAcesso() {
        String ibge = DFUnidadeFederativa.valueOfCodigo((String)this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla()).getCodigoIbge();
        String ano = this.nfe.getDataEmissao().format(DateTimeFormatter.ofPattern("yy"));
        String mes = this.nfe.getDataEmissao().format(DateTimeFormatter.ofPattern("MM"));
        String cnpj = this.nfe.getEmpresa().getCpf();
        String codModelo = this.nfe.getCodigoModelo();
        String serie = MaximaUtils.completaZeroEsquerda((String)this.nfe.getSerie().trim(), (Integer)3);
        String numero = MaximaUtils.completaZeroEsquerda((String)this.nfe.getNumero().trim(), (Integer)9);
        String codNumerico = this.nfe.getCodigoNumerico();
        if (codNumerico == null || codNumerico.isEmpty()) {
            codNumerico = this.getCodigoNumero();
        }
        String chaveAcesso = ibge + ano + mes + cnpj + codModelo + serie + numero + "1" + codNumerico;
        String digChaveAcesso = NFeUtil.modulo11((String)chaveAcesso).toString();
        this.nfe.setChaveAcesso(chaveAcesso);
        this.nfe.setDigitoChaveAcesso(digChaveAcesso);
        this.nfe.setCodigoNumerico(codNumerico);
    }

    private void visualizarNota() {
        try {
            this.nfe = this.getNFe(Boolean.valueOf(true));
            NFNota nota = new NotaFiscalGeraXml().getNFNota(this.nfe, this.destinatario, this.emitente, this.produtoLista, this.conf, this.transportadora, this.veiculo, this.cobrancaLista, this.documentoLista, this.iCMSRepository.get(DFUnidadeFederativa.valueOfCodigo((String)this.destinatario.getUf())));
            String arquivoXml = "danfe.xml";
            File file = new File(arquivoXml);
            try (FileOutputStream out = new FileOutputStream(file);){
                ((OutputStream)out).write(nota.toString().getBytes("UTF-8"));
            }
            catch (Exception ex) {
                Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!file.exists()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o foi poss\u00edvel carregar o arquivo XML.");
                return;
            }
            try {
                new PrintReport().showPreDanfe(file);
            }
            catch (ClassNotFoundException | SQLException | JRException ex) {
                Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel visualizar nota fiscal.\n" + ex.getMessage()));
            }
        }
        catch (MaximaException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ops. N\u00e3o foi poss\u00edvel visualizar a NFe.\nVerifique se todos os campos obrigat\u00f3rios est\u00e3o preenchidos.");
        }
    }

    private void imprimeNota() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_IMPRIMIR).booleanValue()) {
            return;
        }
        if (this.nfe.getStatusNota().equals((Object)NFeStatus.EM_DIGITACAO)) {
            this.visualizarNota();
            return;
        }
        String arquivoXml = "danfe.xml";
        File file = new File(arquivoXml);
        try (FileOutputStream out = new FileOutputStream(file);){
            String textoXml = this.nfe.getXmlTxt().replace("#", "\n");
            ((OutputStream)out).write(textoXml.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!file.exists()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o foi poss\u00edvel carregar o arquivo XML.");
            return;
        }
        try {
            new PrintReport().showDanfe(file);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(NotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: N\u00e3o foi poss\u00edvel visualizar nota fiscal.\n" + ex.getMessage()));
        }
    }

    private void salva(boolean exibeMensagem, Boolean gerarChave) {
        try {
            if (!this.validaDadosGerais().booleanValue()) {
                return;
            }
            if (!this.validaCliente().booleanValue()) {
                return;
            }
            if (!this.validaTransporteCarga().booleanValue()) {
                return;
            }
            this.nfe = this.notaFiscalService.salva(this.getNFe(gerarChave), this.getEmitente(), this.getDestinatario(), this.produtoLista, this.cobrancaLista, this.documentoLista, this.getTransportadora(), this.getVeiculo());
            this.tfChaveAcesso.setText(this.nfe.getChaveAcesso() + this.nfe.getDigitoChaveAcesso());
            this.detalha(this.nfe);
            if (exibeMensagem) {
                MaximaAlert.informe((StageManager)this.stageManager, (String)"NF-e salva com sucesso.");
            }
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private NFeCabecalho getNFe(Boolean gerarChave) {
        if (this.nfe == null || this.nfe.getId() == null) {
            this.nfe = new NFeCabecalho();
        }
        this.nfe.setEmpresa(this.conf.getEmpresaNFe());
        this.nfe.setNumero(this.tfNumero.getText().trim());
        this.nfe.setDataEmissao(MaximaDate.convertToLocalDate((String)this.tfDataEmissao.getText()));
        if (this.tfDataEntradaSaida.getText() != null && !this.tfDataEntradaSaida.getText().isEmpty()) {
            this.nfe.setDataEntradaSaida(MaximaDate.convertToLocalDate((String)this.tfDataEntradaSaida.getText()));
            this.nfe.setHoraEntradaSaida(this.tfHoraEntradaSaida.getText().trim());
        } else {
            this.nfe.setDataEntradaSaida(null);
            this.nfe.setHoraEntradaSaida(null);
        }
        this.nfe.setCodigoModelo("55");
        this.nfe.setTipoOperacao((NFTipo)this.cbbTipoOperacao.getSelectionModel().getSelectedItem());
        this.nfe.setFinalidadeEmissao((NFFinalidade)this.cbbFinalidade.getSelectionModel().getSelectedItem());
        this.nfe.setTipoEmissao(NFTipoEmissao.EMISSAO_NORMAL);
        this.nfe.setNaturezaOperacao(MaximaUtils.getText((String)this.tfNaturezaOperacao.getText()));
        this.nfe.setStatusNota(NFeStatus.EM_DIGITACAO);
        this.nfe.setSerie(MaximaUtils.completaZeroEsquerda((String)this.tfSerie.getText().trim(), (Integer)2));
        this.nfe.setValorFrete(MaximaNumber.moneyToBigDecimal((String)this.tfValorFrete.getText()));
        this.nfe.setValorDespesasAcessorias(MaximaNumber.moneyToBigDecimal((String)this.tfValorOutrasDespesas.getText()));
        this.nfe.setValorSeguro(MaximaNumber.moneyToBigDecimal((String)this.tfValorIPI.getText()));
        this.nfe.setValorDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfValorDesconto.getText()));
        this.nfe.setValorTotal(MaximaNumber.moneyToBigDecimal((String)this.tfValorTotal.getText()));
        this.nfe.setValorTotalProdutos(MaximaNumber.moneyToBigDecimal((String)this.tfValorProdutos.getText()));
        this.nfe.setInformacoesAddContribuinte(MaximaUtils.getText((String)this.tfInfContribuinte.getText()));
        this.nfe.setBaseCalculoIcms(MaximaNumber.moneyToBigDecimal((String)this.tfBaseCalculoICMS.getText()));
        this.nfe.setValorIpi(MaximaNumber.moneyToBigDecimal((String)this.tfValorIPI.getText()));
        this.nfe.setValorCofins(MaximaNumber.moneyToBigDecimal((String)this.tfValorCOFINS.getText()));
        this.nfe.setValorPis(MaximaNumber.moneyToBigDecimal((String)this.tfValorPIS.getText()));
        this.nfe.setValorIcms(MaximaNumber.moneyToBigDecimal((String)this.tfValorICMS.getText()));
        this.nfe.setBaseCalculoIcmsSt(MaximaNumber.moneyToBigDecimal((String)this.tfBaseCalculoICMSST.getText()));
        this.nfe.setValorIcmsSt(MaximaNumber.moneyToBigDecimal((String)this.tfValorICMSST.getText()));
        this.nfe.setConsumidorFinal((NFOperacaoConsumidorFinal)this.cbbConsumidorFinal.getSelectionModel().getSelectedItem());
        this.nfe.setCliente(this.cliente);
        this.nfe.setCondicaoPagamento((NFIndicadorFormaPagamento)this.cbbCobrancaCondicaoPagamento.getSelectionModel().getSelectedItem());
        this.nfe.setFormaPagamento((NFMeioPagamento)this.cbbCobrancaFormaPagamento.getSelectionModel().getSelectedItem());
        this.nfe.setModalidadeFrete((NFModalidadeFrete)this.cbbTransporteModalidade.getSelectionModel().getSelectedItem());
        this.nfe.setTransportadora((Transportadora)this.cbbTransporteTransportadora.getSelectionModel().getSelectedItem());
        this.nfe.setVeiculo((Veiculo)this.cbbTransporteVeiculo.getSelectionModel().getSelectedItem());
        this.nfe.setTranspEspecie(MaximaUtils.getText((String)this.tfTransporteEspecie.getText()));
        this.nfe.setTranspQuantidade(MaximaNumber.quantidadeToBigDecimal((String)this.tfTransporteQuantidade.getText()));
        this.nfe.setTranspPesoBruto(MaximaNumber.quantidadeToBigDecimal((String)this.tfTransportePesoBruto.getText()));
        this.nfe.setTranspPesoLiquido(MaximaNumber.quantidadeToBigDecimal((String)this.tfTransportePesoLiquido.getText()));
        if (gerarChave.booleanValue()) {
            this.setChaveAcesso();
        }
        if (this.txtChaveCupom.getText() != null) {
            this.nfe.setCupomSatRef(this.txtChaveCupom.getText().replace(" ", ""));
        }
        return this.nfe;
    }

    private NFeVeiculo getVeiculo() {
        Veiculo veic = (Veiculo)this.cbbTransporteVeiculo.getSelectionModel().getSelectedItem();
        if (veic == null) {
            return null;
        }
        if (this.veiculo == null || this.veiculo.getId() == null) {
            this.veiculo = new NFeVeiculo();
        }
        this.veiculo.setPlaca(MaximaUtils.removeCaracteres((String)veic.getPlaca()));
        this.veiculo.setUf(veic.getEstado().getSigla());
        this.veiculo.setVeiculo(veic);
        return this.veiculo;
    }

    private NFeTransportadora getTransportadora() {
        Transportadora transp = (Transportadora)this.cbbTransporteTransportadora.getSelectionModel().getSelectedItem();
        if (transp == null) {
            return null;
        }
        if (this.transportadora == null || this.transportadora.getId() == null) {
            this.transportadora = new NFeTransportadora();
        }
        this.transportadora.setCodigoMunicipio(Integer.valueOf(Integer.parseInt(transp.getMunicipio().getCodigoIBGE())));
        this.transportadora.setCpfCnpj(MaximaUtils.removeCaracteres((String)transp.getCpf()));
        this.transportadora.setInscEstadual(MaximaUtils.getText((String)transp.getRg()));
        this.transportadora.setLogradouro(MaximaUtils.getText((String)(transp.getEndereco() + ", " + transp.getNumero())));
        this.transportadora.setMunicipio(transp.getMunicipio());
        this.transportadora.setNomeMunicipio(MaximaUtils.getText((String)transp.getMunicipio().getNome()));
        this.transportadora.setRazaoSocial(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)transp.getNome()), (int)60));
        this.transportadora.setUf(transp.getMunicipio().getEstado().getSigla());
        return this.transportadora;
    }

    private NFeDestinatario getDestinatario() {
        if (this.cliente == null) {
            return null;
        }
        if (this.destinatario == null || this.destinatario.getId() == null) {
            this.destinatario = new NFeDestinatario();
        }
        this.destinatario.setBairro(MaximaUtils.getText((String)this.cliente.getBairro()));
        this.destinatario.setCep(MaximaUtils.removeCaracteres((String)this.cliente.getCep()));
        this.destinatario.setCodigoMunicipio(Integer.valueOf(Integer.parseInt(this.cliente.getMunicipio().getCodigoIBGE())));
        this.destinatario.setCodigoPais(Integer.valueOf(1058));
        if (this.cliente.getComplemento() != null && !this.cliente.getComplemento().isEmpty()) {
            this.destinatario.setComplemento(MaximaUtils.getText((String)this.cliente.getComplemento()));
        }
        this.destinatario.setCpfCnpj(MaximaUtils.removeCaracteres((String)this.cliente.getCpf()));
        if (this.cliente.getEmail() != null && !this.cliente.getEmail().isEmpty()) {
            this.destinatario.setEmail(MaximaUtils.getText((String)this.cliente.getEmail()));
        }
        if (this.cliente.getFantasia() != null && !this.cliente.getFantasia().isEmpty()) {
            this.destinatario.setFantasia(MaximaUtils.getText((String)this.cliente.getFantasia()));
        }
        this.destinatario.setIe(MaximaUtils.removeCaracteres((String)this.cliente.getRg()));
        this.destinatario.setLogradouro(MaximaUtils.getText((String)this.cliente.getEndereco()));
        this.destinatario.setMunicipio(this.cliente.getMunicipio());
        this.destinatario.setNomeMunicipio(MaximaUtils.getText((String)this.cliente.getMunicipio().getNome()));
        this.destinatario.setNomePais("BRASIL");
        this.destinatario.setNumero(MaximaUtils.getText((String)this.cliente.getNumero()));
        this.destinatario.setRazaoSocial(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)this.cliente.getNome()), (int)60));
        if (this.cliente.getTelefone() != null && !this.cliente.getTelefone().isEmpty()) {
            this.destinatario.setTelefone(MaximaUtils.removeCaracteres((String)this.cliente.getTelefone()));
        }
        this.destinatario.setUf(this.cliente.getMunicipio().getEstado().getSigla());
        return this.destinatario;
    }

    private NFeEmitente getEmitente() {
        if (this.conf == null || this.conf.getEmpresaNFe() == null) {
            return null;
        }
        if (this.emitente == null || this.emitente.getId() == null) {
            this.emitente = new NFeEmitente();
        }
        this.emitente.setBairro(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getBairro()));
        this.emitente.setCep(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCep()));
        this.emitente.setCodigoMunicipio(Integer.valueOf(Integer.parseInt(this.conf.getEmpresaNFe().getMunicipio().getCodigoIBGE())));
        this.emitente.setCodigoPais(Integer.valueOf(1058));
        this.emitente.setCpfCnpj(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getCpf()));
        if (this.conf.getEmpresaNFe().getFantasia() != null && !this.conf.getEmpresaNFe().getFantasia().isEmpty()) {
            this.emitente.setFantasia(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getFantasia()));
        }
        this.emitente.setIe(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getRg()));
        this.emitente.setLogradouro(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getEndereco()));
        this.emitente.setMunicipio(this.conf.getEmpresaNFe().getMunicipio());
        this.emitente.setNomeMunicipio(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getMunicipio().getNome()));
        this.emitente.setNomePais("BRASIL");
        this.emitente.setNumero(MaximaUtils.getText((String)this.conf.getEmpresaNFe().getNumero()));
        this.emitente.setRazaoSocial(MaximaUtils.limitaTexto((String)MaximaUtils.getText((String)this.conf.getEmpresaNFe().getNome()), (int)60));
        if (this.conf.getEmpresaNFe().getTelefone() != null && !this.conf.getEmpresaNFe().getTelefone().isEmpty()) {
            this.emitente.setTelefone(MaximaUtils.removeCaracteres((String)this.conf.getEmpresaNFe().getTelefone()));
        }
        this.emitente.setUf(this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
        return this.emitente;
    }

    private void inicializaItem() {
        this.produto = null;
        this.tfProdutoPesquisa.setText("");
        this.tfProdutoDescricao.setText("");
        this.tfProdutoCfop.setText("");
        this.tfProdutoQuantidade.setText("");
        this.tfProdutoValorUnitario.setText("");
        this.tfProdutoValorTotal.setText("");
        this.cbbProdutoCstCsosn.getSelectionModel().select(-1);
        this.tfProdutoPesquisa.requestFocus();
    }

    private void novo() {
        this.cliente = null;
        this.nfe = null;
        this.destinatario = null;
        this.emitente = null;
        this.produtoLista = new ArrayList();
        this.cobrancaLista = new ArrayList();
        this.documentoLista = new ArrayList();
        this.transportadora = null;
        this.veiculo = null;
        this.tfStatusNota.setText(NFeStatus.EM_DIGITACAO.toString());
        this.tfChaveAcesso.setText("");
        this.cbbTipoOperacao.getSelectionModel().select((Object)NFTipo.SAIDA);
        this.cbbFinalidade.getSelectionModel().select((Object)NFFinalidade.NORMAL);
        this.cbbConsumidorFinal.getSelectionModel().select((Object)NFOperacaoConsumidorFinal.SIM);
        String serie = MaximaConfig.getInstance().getProperty("nfserie", "01");
        this.tfSerie.setText(MaximaUtils.completaZeroEsquerda((String)serie, (Integer)2));
        try {
            this.tfNumero.setText(this.notaFiscalService.getProximoNumero(serie).toString());
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
        this.tfDataEmissao.setText(MaximaDate.getData((LocalDate)LocalDate.now()));
        this.tfDataEntradaSaida.setText("");
        this.tfHoraEntradaSaida.setText("");
        if (this.conf.getNfeNaturezaOperacao() != null && !this.conf.getNfeNaturezaOperacao().isEmpty()) {
            this.tfNaturezaOperacao.setText(this.conf.getNfeNaturezaOperacao().toUpperCase());
        } else {
            this.tfNaturezaOperacao.setText("VENDA DE PRODUTO");
        }
        this.tfBaseCalculoICMS.setText("0,00");
        this.tfValorICMS.setText("0,00");
        this.tfBaseCalculoICMSST.setText("0,00");
        this.tfValorICMSST.setText("0,00");
        this.tfValorPIS.setText("0,00");
        this.tfValorCOFINS.setText("0,00");
        this.tfValorIPI.setText("0,00");
        this.tfValorProdutos.setText("0,00");
        this.tfValorFrete.setText("0,00");
        this.tfValorOutrasDespesas.setText("0,00");
        this.tfValorDesconto.setText("0,00");
        this.tfValorTotal.setText("0,00");
        if (this.conf.getInfContNfe() != null && !this.conf.getInfContNfe().isEmpty()) {
            this.tfInfContribuinte.setText(this.conf.getInfContNfe());
        } else {
            this.tfInfContribuinte.setText("");
        }
        this.tfInfFisco.setText("");
        this.tfTransporteEspecie.setText("");
        this.tfTransportePesoBruto.setText("");
        this.tfTransportePesoLiquido.setText("");
        this.tfTransporteQuantidade.setText("");
        this.loadDestinatario(null);
        this.inicializaItem();
    }

    private void detalha(NFeCabecalho nfe) {
        this.nfe = nfe;
        this.cliente = this.nfe.getCliente();
        this.emitente = this.notaFiscalService.getEmitente(nfe);
        this.destinatario = this.notaFiscalService.getDestinatario(nfe);
        this.produtoLista = this.notaFiscalService.listaProdutos(nfe);
        this.cobrancaLista = this.notaFiscalService.listaCobrancas(nfe);
        this.documentoLista = this.notaFiscalService.listaDocumentos(nfe);
        this.transportadora = this.notaFiscalService.getTransportadora(nfe);
        this.veiculo = this.notaFiscalService.getVeiculo(nfe);
        this.tfStatusNota.setText(nfe.getStatusNota().toString());
        this.tfChaveAcesso.setText(nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso());
        this.cbbTipoOperacao.getSelectionModel().select((Object)nfe.getTipoOperacao());
        this.cbbFinalidade.getSelectionModel().select((Object)nfe.getFinalidadeEmissao());
        this.cbbConsumidorFinal.getSelectionModel().select((Object)nfe.getConsumidorFinal());
        String serie = nfe.getSerie();
        this.tfSerie.setText(MaximaUtils.completaZeroEsquerda((String)serie, (Integer)2));
        this.tfNumero.setText(nfe.getNumero());
        this.tfDataEmissao.setText(MaximaDate.getData((LocalDate)nfe.getDataEmissao()));
        this.tfDataEntradaSaida.setText(MaximaDate.getData((LocalDate)nfe.getDataEntradaSaida()));
        this.tfHoraEntradaSaida.setText(nfe.getHoraEntradaSaida());
        this.tfNaturezaOperacao.setText(nfe.getNaturezaOperacao());
        this.tfBaseCalculoICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getBaseCalculoIcms(), (int)2));
        this.tfValorICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorIcms(), (int)2));
        this.tfBaseCalculoICMSST.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getBaseCalculoIcmsSt(), (int)2));
        this.tfValorICMSST.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorIcmsSt(), (int)2));
        this.tfValorPIS.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorPis(), (int)2));
        this.tfValorCOFINS.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorCofins(), (int)2));
        this.tfValorIPI.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorIpi(), (int)2));
        this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorTotalProdutos(), (int)2));
        this.tfValorFrete.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorFrete(), (int)2));
        this.tfValorOutrasDespesas.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorDespesasAcessorias(), (int)2));
        this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorDesconto(), (int)2));
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getValorTotal(), (int)2));
        this.tfInfContribuinte.setText(nfe.getInformacoesAddContribuinte());
        this.tfInfFisco.setText(nfe.getInformacoesAddFisco());
        this.loadDestinatario(nfe.getCliente());
        this.cbbCobrancaCondicaoPagamento.getSelectionModel().select((Object)nfe.getCondicaoPagamento());
        this.cbbCobrancaFormaPagamento.getSelectionModel().select((Object)nfe.getFormaPagamento());
        this.cbbTransporteModalidade.getSelectionModel().select((Object)nfe.getModalidadeFrete());
        this.cbbTransporteTransportadora.getSelectionModel().select((Object)nfe.getTransportadora());
        this.cbbTransporteVeiculo.getSelectionModel().select((Object)nfe.getVeiculo());
        this.tfTransporteEspecie.setText(nfe.getTranspEspecie());
        this.tfTransporteQuantidade.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getTranspQuantidade(), (int)0));
        this.tfTransportePesoBruto.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getTranspPesoBruto(), (int)2));
        this.tfTransportePesoLiquido.setText(MaximaNumber.bigDecimalToString((BigDecimal)nfe.getTranspPesoLiquido(), (int)2));
        this.txtChaveCupom.setText(nfe.getCupomSatRef());
        if (!nfe.getStatusNota().equals((Object)NFeStatus.EM_DIGITACAO)) {
            this.paneDadosGerais.setDisable(true);
            this.paneDestinatario.setDisable(true);
            this.paneProdutos.setDisable(true);
            this.paneCobranca.setDisable(true);
            this.paneTransporte.setDisable(true);
            this.paneNfeVinculada.setDisable(true);
        }
    }

    private void loadDestinatario(Cliente cliente) {
        if (cliente == null) {
            this.tfDestPesquisa.setText("");
            this.tfDestRazaoSocial.setText("");
            this.tfDestFantasia.setText("");
            this.tfDestCnpj.setText("");
            this.tfDestInscEstadual.setText("");
            this.tfDestTelefone.setText("");
            this.tfDestEndereco.setText("");
            this.tfDestNumero.setText("");
            this.tfDestBairro.setText("");
            this.tfDestComplemento.setText("");
            this.tfDestCep.setText("");
            this.tfDestMunicipio.setText("");
            this.tfDestEmail.setText("");
        } else {
            this.tfDestPesquisa.setText(cliente.getId().toString());
            this.tfDestRazaoSocial.setText(cliente.getNome());
            this.tfDestFantasia.setText(cliente.getFantasia());
            this.tfDestCnpj.setText(cliente.getCpf());
            this.tfDestInscEstadual.setText(cliente.getRg());
            this.tfDestTelefone.setText(cliente.getTelefone());
            this.tfDestEndereco.setText(cliente.getEndereco());
            this.tfDestNumero.setText(cliente.getNumero());
            this.tfDestBairro.setText(cliente.getBairro());
            this.tfDestComplemento.setText(cliente.getComplemento());
            this.tfDestCep.setText(cliente.getCep());
            this.tfDestMunicipio.setText(cliente.getMunicipio().toString());
            this.tfDestEmail.setText(cliente.getEmail());
            this.validaCliente();
        }
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva(true, Boolean.valueOf(false)));
        this.btnConsulta.setOnAction(evt -> {
            if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_EMITIR).booleanValue()) {
                return;
            }
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Consultando status nota fiscal.......");
            progress.show();
            this.consultNFe(progress);
        });
        this.btnEnvia.setOnAction(evt -> {
            if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_EMITIR).booleanValue()) {
                return;
            }
            if (this.nfe == null || this.nfe.getId() == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Salve a nota fiscal antes de transmitir.");
                return;
            }
            if (this.nfe.getCondicaoPagamento() == null || this.nfe.getFormaPagamento() == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe as condi\u00e7\u00f5es de pagamento (cobran\u00e7a).");
                return;
            }
            if (this.nfe.getModalidadeFrete() == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a modalidade do frete.");
                return;
            }
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Enviando nota fiscal.......");
            progress.show();
            this.enviaNFe(progress);
        });
        this.btnCancela.setOnAction(evt -> {
            if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_CANCELAR).booleanValue()) {
                return;
            }
            String motivo = "";
            try {
                Stage formCancela = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/nfe/NotaFiscalCancelaForm.fxml", "Cancelamento de nota fiscal");
                NotaFiscalCancelaFormController controller = (NotaFiscalCancelaFormController)formCancela.getUserData();
                controller.inicializa();
                formCancela.showAndWait();
                motivo = controller.getMotivo();
            }
            catch (IOException e) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo de cancelamento de nota fiscal.");
            }
            if (motivo == null || motivo.isEmpty() || motivo.length() < 15) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum motivo v\u00e1lido informado para cancelamento da nota fiscal.\nO motivo deve conter no m\u00ednimo 15 caracteres.");
                return;
            }
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Cancelando nota fiscal.......");
            progress.show();
            this.cancelaNFe(progress, motivo);
        });
        this.btnCartaCorrecao.setOnAction(evt -> {
            if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.NFE_CORRECAO).booleanValue()) {
                return;
            }
            String correcao = "";
            try {
                Stage formCorrecao = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/nfe/NotaFiscalCorrecaoForm.fxml", "Cartao de corre\u00e7\u00e3o");
                NotaFiscalCorrecaoFormController controller = (NotaFiscalCorrecaoFormController)formCorrecao.getUserData();
                controller.inicializa();
                formCorrecao.showAndWait();
                correcao = controller.getMotivo();
            }
            catch (IOException e) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo de carta de corre\u00e7\u00e3o de nota fiscal.");
            }
            if (correcao == null || correcao.isEmpty() || correcao.length() < 15) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum motivo v\u00e1lido informado para carta de corre\u00e7\u00e3o da nota fiscal.\nO motivo deve conter no m\u00ednimo 15 caracteres.");
                return;
            }
            Stage progress = new MaximaDialogFX().progress(this.stageManager, "Enviando carta de corre\u00e7\u00e3o.......");
            progress.show();
            this.correcaoNFe(progress, correcao);
        });
        this.btnImprime.setOnAction(evt -> this.imprimeNota());
        this.btnDestPesquisa.setOnAction(event -> this.pesquisaClienteForm());
        this.tfDestPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.btnProdutoAdd.setOnAction(evt -> {
            try {
                this.addProduto();
            }
            catch (MaximaException ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        });
        this.btnProdutoPesquisa.setOnAction(event -> this.pesquisaProdutoForm());
        this.tfProdutoPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaProduto();
            }
        });
        this.tfProdutoQuantidade.setOnKeyReleased(evt -> this.produtoCalculaTotal());
        this.tfProdutoValorUnitario.setOnKeyReleased(evt -> this.produtoCalculaTotal());
        this.tabelaProdutos.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteProduto();
            }
        });
        this.btnCobrancaAdd.setOnAction(evt -> this.addCobranca());
        this.tabelaCobranca.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteCobranca();
            }
        });
        this.btnNfeVinculadaAdd.setOnAction(evt -> this.addDocumento());
        this.tabelaNfeVinculada.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.deleteDocumento();
            }
        });
        this.tabelaProdutos.setContextMenu(this.getTableMenu());
        this.cbbProdutoCstCsosn.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.tfProdutoCfop.requestFocus();
                this.tfProdutoCfop.selectAll();
            }
        });
        this.tfProdutoCfop.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.tfProdutoQuantidade.requestFocus();
                this.tfProdutoQuantidade.selectAll();
            }
        });
        this.tfProdutoQuantidade.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.tfProdutoValorUnitario.requestFocus();
                this.tfProdutoValorUnitario.selectAll();
            }
        });
        this.tfProdutoValorUnitario.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                try {
                    this.addProduto();
                }
                catch (MaximaException ex) {
                    Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                }
            }
        });
    }

    private ContextMenu getTableMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem menuEditaValor = new MenuItem("Frete - Outras Despesas - Desconto");
        menuEditaValor.setOnAction(event -> this.editaValor());
        MenuItem menuIcms900 = new MenuItem("ICMS 900 - Valores");
        menuIcms900.setOnAction(event -> this.icms900Form());
        MenuItem menuIpi = new MenuItem("IPI - Valores");
        menuIpi.setOnAction(event -> this.ipiForm());
        cm.getItems().add((Object)menuEditaValor);
        cm.getItems().add((Object)menuIcms900);
        cm.getItems().add((Object)menuIpi);
        return cm;
    }

    private void ipiForm() {
        NFeDetalhe item = (NFeDetalhe)this.tabelaProdutos.getSelectionModel().getSelectedItem();
        NFIpiForm ipiForm = null;
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/nfe/NotaFiscalIpiForm.fxml", "IPI - Valores");
            NotaFiscalIpiFormController controller = (NotaFiscalIpiFormController)form.getUserData();
            controller.inicializa();
            form.showAndWait();
            ipiForm = controller.getIcms900Form();
        }
        catch (IOException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo para edi\u00e7\u00e3o de icms 900.\n" + ex.getMessage()));
        }
        if (ipiForm != null) {
            if (ipiForm.getValorDev().compareTo(BigDecimal.ZERO) > 0) {
                item.setValorIpiDev(ipiForm.getValorDev());
            } else {
                item.setCstIpi(ipiForm.getCst().getCodigo());
                item.setBaseCalculoIpi(ipiForm.getBaseCalculo());
                item.setAliquotaIpi(ipiForm.getAliquota());
                item.setValorIpi(ipiForm.getValor());
                item.setValorTotal(item.getValorSubtotal().add(item.getValorIpi()).add(item.getValorFrete()).add(item.getValorOutrasDespesas()).subtract(item.getValorDesconto()));
            }
            this.loadTabelaProdutos();
        }
    }

    private void icms900Form() {
        NFeDetalhe item = (NFeDetalhe)this.tabelaProdutos.getSelectionModel().getSelectedItem();
        NFIcms900Form icms900Form = null;
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/nfe/NotaFiscalIcmsForm.fxml", "ICMS 900 - Outros");
            NotaFiscalIcmsFormController controller = (NotaFiscalIcmsFormController)form.getUserData();
            controller.inicializa();
            form.showAndWait();
            icms900Form = controller.getIcms900Form();
        }
        catch (IOException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo para edi\u00e7\u00e3o de icms 900.\n" + ex.getMessage()));
        }
        if (icms900Form != null) {
            item.setCsosn(icms900Form.getCsosn().getCodigo());
            item.setBaseCalculoIcms(icms900Form.getBaseCalculo());
            item.setAliquotaIcms(icms900Form.getAliquota());
            item.setValorIcms(icms900Form.getValor());
            this.loadTabelaProdutos();
        }
    }

    private void editaValor() {
        BigDecimal valorDesconto;
        BigDecimal valorOutrasDespesas;
        BigDecimal valorFrete;
        NFeDetalhe item = (NFeDetalhe)this.tabelaProdutos.getSelectionModel().getSelectedItem();
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/nfe/NotaFiscalValorForm.fxml", "Edi\u00e7\u00e3o de valores");
            NotaFiscalValorFormController controller = (NotaFiscalValorFormController)form.getUserData();
            controller.inicializa();
            form.showAndWait();
            valorFrete = controller.getValorFrete();
            valorOutrasDespesas = controller.getValorOutrasDespesas();
            valorDesconto = controller.getValorDesconto();
        }
        catch (IOException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("ERRO: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo para edi\u00e7\u00e3o de valores.\n" + ex.getMessage()));
            return;
        }
        item.setValorFrete(valorFrete);
        item.setValorOutrasDespesas(valorOutrasDespesas);
        item.setValorDesconto(valorDesconto);
        item.setValorTotal(item.getValorSubtotal().add(item.getValorIpi()).add(valorFrete).add(valorOutrasDespesas).subtract(valorDesconto));
        this.loadTabelaProdutos();
    }

    private void addDocumento() {
        boolean valido = true;
        if (this.tfNfeVinculadaChave.getText() == null || this.tfNfeVinculadaChave.getText().length() < 44) {
            this.tfNfeVinculadaChave.getStyleClass().add((Object)"error");
            valido = false;
        } else if (MaximaUtils.getText((String)this.tfNfeVinculadaChave.getText()).replace(" ", "").length() != 44) {
            this.tfNfeVinculadaChave.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfNfeVinculadaChave.getStyleClass().remove((Object)"error");
        }
        if (!valido) {
            return;
        }
        String chaveAcesso = MaximaUtils.getText((String)this.tfNfeVinculadaChave.getText()).replace(" ", "");
        if (this.documentoLista == null) {
            this.documentoLista = new ArrayList();
        }
        NFeDocumento doc = new NFeDocumento();
        doc.setChaveAcesso(chaveAcesso);
        doc.setNumero(this.documentoLista.size() + 1);
        this.documentoLista.add(doc);
        this.loadTabelaDocumentos();
        this.tfNfeVinculadaChave.setText("");
    }

    private void deleteDocumento() {
        NFeDocumento selecionado = (NFeDocumento)this.tabelaNfeVinculada.getSelectionModel().getSelectedItem();
        if (selecionado == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma chave de acesso para excluir.");
            return;
        }
        int count = 0;
        for (NFeDocumento doc : this.documentoLista) {
            if (selecionado.getNumero() == doc.getNumero()) {
                this.documentoLista.remove(count);
                break;
            }
            ++count;
        }
        this.loadTabelaDocumentos();
    }

    private void deleteCobranca() {
        NFeCobranca selecionado = (NFeCobranca)this.tabelaCobranca.getSelectionModel().getSelectedItem();
        if (selecionado == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma cobran\u00e7a para excluir.");
            return;
        }
        int count = 0;
        for (NFeCobranca cob : this.cobrancaLista) {
            if (selecionado.getNumeroDuplicata().equals(cob.getNumeroDuplicata())) {
                this.cobrancaLista.remove(count);
                break;
            }
            ++count;
        }
        this.loadTabelaCobrancas();
    }

    private void addCobranca() {
        LocalDate dataVencimento = MaximaDate.convertToLocalDate((String)this.tfCobrancaVencimento.getText());
        BigDecimal valor = MaximaNumber.moneyToBigDecimal((String)this.tfCobrancaValor.getText());
        boolean valido = true;
        if (dataVencimento == null) {
            this.tfCobrancaVencimento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCobrancaVencimento.getStyleClass().remove((Object)"error");
        }
        if (valor == null || valor.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfCobrancaValor.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfCobrancaValor.getStyleClass().remove((Object)"error");
        }
        if (!valido) {
            return;
        }
        if (this.cobrancaLista == null) {
            this.cobrancaLista = new ArrayList();
        }
        NFeCobranca cobranca = new NFeCobranca();
        cobranca.setNumeroDuplicata(MaximaUtils.completaZeroEsquerda((String)String.valueOf(this.cobrancaLista.size() + 1), (Integer)3));
        cobranca.setDataVencimento(dataVencimento);
        cobranca.setValor(valor);
        this.cobrancaLista.add(cobranca);
        this.tfCobrancaValor.setText("");
        this.tfCobrancaVencimento.setText("");
        this.tfCobrancaVencimento.requestFocus();
        this.loadTabelaCobrancas();
    }

    private void enviaEmail(Stage progress, NFeCabecalho nfe) {
        1 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$enviaEmail$26(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {});
        service.start();
    }

    private void enviaNFe(Stage progress) {
        2 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$enviaNFe$28(progress, (Service)service, arg_0));
        service.setOnFailed(e -> progress.close());
        service.start();
    }

    private void consultNFe(Stage progress) {
        3 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$consultNFe$30(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {
            progress.close();
            System.out.println("== ERRO: " + e.getTarget());
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel consultar a nota fiscal.");
        });
        service.start();
    }

    private void correcaoNFe(Stage progress, String motivo) {
        4 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$correcaoNFe$32(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {});
        service.start();
    }

    private void cancelaNFe(Stage progress, String motivo) {
        5 service = new /* Unavailable Anonymous Inner Class!! */;
        service.setOnSucceeded(arg_0 -> this.lambda$cancelaNFe$34(progress, (Service)service, arg_0));
        service.setOnFailed(e -> {});
        service.start();
    }

    private void setColumnProperties() {
        this.colEventoData.setCellValueFactory((Callback)new PropertyValueFactory("dataEvento"));
        this.colEventoTipo.setCellValueFactory((Callback)new PropertyValueFactory("tipoEvento"));
        this.colEventoProtocolo.setCellValueFactory((Callback)new PropertyValueFactory("protocolo"));
        this.colEventoNumero.setCellValueFactory((Callback)new PropertyValueFactory("numeroSeq"));
        this.colEventoData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colProdutoItem.setCellValueFactory((Callback)new PropertyValueFactory("numeroItem"));
        this.colProdutoCodigo.setCellValueFactory((Callback)new PropertyValueFactory("codigoProduto"));
        this.colProdutoDescricao.setCellValueFactory((Callback)new PropertyValueFactory("nomeProduto"));
        if (this.conf.getEmpresaNFe().getRegime() == null || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            this.colProdutoCst.setCellValueFactory((Callback)new PropertyValueFactory("csosn"));
        } else {
            this.colProdutoCst.setCellValueFactory((Callback)new PropertyValueFactory("cstIcms"));
        }
        this.colProdutoCfop.setCellValueFactory((Callback)new PropertyValueFactory("cfop"));
        this.colProdutoQuantidade.setCellValueFactory((Callback)new PropertyValueFactory("quantidadeComercial"));
        this.colProdutoUnidade.setCellValueFactory((Callback)new PropertyValueFactory("unidadeComercial"));
        this.colProdutoValorUnitario.setCellValueFactory((Callback)new PropertyValueFactory("valorUnitarioComercial"));
        this.colProdutoValorTotal.setCellValueFactory((Callback)new PropertyValueFactory("valorTotal"));
        ColumnNumberFormatter formatter = new ColumnNumberFormatter();
        formatter.set3CasasDecimais();
        this.colProdutoQuantidade.setCellFactory((Callback)formatter);
        this.colProdutoValorUnitario.setCellFactory((Callback)formatter);
        this.colProdutoValorTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colCobrancaNumero.setCellValueFactory((Callback)new PropertyValueFactory("numeroDuplicata"));
        this.colCobrancaVencimento.setCellValueFactory((Callback)new PropertyValueFactory("dataVencimento"));
        this.colCobrancaValor.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colCobrancaValor.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colCobrancaVencimento.setCellFactory((Callback)new ColumnDateFormatter());
        this.colNfeVinculadaChave.setCellValueFactory((Callback)new PropertyValueFactory("chaveAcesso"));
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void loadBotoes() {
        if (this.nfe == null || this.nfe.getStatusNota() == null) {
            this.btnSalva.setDisable(false);
            this.btnEnvia.setDisable(false);
            this.btnCancela.setDisable(true);
            this.btnConsulta.setDisable(true);
            this.btnCartaCorrecao.setDisable(true);
            return;
        }
        if (this.nfe.getStatusNota().equals((Object)NFeStatus.EM_DIGITACAO)) {
            this.btnSalva.setDisable(false);
            this.btnEnvia.setDisable(false);
            this.btnConsulta.setDisable(true);
            this.btnCartaCorrecao.setDisable(true);
            this.btnCancela.setDisable(true);
        }
        if (this.nfe.getStatusNota().equals((Object)NFeStatus.ENVIADA)) {
            this.btnSalva.setDisable(true);
            this.btnEnvia.setDisable(true);
            this.btnConsulta.setDisable(false);
            this.btnCartaCorrecao.setDisable(true);
            this.btnCancela.setDisable(true);
        }
        if (this.nfe.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) {
            this.btnSalva.setDisable(true);
            this.btnEnvia.setDisable(true);
            this.btnConsulta.setDisable(true);
            this.btnImprime.setDisable(false);
            this.btnCancela.setDisable(false);
            this.btnCartaCorrecao.setDisable(false);
        }
        if (this.nfe.getStatusNota().equals((Object)NFeStatus.CANCELADA)) {
            this.btnSalva.setDisable(true);
            this.btnEnvia.setDisable(true);
            this.btnConsulta.setDisable(true);
            this.btnImprime.setDisable(false);
            this.btnCancela.setDisable(true);
            this.btnCartaCorrecao.setDisable(true);
        }
    }

    private void loadTabelaDocumentos() {
        this.documentoListaTabela.clear();
        this.documentoListaTabela.addAll((Collection)this.documentoLista);
        this.tabelaNfeVinculada.setItems(this.documentoListaTabela);
    }

    private void loadTabelaCobrancas() {
        this.cobrancaListaTabela.clear();
        this.cobrancaListaTabela.addAll((Collection)this.cobrancaLista);
        this.tabelaCobranca.setItems(this.cobrancaListaTabela);
    }

    private void loadTabelaProdutos() {
        this.produtoListaTabela.clear();
        this.produtoListaTabela.addAll((Collection)this.produtoLista);
        this.tabelaProdutos.setItems(this.produtoListaTabela);
        BigDecimal baseCalculoIcms = BigDecimal.ZERO;
        BigDecimal baseCalculoIcmsSt = BigDecimal.ZERO;
        BigDecimal valorIcms = BigDecimal.ZERO;
        BigDecimal valorIcmsSt = BigDecimal.ZERO;
        BigDecimal valorIpi = BigDecimal.ZERO;
        BigDecimal valorProdutos = BigDecimal.ZERO;
        BigDecimal valorTotalNota = BigDecimal.ZERO;
        BigDecimal valorFrete = BigDecimal.ZERO;
        BigDecimal valorOutrasDespesas = BigDecimal.ZERO;
        BigDecimal valorDesconto = BigDecimal.ZERO;
        BigDecimal valorPis = BigDecimal.ZERO;
        BigDecimal valorCofins = BigDecimal.ZERO;
        BigDecimal valorIpiDev = BigDecimal.ZERO;
        int cont = 1;
        for (NFeDetalhe nfeDet : this.produtoLista) {
            baseCalculoIcms = baseCalculoIcms.add(nfeDet.getBaseCalculoIcms());
            baseCalculoIcmsSt = baseCalculoIcmsSt.add(nfeDet.getBaseCalculoIcmsSt());
            valorIcms = valorIcms.add(nfeDet.getValorIcms());
            valorIcmsSt = valorIcmsSt.add(nfeDet.getValorIcmsSt());
            valorIpi = valorIpi.add(nfeDet.getValorIpi());
            valorProdutos = valorProdutos.add(nfeDet.getValorBrutoProdutos());
            valorTotalNota = valorTotalNota.add(nfeDet.getValorTotal());
            valorFrete = valorFrete.add(nfeDet.getValorFrete());
            valorOutrasDespesas = valorOutrasDespesas.add(nfeDet.getValorOutrasDespesas());
            valorDesconto = valorDesconto.add(nfeDet.getValorDesconto());
            valorPis = valorPis.add(nfeDet.getValorPis());
            valorCofins = valorCofins.add(nfeDet.getValorCofins());
            valorIpiDev = valorIpiDev.add(nfeDet.getValorIpiDev());
            nfeDet.setNumeroItem(Integer.valueOf(cont));
            ++cont;
        }
        if (this.nfe != null) {
            valorTotalNota = valorTotalNota.add(valorIcmsSt).add(this.nfe.getValorIpiDev());
        }
        this.tfBaseCalculoICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)baseCalculoIcms, (int)2));
        this.tfBaseCalculoICMSST.setText(MaximaNumber.bigDecimalToString((BigDecimal)baseCalculoIcmsSt, (int)2));
        this.tfValorICMS.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorIcms, (int)2));
        this.tfValorICMSST.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorIcmsSt, (int)2));
        this.tfValorIPI.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorIpi, (int)2));
        this.tfValorProdutos.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorProdutos, (int)2));
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorTotalNota, (int)2));
        this.tfValorFrete.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorFrete, (int)2));
        this.tfValorOutrasDespesas.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorOutrasDespesas, (int)2));
        this.tfValorDesconto.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorDesconto, (int)2));
        this.tfValorPIS.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorPis, (int)2));
        this.tfValorCOFINS.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorCofins, (int)2));
    }

    private void pesquisaProduto() {
        List produtos;
        String produtoCodigo = this.tfProdutoPesquisa.getText().trim();
        if (produtoCodigo.isEmpty()) {
            return;
        }
        this.produto = this.produtoService.getByCodigoBarras(produtoCodigo);
        if (this.produto == null && (produtos = this.produtoService.getByCodigoInterno(produtoCodigo)) != null && produtos.size() == 1) {
            this.produto = (Produto)produtos.get(0);
        }
        if (this.produto != null) {
            this.loadDadosProduto();
        } else {
            this.pesquisaProdutoForm();
        }
    }

    private void pesquisaProdutoForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/estoque/produto/ProdutoPesquisa.fxml", "Pesquisa de produto");
            ProdutoPesquisaController controller = (ProdutoPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfProdutoPesquisa.getText().trim());
            controller.setEnableCadastrarProduto();
            stage.showAndWait();
            this.produto = controller.getProdutoSelecionado();
            this.loadDadosProduto();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ProdutoPesquisa.fxml'");
        }
    }

    private void loadDadosProduto() {
        if (this.produto != null) {
            if (this.cliente == null) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Selecione o cliente antes de adicionar um produto.");
                return;
            }
            this.tfProdutoPesquisa.setText(this.produto.getCodigo());
            this.tfProdutoDescricao.setText(this.produto.getNome().toUpperCase());
            if (this.cliente.getMunicipio().getEstado().getId().equals(this.conf.getEmpresaNFe().getMunicipio().getEstado().getId())) {
                this.tfProdutoCfop.setText(this.produto.getCfop());
            } else {
                this.tfProdutoCfop.setText(this.produto.getCfopInterEstad());
            }
            this.tfProdutoValorUnitario.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.produto.getPrecoVenda(), (int)2));
            if (this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
                this.cbbProdutoCstCsosn.getSelectionModel().select((Object)this.produto.getIcmsSN());
            } else {
                this.cbbProdutoCstCsosn.getSelectionModel().select((Object)this.produto.getTributacaoICMS());
            }
            this.cbbProdutoCstCsosn.requestFocus();
        } else {
            this.inicializaItem();
        }
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfDestPesquisa.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        if (clienteCodigo.length() < 11) {
            try {
                Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
                Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
                if (clientePesquisa != null) {
                    this.cliente = clientePesquisa;
                } else {
                    this.cliente = null;
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de cliente n\u00e3o encontrado.");
                    this.tfDestPesquisa.requestFocus();
                    this.tfDestPesquisa.selectAll();
                }
                this.loadDestinatario(this.cliente);
                return;
            }
            catch (NumberFormatException clienteCodigoNumero) {}
        } else {
            try {
                this.cliente = this.clienteService.getByCpf(clienteCodigo);
            }
            catch (MaximaException ex) {
                this.cliente = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                this.tfDestPesquisa.requestFocus();
                this.tfDestPesquisa.selectAll();
            }
            this.loadDestinatario(this.cliente);
            if (this.cliente != null) {
                return;
            }
        }
        this.pesquisaClienteForm();
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnDestPesquisa.getScene(), this.tfDestPesquisa.getText());
        this.loadDestinatario(this.cliente);
    }

    private void carregaCombos() {
        this.cbbTipoOperacao.setItems(FXCollections.observableArrayList((Object[])NFTipo.values()));
        this.cbbFinalidade.setItems(FXCollections.observableArrayList((Object[])NFFinalidade.values()));
        this.cbbConsumidorFinal.setItems(FXCollections.observableArrayList((Object[])NFOperacaoConsumidorFinal.values()));
        if (this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || this.conf.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            this.cbbProdutoCstCsosn.setItems(FXCollections.observableArrayList((Object[])NFNotaSituacaoOperacionalSimplesNacional.values()));
        } else {
            this.cbbProdutoCstCsosn.setItems(FXCollections.observableArrayList((Object[])NFNotaInfoImpostoTributacaoICMS.values()));
        }
        this.cbbCobrancaCondicaoPagamento.setItems(FXCollections.observableArrayList((Object[])NFIndicadorFormaPagamento.values()));
        this.cbbCobrancaFormaPagamento.setItems(FXCollections.observableArrayList((Object[])NFMeioPagamento.values()));
        this.cbbTransporteModalidade.setItems(FXCollections.observableArrayList((Object[])NFModalidadeFrete.values()));
        this.cbbTransporteTransportadora.setItems(FXCollections.observableArrayList((Collection)this.transportadoraService.combo()));
        this.cbbTransporteVeiculo.setItems(FXCollections.observableArrayList((Collection)this.veiculoService.combo()));
    }

    private void carregaIcones() {
        MaximaIcone icone = new MaximaIcone();
        this.btnSalva.setGraphic((Node)icone.getIconeConfirma());
        this.btnDestPesquisa.setGraphic((Node)icone.getPesquisa());
        this.btnProdutoAdd.setGraphic((Node)icone.getIconeNovo());
        this.btnProdutoPesquisa.setGraphic((Node)icone.getPesquisa());
    }

    private void carregaMascaras() {
        MaximaMask.dateField((TextField)this.tfDataEmissao);
        MaximaMask.dateField((TextField)this.tfDataEntradaSaida);
        MaximaMask.horaField((TextField)this.tfHoraEntradaSaida);
        MaximaMask.monetaryField((TextField)this.tfBaseCalculoICMS);
        MaximaMask.monetaryField((TextField)this.tfValorICMS);
        MaximaMask.monetaryField((TextField)this.tfBaseCalculoICMSST);
        MaximaMask.monetaryField((TextField)this.tfValorICMSST);
        MaximaMask.monetaryField((TextField)this.tfValorPIS);
        MaximaMask.monetaryField((TextField)this.tfValorCOFINS);
        MaximaMask.monetaryField((TextField)this.tfValorIPI);
        MaximaMask.monetaryField((TextField)this.tfValorProdutos);
        MaximaMask.monetaryField((TextField)this.tfValorFrete);
        MaximaMask.monetaryField((TextField)this.tfValorOutrasDespesas);
        MaximaMask.monetaryField((TextField)this.tfValorDesconto);
        MaximaMask.monetaryField((TextField)this.tfValorTotal);
        MaximaMask.monetaryField((TextField)this.tfCobrancaValor);
        MaximaMask.dateField((TextField)this.tfCobrancaVencimento);
    }

    private /* synthetic */ void lambda$cancelaNFe$34(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
        this.inicializa(this.nfe);
    }

    private /* synthetic */ void lambda$correcaoNFe$32(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
        this.inicializa(this.nfe);
    }

    private /* synthetic */ void lambda$consultNFe$30(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
        this.inicializa(this.nfe);
    }

    private /* synthetic */ void lambda$enviaNFe$28(Stage progress, Service service, Event e) {
        String emailDestinatario;
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
        this.inicializa(this.nfe);
        if (this.nfe.getStatusNota().equals((Object)NFeStatus.AUTORIZADA) && (emailDestinatario = this.nfe.getCliente().getEmail()) != null && !emailDestinatario.isEmpty()) {
            if (!this.conf.senEmailValido().booleanValue()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Configura\u00e7\u00e3o de e-mail n\u00e3o efetuada.");
                return;
            }
            if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja enviar a nota por email?")) {
                progress.show();
                this.enviaEmail(progress, this.nfe);
            }
        }
    }

    private /* synthetic */ void lambda$enviaEmail$26(Stage progress, Service service, Event e) {
        progress.close();
        MaximaResposta retorno = (MaximaResposta)service.getValue();
        if (retorno.getSucesso().booleanValue()) {
            MaximaAlert.informe((StageManager)this.stageManager, (String)retorno.getMensagem());
        } else {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)retorno.getMensagem());
        }
    }

    static /* synthetic */ Configuracao access$000(NotaFiscalFormController x0) {
        return x0.conf;
    }

    static /* synthetic */ void access$100(NotaFiscalFormController x0, boolean x1, Boolean x2) {
        x0.salva(x1, x2);
    }

    static /* synthetic */ NFeCabecalho access$200(NotaFiscalFormController x0) {
        return x0.nfe;
    }

    static /* synthetic */ NotaFiscalService access$300(NotaFiscalFormController x0) {
        return x0.notaFiscalService;
    }

    static /* synthetic */ ConfiguracaoService access$400(NotaFiscalFormController x0) {
        return x0.configuracaoService;
    }

    static /* synthetic */ GrupoICMSRepository access$500(NotaFiscalFormController x0) {
        return x0.iCMSRepository;
    }

    static /* synthetic */ NFeCabecalho access$202(NotaFiscalFormController x0, NFeCabecalho x1) {
        x0.nfe = x1;
        return x0.nfe;
    }
}

