/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.fiscal.modelo.Contador;
import br.com.maximasolutions.fiscal.modelo.GrupoICMS;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.modelo.NFeCobranca;
import br.com.maximasolutions.fiscal.modelo.NFeDestinatario;
import br.com.maximasolutions.fiscal.modelo.NFeDetalhe;
import br.com.maximasolutions.fiscal.modelo.NFeDocumento;
import br.com.maximasolutions.fiscal.modelo.NFeEmitente;
import br.com.maximasolutions.fiscal.modelo.NFeTransportadora;
import br.com.maximasolutions.fiscal.modelo.NFeVeiculo;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFEndereco;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaIPI;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFProcessoEmissor;
import com.fincatto.documentofiscal.nfe400.classes.NFProdutoCompoeValorNota;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import com.fincatto.documentofiscal.nfe400.classes.NFTipoImpressao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIdentificadorLocalDestinoOperacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFImpostoDevolvido;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorIEDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorPresencaComprador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoCupomFiscalReferenciado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInformacaoImpostoDevolvido;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFMeioPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCartao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCobranca;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFatura;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoICMSTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoIdentificacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoInformacoesAdicionais;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItem;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImposto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSAliquota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSNaoTributavel;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSOutrasOperacoes;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS00;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS10;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS20;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS40;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS60;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS90;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN101;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN102;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN201;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN202;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN500;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN900;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSUFDestino;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPI;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPITributado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPIS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISAliquota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISNaoTributado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISOutrasOperacoes;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProduto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivel;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoParcela;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoResponsavelTecnico;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransportador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVeiculo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVolume;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperacaoConsumidorFinal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFPessoaAutorizadaDownloadNFe;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFTipoIntegracaoPagamento;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotaFiscalGeraXml {
    private boolean icmsDestino = false;

    public NFNotaInfoResponsavelTecnico getResponsavelTecnico() {
        NFNotaInfoResponsavelTecnico responsavel = new NFNotaInfoResponsavelTecnico();
        responsavel.setCnpj("09439300000146");
        responsavel.setContatoNome("M\u00e1xima Sistemas e Solu\u00e7\u00f5es");
        responsavel.setEmail("contato@maximasolutions.com.br");
        responsavel.setTelefone("18997636459");
        return responsavel;
    }

    public NFNota getNFNota(NFeCabecalho cabecalho, NFeDestinatario destinatario, NFeEmitente emitente, List<NFeDetalhe> listDetalhe, Configuracao conf, NFeTransportadora nFeTransportadora, NFeVeiculo veiculo, List<NFeCobranca> cobrancas, List<NFeDocumento> documentos, GrupoICMS grupoICMS) throws MaximaException {
        NFNotaInfo notaInfo = new NFNotaInfo();
        notaInfo.setIdentificador(cabecalho.getChaveAcesso() + cabecalho.getDigitoChaveAcesso());
        notaInfo.setVersao(new BigDecimal(NFeConfigMaxima.VERSAO_NFE));
        notaInfo.setIdentificacao(this.getIdentificacao(cabecalho, emitente, destinatario, conf, documentos, listDetalhe));
        notaInfo.setEmitente(this.getEmitente(emitente, conf));
        notaInfo.setDestinatario(this.getDestinatario(destinatario, cabecalho));
        notaInfo.setPagamento(this.getPagamentos(cabecalho));
        if (conf.getContador() != null && conf.getContador().getCpf() != null) {
            notaInfo.setPessoasAutorizadasDownloadNFe(this.getPessoaAutorizada(conf.getContador()));
        }
        notaInfo.setCobranca(this.getCobranca(cabecalho, cobrancas));
        NFNotaInfoInformacoesAdicionais infoAdd = new NFNotaInfoInformacoesAdicionais();
        String infAdd = MaximaUtils.removeAcentos((String)cabecalho.getInformacoesAddContribuinte());
        if (infAdd == null) {
            infAdd = "";
        }
        ArrayList<NFNotaInfoItem> itens = new ArrayList<NFNotaInfoItem>();
        BigDecimal totalNacional = BigDecimal.ZERO;
        BigDecimal totalEstadual = BigDecimal.ZERO;
        for (NFeDetalhe i : listDetalhe) {
            try {
                itens.add(this.getItem(cabecalho, destinatario, i, conf, grupoICMS));
                if (i.getTributoNacional() != null) {
                    totalNacional = totalNacional.add(i.getTributoNacional());
                }
                if (i.getTributoEstadual() == null) continue;
                totalEstadual = totalEstadual.add(i.getTributoEstadual());
            }
            catch (Exception ex) {
                Logger.getLogger(NotaFiscalGeraXml.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException(ex.getMessage());
            }
        }
        if (conf.getExibirImpostoIBPT().booleanValue()) {
            infAdd = infAdd + "#Trib Aprox R$: " + MaximaNumber.formataNumero((BigDecimal)totalNacional) + " Federeal e " + MaximaNumber.formataNumero((BigDecimal)totalEstadual) + " Estadual. Fonte IBPT.";
        }
        notaInfo.setItens(itens);
        notaInfo.setTotal(this.getTotal(cabecalho, listDetalhe));
        notaInfo.setTransporte(this.getTransporte(cabecalho, nFeTransportadora, veiculo));
        notaInfo.setInformacaoResposavelTecnico(this.getResponsavelTecnico());
        String infNfeRef = "#Nota(s) Referenciada(s): ";
        int cont = 0;
        for (NFeDocumento doc : documentos) {
            if (cont == 0) {
                infAdd = infAdd + infNfeRef;
            }
            infAdd = infAdd + "" + doc.getChaveAcesso() + "#";
            ++cont;
        }
        for (NFeCobranca cob : cobrancas) {
            infAdd = infAdd + "#Duplicata Num: " + cob.getNumeroDuplicata() + ", Venc.: " + MaximaDate.getData((LocalDate)cob.getDataVencimento()) + ", Valor: " + MaximaNumber.formataNumero((BigDecimal)cob.getValor());
        }
        if (!infAdd.isEmpty()) {
            infAdd = infAdd.replace("\n", "#");
            infoAdd.setInformacoesComplementaresInteresseContribuinte(infAdd.trim());
        }
        notaInfo.setInformacoesAdicionais(infoAdd);
        NFNota nota = new NFNota();
        nota.setInfo(notaInfo);
        return nota;
    }

    private List<NFPessoaAutorizadaDownloadNFe> getPessoaAutorizada(Contador contador) {
        ArrayList<NFPessoaAutorizadaDownloadNFe> list = new ArrayList<NFPessoaAutorizadaDownloadNFe>();
        NFPessoaAutorizadaDownloadNFe p = new NFPessoaAutorizadaDownloadNFe();
        if (contador.getCpf().length() == 14) {
            p.setCnpj(contador.getCpf());
        } else {
            p.setCpf(contador.getCpf());
        }
        list.add(p);
        return list;
    }

    private NFNotaInfoCobranca getCobranca(NFeCabecalho nfe, List<NFeCobranca> cobrancaLista) {
        try {
            if (cobrancaLista == null || cobrancaLista.isEmpty()) {
                return null;
            }
            NFNotaInfoCobranca cobranca = new NFNotaInfoCobranca();
            if (nfe.getFaturaNumero() != null && !nfe.getFaturaNumero().isEmpty()) {
                NFNotaInfoFatura fatura = new NFNotaInfoFatura();
                fatura.setNumeroFatura(nfe.getFaturaNumero());
                if (nfe.getFaturaValorDesconto().compareTo(BigDecimal.ZERO) > 0) {
                    fatura.setValorDesconto(nfe.getFaturaValorDesconto());
                }
                fatura.setValorLiquidoFatura(nfe.getFaturaValorLiquido());
                fatura.setValorOriginalFatura(nfe.getFaturaValorOriginal());
                cobranca.setFatura(fatura);
            }
            ArrayList duplicataList = new ArrayList();
            cobrancaLista.stream().map(cob -> {
                NFNotaInfoParcela dup = new NFNotaInfoParcela();
                dup.setDataVencimento(cob.getDataVencimento());
                dup.setNumeroParcela(cob.getNumeroDuplicata());
                dup.setValorParcela(cob.getValor());
                return dup;
            }).forEachOrdered(dup -> duplicataList.add(dup));
            cobranca.setParcelas(duplicataList);
            return cobranca;
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalGeraXml.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private NFNotaInfoTransporte getTransporte(NFeCabecalho nfe, NFeTransportadora transportadora, NFeVeiculo veiculo) {
        NFNotaInfoTransporte transp = new NFNotaInfoTransporte();
        transp.setModalidadeFrete(nfe.getModalidadeFrete());
        if (transportadora != null) {
            NFNotaInfoTransportador transportador = new NFNotaInfoTransportador();
            if (transportadora.getCpfCnpj() != null && transportadora.getCpfCnpj().replace(".", "").replace("/", "").replace("-", "").length() > 11) {
                transportador.setCnpj(transportadora.getCpfCnpj());
            } else if (transportadora.getCpfCnpj() != null && !transportadora.getCpfCnpj().isEmpty()) {
                transportador.setCpf(transportadora.getCpfCnpj());
            }
            transportador.setInscricaoEstadual(transportadora.getInscEstadual());
            transportador.setNomeMunicipio(transportadora.getNomeMunicipio().trim());
            transportador.setRazaoSocial(transportadora.getRazaoSocial().trim());
            transportador.setUf(DFUnidadeFederativa.valueOf((String)transportadora.getUf()));
            transportador.setEnderecoComplemento(transportadora.getLogradouro().trim());
            transp.setTransportador(transportador);
        }
        if (veiculo != null) {
            NFNotaInfoVeiculo veic = new NFNotaInfoVeiculo();
            veic.setPlacaVeiculo(veiculo.getPlaca());
            veic.setUf(DFUnidadeFederativa.valueOfCodigo((String)veiculo.getUf()));
            if (veiculo.getAntt() != null && !veiculo.getAntt().isEmpty()) {
                veic.setRegistroNacionalTransportadorCarga(veiculo.getAntt());
            }
            transp.setVeiculo(veic);
        }
        if (nfe.getTranspEspecie() != null && !nfe.getTranspEspecie().isEmpty()) {
            NFNotaInfoVolume volume = new NFNotaInfoVolume();
            volume.setEspecieVolumesTransportados(nfe.getTranspEspecie());
            volume.setPesoBruto(nfe.getTranspPesoBruto());
            volume.setPesoLiquido(nfe.getTranspPesoLiquido());
            volume.setQuantidadeVolumesTransportados(new BigInteger(nfe.getTranspQuantidade().setScale(0, RoundingMode.HALF_EVEN).toString()));
            ArrayList<NFNotaInfoVolume> volumes = new ArrayList<NFNotaInfoVolume>();
            volumes.add(volume);
            transp.setVolumes(volumes);
        }
        return transp;
    }

    private NFNotaInfoTotal getTotal(NFeCabecalho info, List<NFeDetalhe> itens) {
        NFNotaInfoTotal total = new NFNotaInfoTotal();
        NFNotaInfoICMSTotal iCMSTotal = new NFNotaInfoICMSTotal();
        BigDecimal totalTributos = BigDecimal.ZERO;
        for (NFeDetalhe item : itens) {
            if (item.getTributoNacional() != null) {
                totalTributos = totalTributos.add(item.getTributoNacional());
            }
            if (item.getTributoEstadual() == null) continue;
            totalTributos = totalTributos.add(item.getTributoEstadual());
        }
        iCMSTotal.setBaseCalculoICMS(info.getBaseCalculoIcms());
        iCMSTotal.setBaseCalculoICMSST(info.getBaseCalculoIcmsSt());
        iCMSTotal.setOutrasDespesasAcessorias(BigDecimal.ZERO);
        iCMSTotal.setValorCOFINS(info.getValorCofins());
        iCMSTotal.setValorICMSDesonerado(BigDecimal.ZERO);
        iCMSTotal.setValorPIS(info.getValorPis());
        if (info.getValorDesconto() != BigDecimal.ZERO) {
            iCMSTotal.setValorTotalDesconto(info.getValorDesconto());
        }
        iCMSTotal.setValorTotalDosProdutosServicos(info.getValorTotalProdutos());
        if (info.getValorFrete() != BigDecimal.ZERO) {
            iCMSTotal.setValorTotalFrete(info.getValorFrete());
        }
        if (info.getValorDespesasAcessorias() != BigDecimal.ZERO) {
            iCMSTotal.setOutrasDespesasAcessorias(info.getValorDespesasAcessorias());
        }
        iCMSTotal.setValorTotalNFe(info.getValorTotal());
        iCMSTotal.setValorTotalTributos(totalTributos);
        iCMSTotal.setValorTotalICMS(info.getValorIcms());
        iCMSTotal.setValorTotalICMSST(info.getValorIcmsSt());
        iCMSTotal.setValorTotalII(BigDecimal.ZERO);
        iCMSTotal.setValorTotalIPI(info.getValorIpi());
        iCMSTotal.setValorTotalSeguro(BigDecimal.ZERO);
        iCMSTotal.setValorTotalFundoCombatePobreza(BigDecimal.ZERO);
        iCMSTotal.setValorTotalFundoCombatePobrezaST(BigDecimal.ZERO);
        iCMSTotal.setValorTotalFundoCombatePobrezaSTRetido(BigDecimal.ZERO);
        iCMSTotal.setValorTotalIPIDevolvido(info.getValorIpiDev());
        iCMSTotal.setValorICMSFundoCombatePobreza(BigDecimal.ZERO);
        iCMSTotal.setValorICMSPartilhaDestinatario(BigDecimal.ZERO);
        iCMSTotal.setValorICMSPartilhaRementente(BigDecimal.ZERO);
        total.setIcmsTotal(iCMSTotal);
        return total;
    }

    private NFNotaInfoItem getItem(NFeCabecalho nota, NFeDestinatario destinatario, NFeDetalhe det, Configuracao conf, GrupoICMS grupoICMS) throws Exception {
        String infAdProd;
        NFNotaInfoItem item = new NFNotaInfoItem();
        item.setImposto(this.getImposto(nota, destinatario, det, conf, grupoICMS));
        item.setNumeroItem(det.getNumeroItem());
        item.setProduto(this.getProduto(det));
        if (det.getValorIpiDev().compareTo(BigDecimal.ZERO) > 0) {
            System.out.println("--- aqui nesse carai ---");
            NFImpostoDevolvido impDev = new NFImpostoDevolvido();
            NFInformacaoImpostoDevolvido infDev = new NFInformacaoImpostoDevolvido();
            infDev.setValorIPIDevolvido(det.getValorIpiDev());
            impDev.setInformacaoIPIDevolvido(infDev);
            impDev.setPercentualDevolucao(BigDecimal.ZERO);
            item.setImpostoDevolvido(impDev);
        }
        if ((infAdProd = det.getInformacoesAdicionais()) != null && !infAdProd.isEmpty()) {
            item.setInformacoesAdicionais(infAdProd.trim());
        }
        return item;
    }

    private NFNotaInfoItemImposto getImposto(NFeCabecalho nota, NFeDestinatario destinatario, NFeDetalhe item, Configuracao conf, GrupoICMS grupoICMS) throws Exception {
        NFNotaInfoItemImposto imposto = new NFNotaInfoItemImposto();
        if (item.getProduto().getPis() != null && item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_SUBSTITUICAO_TRIBUTARIA)) {
            NFNotaInfoItemImpostoPISST pisST = new NFNotaInfoItemImpostoPISST();
            pisST.setQuantidadeVendida(item.getQuantidadeComercial());
            pisST.setValorAliquota(BigDecimal.ZERO);
            pisST.setValorBaseCalculo(item.getValorTotal());
            pisST.setValorTributo(BigDecimal.ZERO);
            imposto.setPisst(pisST);
        } else {
            imposto.setPis(this.getPis(item, conf));
        }
        if (item.getProduto().getCofins() != null && item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_SUBSTITUICAO_TRIBUTARIA)) {
            NFNotaInfoItemImpostoCOFINSST cofinsST = new NFNotaInfoItemImpostoCOFINSST();
            cofinsST.setPercentualAliquota(BigDecimal.ZERO);
            cofinsST.setQuantidadeVendida(item.getQuantidadeComercial());
            cofinsST.setValorBaseCalculo(item.getValorTotal());
            cofinsST.setValorCOFINS(BigDecimal.ZERO);
            imposto.setCofinsst(cofinsST);
        } else {
            imposto.setCofins(this.getCofins(item, conf));
        }
        if (item.getCstIpi() != null && !item.getCstIpi().isEmpty()) {
            imposto.setIpi(this.getIPI(item, conf));
        }
        imposto.setIcms(this.getIcms(nota, item, conf));
        DFUnidadeFederativa ufDestino = DFUnidadeFederativa.valueOfCodigo((String)destinatario.getMunicipio().getEstado().getSigla());
        if (nota.getConsumidorFinal().equals((Object)NFOperacaoConsumidorFinal.SIM) && !ufDestino.equals((Object)DFUnidadeFederativa.valueOf((String)conf.getEmpresaNFe().getMunicipio().getEstado().getSigla())) && this.icmsDestino) {
            imposto.setIcmsUfDestino(this.getIcmsDestino(destinatario, item, conf, grupoICMS));
        }
        BigDecimal totalImpostoItem = BigDecimal.ZERO;
        if (item.getTributoNacional() != null) {
            totalImpostoItem = totalImpostoItem.add(item.getTributoNacional());
        }
        if (item.getTributoEstadual() != null) {
            totalImpostoItem = totalImpostoItem.add(item.getTributoEstadual());
        }
        imposto.setValorTotalTributos(totalImpostoItem);
        return imposto;
    }

    private NFNotaInfoItemProduto getProduto(NFeDetalhe item) {
        NFNotaInfoItemProdutoCombustivel combustivel;
        String codigoCest;
        NFNotaInfoItemProduto produto = new NFNotaInfoItemProduto();
        produto.setCompoeValorNota(NFProdutoCompoeValorNota.SIM);
        produto.setCfop(item.getCfop().toString().trim());
        produto.setCodigo(item.getCodigoProduto().trim());
        produto.setDescricao(MaximaUtils.removeAcentos((String)item.getNomeProduto()).trim());
        produto.setNcm(item.getNcm().trim());
        produto.setQuantidadeComercial(item.getQuantidadeComercial().setScale(4, RoundingMode.HALF_EVEN));
        produto.setQuantidadeTributavel(item.getQuantidadeTributavel());
        produto.setUnidadeComercial(item.getUnidadeComercial());
        produto.setUnidadeTributavel(item.getUnidadeTributavel());
        produto.setValorUnitario(item.getValorUnitarioComercial());
        produto.setValorUnitarioTributavel(item.getValorUnitarioTributacao());
        produto.setValorTotalBruto(item.getValorBrutoProdutos().setScale(2, RoundingMode.HALF_EVEN));
        if (item.getValorFrete() != null && item.getValorFrete().compareTo(BigDecimal.ZERO) > 0) {
            produto.setValorFrete(item.getValorFrete());
        }
        if (item.getValorDesconto() != null && item.getValorDesconto().compareTo(BigDecimal.ZERO) > 0) {
            produto.setValorDesconto(item.getValorDesconto());
        }
        if (item.getValorOutrasDespesas() != null && item.getValorOutrasDespesas().compareTo(BigDecimal.ZERO) > 0) {
            produto.setValorOutrasDespesasAcessorias(item.getValorOutrasDespesas());
        }
        if ((codigoCest = MaximaUtils.removeCaracteres((String)item.getProduto().getCest())) != null && !codigoCest.isEmpty()) {
            produto.setCodigoEspecificadorSituacaoTributaria(codigoCest);
        }
        produto.setCodigoDeBarras("SEM GTIN");
        produto.setCodigoDeBarrasTributavel("SEM GTIN");
        if (produto.getCfop().equals("5655")) {
            combustivel = new NFNotaInfoItemProdutoCombustivel();
            combustivel.setCodigoProdutoANP("660101001");
            combustivel.setDescricaoProdutoANP("\u00d3LEOS LUB. PARAF E GRAXAS INTERMEDI\u00c1RIOS");
            combustivel.setUf(DFUnidadeFederativa.SP);
            produto.setCombustivel(combustivel);
        }
        if (produto.getCfop().equals("5661")) {
            combustivel = new NFNotaInfoItemProdutoCombustivel();
            combustivel.setCodigoProdutoANP("660101001");
            combustivel.setDescricaoProdutoANP("\u00d3LEOS LUB. PARAF E GRAXAS INTERMEDI\u00c1RIOS");
            combustivel.setUf(DFUnidadeFederativa.SP);
            produto.setCombustivel(combustivel);
        }
        if (produto.getCfop().equals("5662")) {
            combustivel = new NFNotaInfoItemProdutoCombustivel();
            combustivel.setCodigoProdutoANP("910101001");
            combustivel.setDescricaoProdutoANP("GAS");
            combustivel.setUf(DFUnidadeFederativa.SP);
            produto.setCombustivel(combustivel);
        }
        return produto;
    }

    private NFNotaInfoItemImpostoICMSUFDestino getIcmsDestino(NFeDestinatario destinatario, NFeDetalhe item, Configuracao configuracao, GrupoICMS grupoICMS) {
        if (grupoICMS == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSUFDestino icmsDestinoImposto = new NFNotaInfoItemImpostoICMSUFDestino();
        try {
            icmsDestinoImposto.setPercentualAliquotaInternaDestino(grupoICMS.getIcmsIntraEstadual());
            icmsDestinoImposto.setPercentualInterestadual(grupoICMS.getIcmsInterEstadual());
            icmsDestinoImposto.setPercentualRelativoFundoCombatePobrezaDestino(BigDecimal.ZERO);
            icmsDestinoImposto.setValorRelativoFundoCombatePobrezaDestino(BigDecimal.ZERO);
            icmsDestinoImposto.setValorBCFundoCombatePobrezaDestino(BigDecimal.ZERO);
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalGeraXml.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        icmsDestinoImposto.setPercentualProvisorioPartilha(new BigDecimal("100"));
        icmsDestinoImposto.setPercentualRelativoFundoCombatePobrezaDestino(BigDecimal.ZERO);
        icmsDestinoImposto.setValorBaseCalculoDestino(BigDecimal.ZERO);
        icmsDestinoImposto.setValorICMSInterestadualDestino(BigDecimal.ZERO);
        icmsDestinoImposto.setValorICMSInterestadualRemetente(BigDecimal.ZERO);
        icmsDestinoImposto.setValorRelativoFundoCombatePobrezaDestino(BigDecimal.ZERO);
        return icmsDestinoImposto;
    }

    private NFNotaInfoItemImpostoICMS getIcms(NFeCabecalho nfe, NFeDetalhe item, Configuracao configuracao) throws Exception {
        NFNotaInfoItemImpostoICMS icms = new NFNotaInfoItemImpostoICMS();
        if (configuracao.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.SIMPLES_NACIONAL) || configuracao.getEmpresaNFe().getRegime().equals((Object)NFRegimeTributario.MEI)) {
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.NAO_TRIBUTADA) || NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SEM_PERMISSAO_CREDITO) || NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.IMUNE)) {
                NFNotaInfoItemImpostoICMSSN102 icms102 = new NFNotaInfoItemImpostoICMSSN102();
                icms102.setOrigem(item.getProduto().getOrigem());
                icms102.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()));
                icms.setIcmssn102(icms102);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_COM_PERMISSAO_CREDITO)) {
                NFNotaInfoItemImpostoICMSSN101 icms101 = new NFNotaInfoItemImpostoICMSSN101();
                icms101.setOrigem(item.getProduto().getOrigem());
                icms101.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_COM_PERMISSAO_CREDITO);
                icms101.setPercentualAliquotaAplicavelCalculoCreditoSN(item.getProduto().getAliquotaCreditoICMS());
                icms101.setValorCreditoICMSSN(item.getProduto().getAliquotaCreditoICMS().multiply(item.getValorTotal()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
                icms.setIcmssn101(icms101);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SIMPLES_NACIONAL_COM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA)) {
                NFNotaInfoItemImpostoICMSSN201 icms201 = new NFNotaInfoItemImpostoICMSSN201();
                icms201.setOrigem(item.getProduto().getOrigem());
                icms201.setPercentualAliquotaAplicavelCalculoCreditoSN(item.getProduto().getAliquotaCreditoICMS());
                icms201.setValorCreditoICMSSN(item.getProduto().getAliquotaCreditoICMS().multiply(item.getValorTotal()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
                icms201.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO);
                icms201.setPercentualAliquotaImpostoICMSST(item.getAliquotaIcmsSt());
                icms201.setPercentualMargemValorAdicionadoICMSST(item.getPercentualMvaIcmsSt());
                icms201.setPercentualReducaoBCICMSST(BigDecimal.ZERO);
                icms201.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SIMPLES_NACIONAL_COM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA);
                icms201.setValorBCICMSST(item.getBaseCalculoIcmsSt());
                icms201.setValorICMSST(item.getValorIcmsSt());
                icms.setIcmssn201(icms201);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SIMPLES_NACIONAL_SEM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA)) {
                NFNotaInfoItemImpostoICMSSN202 icms202 = new NFNotaInfoItemImpostoICMSSN202();
                icms202.setOrigem(item.getProduto().getOrigem());
                icms202.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO);
                icms202.setPercentualAliquotaImpostoICMSST(item.getAliquotaIcmsSt());
                icms202.setPercentualMargemValorAdicionadoICMSST(item.getPercentualMvaIcmsSt());
                icms202.setPercentualReducaoBCICMSST(BigDecimal.ZERO);
                icms202.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.TRIBUTADA_SIMPLES_NACIONAL_SEM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA);
                icms202.setValorBCICMSST(item.getBaseCalculoIcmsSt());
                icms202.setValorICMSST(item.getValorIcmsSt());
                icms.setIcmssn202(icms202);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO)) {
                NFNotaInfoItemImpostoICMSSN500 icms500 = new NFNotaInfoItemImpostoICMSSN500();
                icms500.setOrigem(item.getProduto().getOrigem());
                icms500.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO);
                if (nfe.getConsumidorFinal().equals((Object)NFOperacaoConsumidorFinal.NAO)) {
                    icms500.setValorBCICMSSTRetido(BigDecimal.ZERO);
                    icms500.setPercentualICMSSTRetido(BigDecimal.ZERO);
                    icms500.setValorICMSSubstituto(BigDecimal.ZERO);
                    icms500.setValorICMSSTRetido(BigDecimal.ZERO);
                }
                icms.setIcmssn500(icms500);
            }
            if (NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)item.getCsosn()).equals((Object)NFNotaSituacaoOperacionalSimplesNacional.OUTROS)) {
                NFNotaInfoItemImpostoICMSSN900 icms900 = new NFNotaInfoItemImpostoICMSSN900();
                icms900.setOrigem(item.getProduto().getOrigem());
                icms900.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.OUTROS);
                if (item.getBaseCalculoIcms() != null && item.getBaseCalculoIcms().compareTo(BigDecimal.ZERO) > 0) {
                    icms900.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.VALOR_OPERACAO);
                    icms900.setValorBCICMS(item.getBaseCalculoIcms());
                    icms900.setPercentualAliquotaImposto(item.getAliquotaIcms());
                    icms900.setValorICMS(item.getValorIcms());
                }
                if (item.getBaseCalculoIcmsSt() != null && item.getBaseCalculoIcmsSt().compareTo(BigDecimal.ZERO) > 0) {
                    icms900.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO);
                    icms900.setPercentualAliquotaImpostoICMSST(item.getAliquotaIcmsSt());
                    icms900.setPercentualMargemValorAdicionadoICMSST(item.getPercentualMvaIcmsSt());
                    icms900.setPercentualReducaoBCICMSST(BigDecimal.ZERO);
                    icms900.setValorBCICMSST(item.getBaseCalculoIcmsSt());
                    icms900.setValorICMSST(item.getValorIcmsSt());
                }
                icms.setIcmssn900(icms900);
            }
        } else {
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.OUTROS)) {
                NFNotaInfoItemImpostoICMS90 iCMS90 = new NFNotaInfoItemImpostoICMS90();
                iCMS90.setOrigem(item.getProduto().getOrigem());
                iCMS90.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.OUTROS);
                icms.setIcms90(iCMS90);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.TRIBUTACAO_INTEGRALMENTE)) {
                NFNotaInfoItemImpostoICMS00 iCMS00 = new NFNotaInfoItemImpostoICMS00();
                iCMS00.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.VALOR_OPERACAO);
                iCMS00.setOrigem(item.getProduto().getOrigem());
                iCMS00.setPercentualAliquota(item.getAliquotaIcms());
                iCMS00.setValorBaseCalculo(item.getBaseCalculoIcms());
                iCMS00.setValorTributo(item.getValorIcms());
                iCMS00.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.TRIBUTACAO_INTEGRALMENTE);
                icms.setIcms00(iCMS00);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA)) {
                System.out.println("======= ICMS 10 ==========");
                NFNotaInfoItemImpostoICMS10 iCMS10 = new NFNotaInfoItemImpostoICMS10();
                iCMS10.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.VALOR_OPERACAO);
                iCMS10.setOrigem(item.getProduto().getOrigem());
                iCMS10.setPercentualAliquota(item.getAliquotaIcms());
                iCMS10.setValorBaseCalculo(item.getBaseCalculoIcms());
                iCMS10.setValorTributo(item.getValorIcms());
                iCMS10.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA);
                iCMS10.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO);
                iCMS10.setPercentualMargemValorAdicionadoICMSST(item.getPercentualMvaIcmsSt());
                iCMS10.setValorBCICMSST(item.getBaseCalculoIcmsSt());
                iCMS10.setPercentualAliquotaImpostoICMSST(item.getAliquotaIcmsSt());
                iCMS10.setValorICMSST(item.getValorIcmsSt());
                icms.setIcms10(iCMS10);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.COM_REDUCAO_BASE_CALCULO)) {
                System.out.println("======= ICMS 20 ==========");
                NFNotaInfoItemImpostoICMS20 iCMS20 = new NFNotaInfoItemImpostoICMS20();
                iCMS20.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)item.getModalidadeBcIcms()));
                iCMS20.setOrigem(item.getProduto().getOrigem());
                iCMS20.setPercentualAliquota(item.getAliquotaIcms());
                iCMS20.setValorBCICMS(item.getBaseCalculoIcms());
                iCMS20.setValorTributo(item.getValorIcms());
                iCMS20.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.COM_REDUCAO_BASE_CALCULO);
                iCMS20.setPercentualReducaoBC(item.getTaxaReducaoBcIcms());
                icms.setIcms20(iCMS20);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.ISENTA) || NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.NAO_TRIBUTADO)) {
                NFNotaInfoItemImpostoICMS40 iCMS40 = new NFNotaInfoItemImpostoICMS40();
                iCMS40.setOrigem(item.getProduto().getOrigem());
                iCMS40.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()));
                icms.setIcms40(iCMS40);
            }
            if (NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)item.getCstIcms()).equals((Object)NFNotaInfoImpostoTributacaoICMS.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA)) {
                System.out.println("======= ICMS 60 ==========");
                NFNotaInfoItemImpostoICMS60 iCMS60 = new NFNotaInfoItemImpostoICMS60();
                iCMS60.setOrigem(item.getProduto().getOrigem());
                iCMS60.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA);
                iCMS60.setValorBCICMSSTRetido(BigDecimal.ZERO);
                iCMS60.setValorICMSSTRetido(BigDecimal.ZERO);
                iCMS60.setPercentualAliquotaICMSSTConsumidorFinal(BigDecimal.ZERO);
                icms.setIcms60(iCMS60);
            }
        }
        return icms;
    }

    private NFNotaInfoItemImpostoCOFINS getCofins(NFeDetalhe item, Configuracao conf) {
        System.out.println("***** CONFINS: " + item.getProduto().getCofins());
        if (conf.getEmpresaNFe().getLucroPresumido().booleanValue()) {
            NFNotaInfoSituacaoTributariaCOFINS situacaoTributaria = NFNotaInfoSituacaoTributariaCOFINS.valueOfCodigo((String)item.getCstCofins());
            if (NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO.equals((Object)situacaoTributaria) || NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_ALIQUOTA_DIFERENCIADA.equals((Object)situacaoTributaria)) {
                NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
                NFNotaInfoItemImpostoCOFINSAliquota aliquota = new NFNotaInfoItemImpostoCOFINSAliquota();
                aliquota.setPercentualAliquota(item.getAliquotaPisPercentual());
                aliquota.setSituacaoTributaria(situacaoTributaria);
                aliquota.setValorBaseCalculo(item.getBaseCalculoCofins());
                aliquota.setValor(item.getValorCofins());
                cofins.setAliquota(aliquota);
                return cofins;
            }
            NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSOutrasOperacoes cofinsOutrasOperacoes = new NFNotaInfoItemImpostoCOFINSOutrasOperacoes();
            cofinsOutrasOperacoes.setPercentualCOFINS(item.getAliquotaCofinsPercentual());
            cofinsOutrasOperacoes.setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS.OUTRAS_OPERACOES);
            cofinsOutrasOperacoes.setValorBaseCalculo(item.getBaseCalculoCofins());
            cofinsOutrasOperacoes.setValorCOFINS(item.getValorCofins());
            cofins.setOutrasOperacoes(cofinsOutrasOperacoes);
            return cofins;
        }
        if (item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO)) {
            NFNotaInfoItemImpostoCOFINS pis = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSNaoTributavel pISNaoTributado = new NFNotaInfoItemImpostoCOFINSNaoTributavel();
            pISNaoTributado.setSituacaoTributaria(item.getProduto().getCofins());
            pis.setNaoTributavel(pISNaoTributado);
            return pis;
        }
        if (item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_ISENTA_CONTRIBUICAO) || item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_SEM_INCIDENCIA_CONTRIBUICAO) || item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_ALIQUOTA_ZERO)) {
            NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSNaoTributavel cOFINSNaoTributavel = new NFNotaInfoItemImpostoCOFINSNaoTributavel();
            cOFINSNaoTributavel.setSituacaoTributaria(item.getProduto().getCofins());
            cofins.setNaoTributavel(cOFINSNaoTributavel);
            return cofins;
        }
        if (item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO)) {
            NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSAliquota aliquota = new NFNotaInfoItemImpostoCOFINSAliquota();
            aliquota.setPercentualAliquota(item.getAliquotaCofinsPercentual());
            aliquota.setSituacaoTributaria(item.getProduto().getCofins());
            aliquota.setValorBaseCalculo(item.getBaseCalculoCofins());
            aliquota.setValor(item.getValorCofins());
            cofins.setAliquota(aliquota);
            return cofins;
        }
        if (item.getProduto().getCofins().equals((Object)NFNotaInfoSituacaoTributariaCOFINS.OUTRAS_OPERACOES)) {
            NFNotaInfoItemImpostoCOFINS cofins = new NFNotaInfoItemImpostoCOFINS();
            NFNotaInfoItemImpostoCOFINSOutrasOperacoes pISOutrasOperacoes = new NFNotaInfoItemImpostoCOFINSOutrasOperacoes();
            pISOutrasOperacoes.setPercentualCOFINS(BigDecimal.ZERO);
            pISOutrasOperacoes.setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS.OUTRAS_OPERACOES);
            pISOutrasOperacoes.setValorBaseCalculo(BigDecimal.ZERO);
            pISOutrasOperacoes.setValorCOFINS(BigDecimal.ZERO);
            cofins.setOutrasOperacoes(pISOutrasOperacoes);
            return cofins;
        }
        return null;
    }

    private NFNotaInfoItemImpostoIPI getIPI(NFeDetalhe item, Configuracao conf) {
        if (item.getCstIpi().equals(NFNotaInfoSituacaoTributariaIPI.OUTRAS_SAIDAS.getCodigo())) {
            NFNotaInfoItemImpostoIPI ipi = new NFNotaInfoItemImpostoIPI();
            NFNotaInfoItemImpostoIPITributado iPITributado = new NFNotaInfoItemImpostoIPITributado();
            iPITributado.setPercentualAliquota(item.getAliquotaIpi());
            iPITributado.setSituacaoTributaria(NFNotaInfoSituacaoTributariaIPI.OUTRAS_SAIDAS);
            iPITributado.setValorBaseCalculo(item.getBaseCalculoIpi());
            iPITributado.setValorTributo(item.getValorIpi());
            ipi.setCodigoEnquadramento("999");
            ipi.setTributado(iPITributado);
            return ipi;
        }
        return null;
    }

    private NFNotaInfoItemImpostoPIS getPis(NFeDetalhe item, Configuracao conf) {
        if (conf.getEmpresaNFe().getLucroPresumido().booleanValue()) {
            NFNotaInfoSituacaoTributariaPIS situacaoTributaria = NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis());
            if (NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO.equals((Object)situacaoTributaria) || NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_ALIQUOTA_DIFERENCIADA.equals((Object)situacaoTributaria)) {
                NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
                NFNotaInfoItemImpostoPISAliquota aliquota = new NFNotaInfoItemImpostoPISAliquota();
                aliquota.setPercentualAliquota(item.getAliquotaPisPercentual());
                aliquota.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis()));
                aliquota.setValorBaseCalculo(item.getValorBaseCalculoPis());
                aliquota.setValorTributo(item.getValorPis());
                pis.setAliquota(aliquota);
                return pis;
            }
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISOutrasOperacoes pISOutrasOperacoes = new NFNotaInfoItemImpostoPISOutrasOperacoes();
            pISOutrasOperacoes.setPercentualAliquota(item.getAliquotaPisPercentual());
            pISOutrasOperacoes.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.OUTRAS_OPERACOES);
            pISOutrasOperacoes.setValorBaseCalculo(item.getValorBaseCalculoPis());
            pISOutrasOperacoes.setValorTributo(item.getValorPis());
            pis.setOutrasOperacoes(pISOutrasOperacoes);
            return pis;
        }
        if (NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO.equals((Object)NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis())) || NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_ALIQUOTA_DIFERENCIADA.equals((Object)NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis()))) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISAliquota aliquota = new NFNotaInfoItemImpostoPISAliquota();
            aliquota.setPercentualAliquota(item.getAliquotaPisPercentual());
            aliquota.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)item.getCstPis()));
            aliquota.setValorBaseCalculo(item.getValorBaseCalculoPis());
            aliquota.setValorTributo(item.getValorPis());
            pis.setAliquota(aliquota);
            return pis;
        }
        if (item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO)) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISNaoTributado pISNaoTributado = new NFNotaInfoItemImpostoPISNaoTributado();
            pISNaoTributado.setSituacaoTributaria(item.getProduto().getPis());
            pis.setNaoTributado(pISNaoTributado);
            return pis;
        }
        if (item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_ISENTA_CONTRIBUICAO) || item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_SEM_INCIDENCIA_CONTRIBUICAO) || item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_ALIQUOTA_ZERO)) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISNaoTributado pISNaoTributado = new NFNotaInfoItemImpostoPISNaoTributado();
            pISNaoTributado.setSituacaoTributaria(item.getProduto().getPis());
            pis.setNaoTributado(pISNaoTributado);
            return pis;
        }
        if (item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO)) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISAliquota aliquota = new NFNotaInfoItemImpostoPISAliquota();
            aliquota.setPercentualAliquota(item.getAliquotaPisPercentual());
            aliquota.setSituacaoTributaria(item.getProduto().getPis());
            aliquota.setValorBaseCalculo(item.getValorBaseCalculoPis());
            aliquota.setValorTributo(item.getValorPis());
            pis.setAliquota(aliquota);
            return pis;
        }
        if (item.getProduto().getPis().equals((Object)NFNotaInfoSituacaoTributariaPIS.OUTRAS_OPERACOES)) {
            NFNotaInfoItemImpostoPIS pis = new NFNotaInfoItemImpostoPIS();
            NFNotaInfoItemImpostoPISOutrasOperacoes pISOutrasOperacoes = new NFNotaInfoItemImpostoPISOutrasOperacoes();
            pISOutrasOperacoes.setPercentualAliquota(BigDecimal.ZERO);
            pISOutrasOperacoes.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.OUTRAS_OPERACOES);
            pISOutrasOperacoes.setValorBaseCalculo(BigDecimal.ZERO);
            pISOutrasOperacoes.setValorTributo(BigDecimal.ZERO);
            pis.setOutrasOperacoes(pISOutrasOperacoes);
            return pis;
        }
        return null;
    }

    private NFNotaInfoIdentificacao getIdentificacao(NFeCabecalho info, NFeEmitente emitente, NFeDestinatario destinatario, Configuracao conf, List<NFeDocumento> documentos, List<NFeDetalhe> itens) throws MaximaException {
        NFeConfigMaxima maxima = new NFeConfigMaxima(conf);
        NFNotaInfoIdentificacao ident = new NFNotaInfoIdentificacao();
        ident.setAmbiente(maxima.getAmbiente());
        ident.setCodigoMunicipio(emitente.getMunicipio().getCodigoIBGE());
        ident.setCodigoRandomico(info.getCodigoNumerico());
        ident.setDataHoraEmissao(MaximaDate.convert((LocalDate)info.getDataEmissao()));
        ident.setDigitoVerificador(Integer.valueOf(info.getDigitoChaveAcesso()));
        ident.setFinalidade(NFFinalidade.valueOfCodigo((String)info.getFinalidadeEmissao().getCodigo()));
        List nFInfoReferenciadas = this.getDocumentos(documentos);
        if (nFInfoReferenciadas != null && !nFInfoReferenciadas.isEmpty()) {
            ident.setReferenciadas(nFInfoReferenciadas);
        }
        if (emitente.getUf().equals(destinatario.getUf())) {
            boolean operacaoExterna = false;
            for (NFeDetalhe det : itens) {
                String cfop = det.getCfop().toString();
                if (!cfop.startsWith("6") && !cfop.startsWith("2")) continue;
                operacaoExterna = true;
                break;
            }
            if (operacaoExterna) {
                ident.setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao.OPERACAO_INTERESTADUAL);
            } else {
                ident.setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao.OPERACAO_INTERNA);
            }
        } else {
            ident.setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao.OPERACAO_INTERESTADUAL);
        }
        ident.setIndicadorPresencaComprador(NFIndicadorPresencaComprador.NAO_APLICA);
        ident.setModelo(DFModelo.NFE);
        ident.setNaturezaOperacao(info.getNaturezaOperacao());
        ident.setNumeroNota(info.getNumero().trim());
        ident.setOperacaoConsumidorFinal(info.getConsumidorFinal());
        ident.setProgramaEmissor(NFProcessoEmissor.CONTRIBUINTE);
        Integer serie = Integer.parseInt(info.getSerie());
        ident.setSerie(serie.toString());
        ident.setTipo(info.getTipoOperacao());
        ident.setTipoEmissao(NFTipoEmissao.EMISSAO_NORMAL);
        ident.setTipoImpressao(NFTipoImpressao.DANFE_NORMAL_RETRATO);
        ident.setUf(DFUnidadeFederativa.valueOfCodigo((String)emitente.getMunicipio().getEstado().getSigla()));
        ident.setVersaoEmissor("5.00");
        if (info.getCupomSatRef() != null && !info.getCupomSatRef().isEmpty()) {
            NFInfoReferenciada ref = new NFInfoReferenciada();
            ref.setChaveAcesso(info.getCupomSatRef());
            ArrayList<NFInfoReferenciada> referenciadaList = new ArrayList<NFInfoReferenciada>();
            referenciadaList.add(ref);
            ident.setReferenciadas(referenciadaList);
        }
        if (info.getCupomECF() != null && !info.getCupomECF().isEmpty()) {
            NFInfoCupomFiscalReferenciado refCupom = new NFInfoCupomFiscalReferenciado();
            refCupom.setModeloDocumentoFiscal("2D");
            refCupom.setNumeroContadorOrdemOperacao(MaximaUtils.completaZeroEsquerda((String)info.getCupomCOO(), (Integer)6));
            refCupom.setNumeroOrdemSequencialECF(info.getCupomECF());
            NFInfoReferenciada ref = new NFInfoReferenciada();
            ref.setCupomFiscalReferenciado(refCupom);
            ArrayList<NFInfoReferenciada> referenciadaList = new ArrayList<NFInfoReferenciada>();
            referenciadaList.add(ref);
            ident.setReferenciadas(referenciadaList);
        }
        return ident;
    }

    private List<NFInfoReferenciada> getDocumentos(List<NFeDocumento> documentoList) {
        ArrayList<NFInfoReferenciada> notasReferenciadas = new ArrayList<NFInfoReferenciada>();
        if (!documentoList.isEmpty()) {
            documentoList.stream().map(doc -> {
                NFInfoReferenciada infoReferenciada = new NFInfoReferenciada();
                infoReferenciada.setChaveAcesso(doc.getChaveAcesso());
                return infoReferenciada;
            }).forEachOrdered(infoReferenciada -> notasReferenciadas.add((NFInfoReferenciada)infoReferenciada));
        }
        return notasReferenciadas;
    }

    private NFNotaInfoPagamento getPagamentos(NFeCabecalho nfe) {
        NFNotaInfoPagamento pgto = new NFNotaInfoPagamento();
        ArrayList<NFNotaInfoFormaPagamento> detalhamentoFormasPagamento = new ArrayList<NFNotaInfoFormaPagamento>();
        NFNotaInfoFormaPagamento formaPagamento = new NFNotaInfoFormaPagamento();
        formaPagamento.setMeioPagamento(nfe.getFormaPagamento());
        if (formaPagamento.getMeioPagamento().equals((Object)NFMeioPagamento.SEM_PAGAMENTO)) {
            formaPagamento.setValorPagamento(BigDecimal.ZERO);
        } else {
            formaPagamento.setValorPagamento(nfe.getValorTotal());
            formaPagamento.setIndicadorFormaPagamento(nfe.getCondicaoPagamento());
        }
        if (formaPagamento.getMeioPagamento().equals((Object)NFMeioPagamento.CARTAO_DEBITO) || formaPagamento.getMeioPagamento().equals((Object)NFMeioPagamento.CARTAO_CREDITO) || formaPagamento.getMeioPagamento().equals((Object)NFMeioPagamento.PIX)) {
            NFNotaInfoCartao inforCartao = new NFNotaInfoCartao();
            inforCartao.setTipoIntegracao(NFTipoIntegracaoPagamento.SEPARADO);
            formaPagamento.setCartao(inforCartao);
        }
        detalhamentoFormasPagamento.add(formaPagamento);
        pgto.setDetalhamentoFormasPagamento(detalhamentoFormasPagamento);
        return pgto;
    }

    private NFNotaInfoDestinatario getDestinatario(NFeDestinatario destinatario, NFeCabecalho nfe) {
        NFEndereco endereco = new NFEndereco();
        endereco.setBairro(MaximaUtils.getText((String)destinatario.getBairro()));
        endereco.setCep(MaximaUtils.removeCaracteres((String)destinatario.getCep()));
        endereco.setCodigoMunicipio(destinatario.getMunicipio().getCodigoIBGE().trim());
        endereco.setCodigoPais("1058");
        endereco.setDescricaoMunicipio(MaximaUtils.getText((String)destinatario.getMunicipio().getNome()));
        endereco.setDescricaoPais("BRASIL");
        endereco.setLogradouro(MaximaUtils.getText((String)destinatario.getLogradouro()));
        endereco.setNumero(MaximaUtils.getText((String)destinatario.getNumero()));
        endereco.setTelefone(MaximaUtils.removeCaracteres((String)destinatario.getTelefone()));
        endereco.setUf(DFUnidadeFederativa.valueOfCodigo((String)destinatario.getMunicipio().getEstado().getSigla()));
        NFNotaInfoDestinatario dest = new NFNotaInfoDestinatario();
        if (destinatario.getCpfCnpj().length() < 14) {
            dest.setCpf(MaximaUtils.removeCaracteres((String)destinatario.getCpfCnpj()));
        } else {
            dest.setCnpj(MaximaUtils.removeCaracteres((String)destinatario.getCpfCnpj()));
        }
        dest.setEndereco(endereco);
        dest.setRazaoSocial(destinatario.getRazaoSocial().trim());
        String IE = MaximaUtils.removeCaracteres((String)destinatario.getIe());
        if (dest.getCnpj() != null) {
            if (IE != null && !IE.isEmpty() && !IE.toUpperCase().equals("ISENTO")) {
                dest.setIndicadorIEDestinatario(NFIndicadorIEDestinatario.CONTRIBUINTE_ICMS);
                dest.setInscricaoEstadual(IE);
            } else {
                dest.setIndicadorIEDestinatario(NFIndicadorIEDestinatario.NAO_CONTRIBUINTE);
                this.icmsDestino = true;
            }
        } else if (nfe.getCliente().getContribuinteIcms().booleanValue()) {
            dest.setIndicadorIEDestinatario(NFIndicadorIEDestinatario.CONTRIBUINTE_ICMS);
            dest.setInscricaoEstadual(IE);
        } else {
            this.icmsDestino = true;
            dest.setIndicadorIEDestinatario(NFIndicadorIEDestinatario.NAO_CONTRIBUINTE);
        }
        return dest;
    }

    private NFNotaInfoEmitente getEmitente(NFeEmitente emitente, Configuracao conf) {
        NFEndereco endereco = new NFEndereco();
        endereco.setBairro(MaximaUtils.getText((String)emitente.getBairro()));
        endereco.setCep(MaximaUtils.removeCaracteres((String)emitente.getCep()));
        endereco.setCodigoMunicipio(emitente.getMunicipio().getCodigoIBGE());
        endereco.setCodigoPais("1058");
        endereco.setDescricaoMunicipio(MaximaUtils.getText((String)emitente.getMunicipio().getNome()));
        endereco.setDescricaoPais("BRASIL");
        endereco.setLogradouro(MaximaUtils.getText((String)emitente.getLogradouro()));
        endereco.setNumero(MaximaUtils.getText((String)emitente.getNumero()));
        endereco.setTelefone(MaximaUtils.removeCaracteres((String)emitente.getTelefone()));
        endereco.setUf(DFUnidadeFederativa.valueOfCodigo((String)conf.getEmpresaNFe().getMunicipio().getEstado().getSigla()));
        NFNotaInfoEmitente emit = new NFNotaInfoEmitente();
        emit.setCnpj(MaximaUtils.removeCaracteres((String)emitente.getCpfCnpj()));
        if (conf.getEmpresaNFe().getInscMunicipal() != null && !conf.getEmpresaNFe().getInscMunicipal().isEmpty()) {
            emit.setInscricaoMunicipal(MaximaUtils.removeCaracteres((String)conf.getEmpresaNFe().getInscMunicipal()));
        }
        emit.setEndereco(endereco);
        emit.setInscricaoEstadual(MaximaUtils.removeCaracteres((String)emitente.getIe()));
        emit.setRazaoSocial(MaximaUtils.getText((String)emitente.getRazaoSocial()));
        emit.setRegimeTributario(conf.getEmpresaNFe().getRegime());
        return emit;
    }
}

