/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.form.NFIcms900Form;
import br.com.maximasolutions.utils.MaximaNumber;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class NotaFiscalIcmsFormController
extends MaximaController
implements Initializable {
    @FXML
    private ComboBox<NFNotaSituacaoOperacionalSimplesNacional> cbbCsosn;
    @FXML
    private TextField tfBaseCalculoIcms;
    @FXML
    private TextField tfAliquotaIcms;
    @FXML
    private TextField tfValorIcms;
    @FXML
    private Button btnSalva;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private NFIcms900Form icms900Form;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.cbbCsosn.getSelectionModel().select((Object)NFNotaSituacaoOperacionalSimplesNacional.OUTROS);
        this.tfBaseCalculoIcms.setText(null);
        this.tfAliquotaIcms.setText(null);
        this.tfValorIcms.setText(null);
        this.tfBaseCalculoIcms.requestFocus();
    }

    public NFIcms900Form getIcms900Form() {
        return this.icms900Form;
    }

    private void salva() {
        BigDecimal baseCalculo = MaximaNumber.moneyToBigDecimal((String)this.tfBaseCalculoIcms.getText());
        BigDecimal aliquota = MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaIcms.getText());
        BigDecimal valor = MaximaNumber.moneyToBigDecimal((String)this.tfValorIcms.getText());
        if (baseCalculo == null || aliquota == null || valor == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Informe todos os valores.");
            return;
        }
        if (valor.compareTo(baseCalculo.multiply(aliquota).divide(new BigDecimal(100), 2, RoundingMode.HALF_EVEN)) != 0) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"AVISO: Valor do ICMS incorreto.");
            return;
        }
        this.icms900Form = new NFIcms900Form(baseCalculo, aliquota, valor);
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaCombos() {
        ArrayList<NFNotaSituacaoOperacionalSimplesNacional> csosns = new ArrayList<NFNotaSituacaoOperacionalSimplesNacional>();
        csosns.add(NFNotaSituacaoOperacionalSimplesNacional.OUTROS);
        this.cbbCsosn.setItems(FXCollections.observableArrayList(csosns));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

