/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.form.NFIpiForm;
import br.com.maximasolutions.utils.MaximaNumber;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaIPI;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class NotaFiscalIpiFormController
extends MaximaController
implements Initializable {
    @FXML
    private ComboBox<NFNotaInfoSituacaoTributariaIPI> cbbCstIpi;
    @FXML
    private TextField tfBaseCalculoIpi;
    @FXML
    private TextField tfAliquotaIpi;
    @FXML
    private TextField tfValorIpi;
    @FXML
    private TextField tfValorIpiDev;
    @FXML
    private Button btnSalva;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private NFIpiForm ipiForm;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.cbbCstIpi.getSelectionModel().select((Object)NFNotaInfoSituacaoTributariaIPI.OUTRAS_SAIDAS);
        this.tfBaseCalculoIpi.setText(null);
        this.tfAliquotaIpi.setText(null);
        this.tfValorIpi.setText(null);
        this.tfValorIpiDev.setText(null);
        this.tfBaseCalculoIpi.requestFocus();
    }

    public NFIpiForm getIcms900Form() {
        return this.ipiForm;
    }

    private void salva() {
        BigDecimal baseCalculo = MaximaNumber.moneyToBigDecimal((String)this.tfBaseCalculoIpi.getText());
        BigDecimal aliquota = MaximaNumber.moneyToBigDecimal((String)this.tfAliquotaIpi.getText());
        BigDecimal valor = MaximaNumber.moneyToBigDecimal((String)this.tfValorIpi.getText());
        BigDecimal valorDev = MaximaNumber.moneyToBigDecimal((String)this.tfValorIpiDev.getText());
        this.ipiForm = new NFIpiForm((NFNotaInfoSituacaoTributariaIPI)this.cbbCstIpi.getSelectionModel().getSelectedItem(), baseCalculo, aliquota, valor, valorDev);
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaCombos() {
        ArrayList<NFNotaInfoSituacaoTributariaIPI> csosns = new ArrayList<NFNotaInfoSituacaoTributariaIPI>();
        csosns.add(NFNotaInfoSituacaoTributariaIPI.OUTRAS_SAIDAS);
        this.cbbCstIpi.setItems(FXCollections.observableArrayList(csosns));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

