/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.fiscal.certificado.AssinaturaDigitalA3;
import br.com.maximasolutions.fiscal.certificado.MaximaCertificado;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.nfe.controller.NotaFiscalCancelaXml;
import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFEnviaEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFInfoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFInfoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFTipoEventoManifestacaoDestinatario;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NotaFiscalManifestacaoDestinatarioXml {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");

    public String geraXml(String chaveAcesso, NFTipoEventoManifestacaoDestinatario tipoEvento, String motivo, String cnpj, Configuracao conf) throws Exception {
        try {
            NFeConfigMaxima config = new NFeConfigMaxima(conf);
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            String xml = this.gerarDadosManifestacaoDestinatario(chaveAcesso, NFTipoEventoManifestacaoDestinatario.CIENCIA_DA_EMISSAO, motivo, cnpj).toString();
            System.out.println("XML MANIFEST: " + xml);
            xml = xml.replace("\n", "#");
            return new AssinaturaDigitalA3().assinaCancNFe(xml, config.getCertificadoA3Senha(), conf.getAliasCertificado());
        }
        catch (Exception e) {
            Logger.getLogger(NotaFiscalCancelaXml.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new Exception(e);
        }
    }

    public NFEnviaEventoManifestacaoDestinatario gerarDadosManifestacaoDestinatario(String chaveAcesso, NFTipoEventoManifestacaoDestinatario tipoEvento, String motivo, String cnpj) {
        NFInfoManifestacaoDestinatario manifestacaoDestinatario = new NFInfoManifestacaoDestinatario();
        manifestacaoDestinatario.setDescricaoEvento(tipoEvento.getDescricao());
        manifestacaoDestinatario.setVersao(VERSAO_LEIAUTE);
        manifestacaoDestinatario.setJustificativa(null);
        DFAmbiente ambiente = DFAmbiente.PRODUCAO;
        if (MaximaConfig.getInstance().getProperty("nfambiente") != null && MaximaConfig.getInstance().getProperty("nfambiente").equalsIgnoreCase("homologacao")) {
            ambiente = DFAmbiente.HOMOLOGACAO;
        }
        NFInfoEventoManifestacaoDestinatario infoEvento = new NFInfoEventoManifestacaoDestinatario();
        infoEvento.setAmbiente(ambiente);
        infoEvento.setChave(chaveAcesso);
        infoEvento.setCnpj(cnpj);
        infoEvento.setDataHoraEvento(ZonedDateTime.now());
        infoEvento.setId(String.format("ID%s%s0%s", tipoEvento.getCodigo(), chaveAcesso, "1"));
        infoEvento.setNumeroSequencialEvento(1);
        infoEvento.setOrgao(DFUnidadeFederativa.RFB);
        infoEvento.setCodigoEvento(tipoEvento.getCodigo());
        infoEvento.setVersaoEvento(VERSAO_LEIAUTE);
        infoEvento.setManifestacaoDestinatario(manifestacaoDestinatario);
        NFEventoManifestacaoDestinatario evento = new NFEventoManifestacaoDestinatario();
        evento.setInfoEvento(infoEvento);
        evento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoManifestacaoDestinatario enviaEvento = new NFEnviaEventoManifestacaoDestinatario();
        enviaEvento.setEvento(Collections.singletonList(evento));
        enviaEvento.setIdLote(Long.toString(ZonedDateTime.now().toInstant().toEpochMilli()));
        enviaEvento.setVersao(VERSAO_LEIAUTE);
        return enviaEvento;
    }
}

