/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class NotaFiscalValorFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfValorFrete;
    @FXML
    private TextField tfValorOutrasDespesas;
    @FXML
    private TextField tfValorDesconto;
    @FXML
    private Button btnSalva;
    @Lazy
    @Autowired
    private StageManager stageManager;
    private BigDecimal valorFrete;
    private BigDecimal valorOutrasDespesas;
    private BigDecimal valorDesconto;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.valorFrete = BigDecimal.ZERO;
        this.valorOutrasDespesas = BigDecimal.ZERO;
        this.valorDesconto = BigDecimal.ZERO;
    }

    public BigDecimal getValorFrete() {
        if (this.valorFrete == null) {
            return BigDecimal.ZERO;
        }
        return this.valorFrete;
    }

    public BigDecimal getValorOutrasDespesas() {
        if (this.valorOutrasDespesas == null) {
            return BigDecimal.ZERO;
        }
        return this.valorOutrasDespesas;
    }

    public BigDecimal getValorDesconto() {
        if (this.valorDesconto == null) {
            return BigDecimal.ZERO;
        }
        return this.valorDesconto;
    }

    private void salva() {
        this.valorFrete = MaximaNumber.moneyToBigDecimal((String)this.tfValorFrete.getText());
        this.valorOutrasDespesas = MaximaNumber.moneyToBigDecimal((String)this.tfValorOutrasDespesas.getText());
        this.valorDesconto = MaximaNumber.moneyToBigDecimal((String)this.tfValorDesconto.getText());
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

