/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.nfe.service.NotaFiscalService;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioNotaFiscalController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private NotaFiscalService notaFiscalService;
    @Autowired
    private ClienteService clienteService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnClientePesquisa;
    @FXML
    private Button btnClienteLimpa;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfClientePesquisa;
    @FXML
    private TextField tfClienteNome;
    private BigDecimal total;
    private Cliente cliente;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.cliente = null;
    }

    private void geraRelatorio() {
        List notas;
        if (!this.validaForm()) {
            return;
        }
        Long clienteId = null;
        if (this.cliente != null) {
            clienteId = this.cliente.getId();
        }
        if ((notas = this.notaFiscalService.relatorio((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), clienteId)) == null || notas.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        this.calculaTotal(notas);
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            params.put("FILTRO", "PER\u00cdODO DE: " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " \u00e0 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            params.put("TOTAL", this.total);
            params.put("ITENS", notas.size());
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)notas);
            new PrintReport().showReport("/jasper/fiscal/nfe/nota_fiscal.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioNotaFiscalController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<NFeCabecalho> notas) {
        this.total = BigDecimal.ZERO;
        notas.stream().forEachOrdered(nfe -> {
            if (nfe.getStatusNota().equals((Object)NFeStatus.AUTORIZADA)) {
                this.total = this.total.add(nfe.getValorTotal());
            }
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnClientePesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnClienteLimpa.setGraphic((Node)maximaIcone.getIconeDelete());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnClienteLimpa.setOnAction(t -> {
            this.cliente = null;
            this.loadDadosCliente();
        });
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.tfClientePesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.btnClientePesquisa.setOnAction(event -> this.pesquisaClienteForm());
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClientePesquisa.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                this.cliente = clientePesquisa;
            } else {
                this.cliente = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de cliente n\u00e3o encontrado.");
                this.tfClientePesquisa.requestFocus();
                this.tfClientePesquisa.selectAll();
            }
            this.loadDadosCliente();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaClienteForm();
            return;
        }
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnClientePesquisa.getScene(), this.tfClientePesquisa.getText().trim());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClientePesquisa.setText(this.cliente.getId().toString());
            this.tfClienteNome.setText(this.cliente.getNome().toUpperCase());
        } else {
            this.tfClienteNome.setText("");
            this.tfClientePesquisa.setText("");
            this.tfClientePesquisa.requestFocus();
        }
    }

    private void loadCombos() {
    }
}

