/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.repository;

import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.fiscal.modelo.NFeDetalhe;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface NotaFiscalItemRepository
extends JpaRepository<NFeDetalhe, Long> {
    @Query(value="SELECT o FROM NFeDetalhe o WHERE o.nfeCabecalho.id = :nfeId ORDER BY o.numeroItem")
    public List<NFeDetalhe> listaProdutos(@Param(value="nfeId") Long var1);

    @Query(value="SELECT o.unidadeComercial FROM NFeDetalhe o WHERE (o.nfeCabecalho.statusNota = :autorizada ) AND (o.nfeCabecalho.dataEmissao between :dataInicio and :dataFim) GROUP BY o.unidadeComercial")
    public List<String> listaTipoUnidade(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3);

    @Query(value="SELECT o.produto FROM NFeDetalhe o WHERE (o.nfeCabecalho.statusNota = :autorizada ) AND (o.nfeCabecalho.dataEmissao between :dataInicio and :dataFim) GROUP BY o.produto.id")
    public List<Produto> listaProduto(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3);

    @Query(value="SELECT cstIcms, cfop, aliquotaIcms, sum(o.valorTotal), sum(o.baseCalculoIcms), sum(o.valorIcms), sum(o.baseCalculoIcmsSt), sum(o.valorIcmsSt), sum(o.valorBrutoProdutos - o.baseCalculoIcms), sum(o.valorIpi)  FROM NFeDetalhe o WHERE o.nfeCabecalho.id = :nfeId GROUP BY o.cstIcms, o.cfop, o.aliquotaIcms")
    public List<Object[]> listaSpedRegistro190(@Param(value="nfeId") Long var1);

    @Modifying
    @Query(value="DELETE FROM NFeDetalhe o WHERE o.nfeCabecalho.id = :nfeId")
    public void deleteItens(@Param(value="nfeId") Long var1);

    @Query(value="SELECT o FROM NFeDetalhe o WHERE (o.nfeCabecalho.statusNota = :autorizada ) AND (o.nfeCabecalho.dataEmissao between :dataInicio and :dataFim) AND (o.cstPis = :pis AND o.cstCofins = :cofins) ORDER BY o.produto.nome, o.nfeCabecalho.dataEmissao")
    public List<NFeDetalhe> monofasicos(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3, @Param(value="pis") String var4, @Param(value="cofins") String var5);

    @Query(value="SELECT o FROM NFeDetalhe o WHERE (o.nfeCabecalho.statusNota = :autorizada ) AND (o.nfeCabecalho.dataEmissao between :dataInicio and :dataFim) ORDER BY o.produto.nome, o.nfeCabecalho.dataEmissao")
    public List<NFeDetalhe> relatorio(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3);

    @Query(value="SELECT o.produto.nome, o.quantidadeComercial, o.valorUnitarioComercial, o.valorTotal, o.nfeCabecalho.dataEmissao, o.nfeCabecalho.numero  FROM NFeDetalhe o WHERE (o.nfeCabecalho.statusNota = :autorizada ) AND (o.nfeCabecalho.dataEmissao between :dataInicio and :dataFim) GROUP BY o.produto.id ORDER BY o.produto.nome, o.nfeCabecalho.dataEmissao")
    public List<Object[]> relatorioBean(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3);

    @Query(value="SELECT o.produto.nome, sum(o.quantidadeComercial), avg(o.valorUnitarioComercial), sum(o.valorTotal)  FROM NFeDetalhe o WHERE (o.nfeCabecalho.statusNota = :autorizada ) AND (o.nfeCabecalho.dataEmissao between :dataInicio and :dataFim) GROUP BY o.produto.id ORDER BY o.produto.nome, o.nfeCabecalho.dataEmissao")
    public List<Object[]> relatorioArupadoBean(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2, @Param(value="autorizada") NFeStatus var3);
}

