/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.nfe.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.fiscal.certificado.AssinaturaDigitalA3;
import br.com.maximasolutions.fiscal.certificado.MaximaCertificado;
import br.com.maximasolutions.fiscal.config.NFeConfigMaxima;
import br.com.maximasolutions.fiscal.modelo.NFeCabecalho;
import br.com.maximasolutions.fiscal.modelo.NFeCobranca;
import br.com.maximasolutions.fiscal.modelo.NFeDestinatario;
import br.com.maximasolutions.fiscal.modelo.NFeDetalhe;
import br.com.maximasolutions.fiscal.modelo.NFeDocumento;
import br.com.maximasolutions.fiscal.modelo.NFeEmitente;
import br.com.maximasolutions.fiscal.modelo.NFeEvento;
import br.com.maximasolutions.fiscal.modelo.NFeInutilizacao;
import br.com.maximasolutions.fiscal.modelo.NFeStatus;
import br.com.maximasolutions.fiscal.modelo.NFeTransportadora;
import br.com.maximasolutions.fiscal.modelo.NFeVeiculo;
import br.com.maximasolutions.fiscal.sped.bean.BlocoCRegistro190;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Estado;
import br.com.maximasolutions.nfe.controller.NotaFiscalFormController;
import br.com.maximasolutions.nfe.controller.NotaFiscalGeraXml;
import br.com.maximasolutions.nfe.relatorio.bean.RelatorioFiscalProdutoBean;
import br.com.maximasolutions.nfe.repository.GrupoICMSRepository;
import br.com.maximasolutions.nfe.repository.NFeCobrancaRepository;
import br.com.maximasolutions.nfe.repository.NFeDestinatarioRepository;
import br.com.maximasolutions.nfe.repository.NFeDocumentoRepository;
import br.com.maximasolutions.nfe.repository.NFeEmitenteRepository;
import br.com.maximasolutions.nfe.repository.NFeEventoRepository;
import br.com.maximasolutions.nfe.repository.NFeInutilizacaoRepository;
import br.com.maximasolutions.nfe.repository.NFeTransportadoraRepository;
import br.com.maximasolutions.nfe.repository.NFeVeiculoRepository;
import br.com.maximasolutions.nfe.repository.NotaFiscalItemRepository;
import br.com.maximasolutions.nfe.repository.NotaFiscalRepository;
import br.com.maximasolutions.nfe.service.NotaFiscalService;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFProtocolo;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEvento;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEnviaEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFProtocoloEventoCancelamento;
import com.fincatto.documentofiscal.nfe400.classes.evento.cartacorrecao.NFEnviaEventoCartaCorrecao;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteIndicadorProcessamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import com.fincatto.documentofiscal.nfe400.classes.nota.consulta.NFProtocoloEvento;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.fincatto.documentofiscal.utils.DFPersister;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaValidacaoException.class})
public class NotaFiscalServiceImpl
implements NotaFiscalService {
    @Autowired
    private NotaFiscalRepository notaFiscalRepository;
    @Autowired
    private NFeEmitenteRepository emitenteRepository;
    @Autowired
    private NFeDestinatarioRepository destinatarioRepository;
    @Autowired
    private NotaFiscalItemRepository notaFiscalItemRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private NFeEventoRepository nFeEventoRepository;
    @Autowired
    private NFeCobrancaRepository nFeCobrancaRepository;
    @Autowired
    private NFeDocumentoRepository nFeDocumentoRepository;
    @Autowired
    private NFeTransportadoraRepository transportadoraRepository;
    @Autowired
    private NFeVeiculoRepository veiculoRepository;
    @Autowired
    private GrupoICMSRepository iCMSRepository;
    @Autowired
    private NFeInutilizacaoRepository nFeInutilizacaoRepository;

    @Transactional(readOnly=true)
    public String getXmlAssinado(NFeCabecalho nfe) throws MaximaException {
        try {
            NFeDestinatario destinatario = this.destinatarioRepository.get(nfe.getId());
            NFeEmitente emitente = this.emitenteRepository.get(nfe.getId());
            NFeTransportadora transportadora = this.transportadoraRepository.get(nfe.getId());
            List produtoLista = this.notaFiscalItemRepository.listaProdutos(nfe.getId());
            NFeVeiculo veiculo = this.veiculoRepository.get(nfe.getId());
            Configuracao conf = this.configuracaoRepository.load();
            NFNota notaObjeto = new NotaFiscalGeraXml().getNFNota(nfe, destinatario, emitente, produtoLista, conf, transportadora, veiculo, this.nFeCobrancaRepository.list(nfe.getId()), this.nFeDocumentoRepository.list(nfe.getId()), this.iCMSRepository.get(DFUnidadeFederativa.valueOfCodigo((String)destinatario.getUf())));
            ArrayList<NFNota> notas = new ArrayList<NFNota>();
            notas.add(notaObjeto);
            NFLoteEnvio lote = new NFLoteEnvio();
            lote.setIndicadorProcessamento(NFLoteIndicadorProcessamento.PROCESSAMENTO_ASSINCRONO);
            lote.setNotas(notas);
            lote.setVersao(NFeConfigMaxima.VERSAO_NFE);
            lote.setIdLote(notaObjeto.getInfo().getIdentificacao().getNumeroNota());
            String documentoAssinado = new AssinaturaDigitalA3().assinaEnviNFe(lote.toString(), conf.getSenhaCertificado(), conf.getAliasCertificado());
            return documentoAssinado;
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Ops, falha ao assinar/validar xml.\n" + ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NFeCabecalho transmite(NFeCabecalho nfe, String documentoAssinado) throws MaximaException {
        try {
            Configuracao conf = this.configuracaoRepository.load();
            nfe.setXmlTxt(documentoAssinado);
            nfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
            MaximaFile.escreveTexto((String)"C:/Maxima/nfe_envia.xml", (String)documentoAssinado);
            NFeConfigMaxima nfeConfigMaxima = new NFeConfigMaxima(conf);
            WSFacade facade = new WSFacade((NFeConfig)nfeConfigMaxima);
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            NFLoteEnvioRetorno retorno = facade.enviaLoteAssinado(documentoAssinado, DFModelo.NFE);
            System.out.println("=== retorno: " + retorno);
            System.out.println("==== teste " + retorno.getProtocoloRecebimentoSincrono());
            if (!retorno.getStatus().equals("104")) throw new MaximaException("Nota Fiscal Eletr\u00f4nica REJEITADA.\nMotivo:" + retorno.getMotivo());
            if (!retorno.getProtocoloInfo().getStatus().equals("100")) throw new MaximaException("Nota Fiscal Eletr\u00f4nica REJEITADA.\nMotivo:" + retorno.getProtocoloInfo().getMotivo());
            NFNotaProcessada notaProcessada = new NFNotaProcessada();
            notaProcessada.setVersao(new BigDecimal(NFeConfigMaxima.VERSAO_NFE));
            NFProtocolo nFProtocolo = new NFProtocolo();
            nFProtocolo.setAssinatura(retorno.getAssinatura());
            nFProtocolo.setProtocoloInfo(retorno.getProtocoloInfo());
            nFProtocolo.setVersao(retorno.getVersao());
            notaProcessada.setProtocolo(nFProtocolo);
            NFLoteEnvio lote = (NFLoteEnvio)new DFPersister().read(NFLoteEnvio.class, nfe.getXmlTxt());
            notaProcessada.setNota((NFNota)lote.getNotas().get(0));
            nfe.setXmlTxt(notaProcessada.toString());
            nfe.setStatusNota(NFeStatus.AUTORIZADA);
            nfe.setnProt(retorno.getProtocoloInfo().getNumeroProtocolo());
            nfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
            NFeEvento evento = new NFeEvento();
            evento.setCorrecao(null);
            evento.setDataEvento(LocalDateTime.now());
            evento.setMotivoCanc(null);
            evento.setNfeCabecalho(nfe);
            evento.setNumeroSeq(Integer.valueOf(0));
            evento.setProtocolo(nfe.getnProt());
            evento.setTipoEvento("Autorizacao");
            this.nFeEventoRepository.save((Object)evento);
            String path = conf.getCaminhoNFe() + nfe.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
            File diretorio = new File(path);
            if (!diretorio.exists()) {
                diretorio.mkdir();
            }
            String caminhoArquivo = path + nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso() + "-NFe.xml";
            MaximaFile.escreveTexto((String)caminhoArquivo, (String)nfe.getXmlTxt());
            return nfe;
        }
        catch (MaximaException | IOException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException(ex);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException((Throwable)ex);
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException((Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NFeCabecalho consulta(NFeCabecalho nfe) throws MaximaException {
        Configuracao conf = this.configuracaoRepository.load();
        if (nfe.getRetornoStatus() != null && nfe.getRetornoStatus().equals("103")) {
            try {
                new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            }
            catch (MaximaException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException(ex);
            }
            try {
                String path;
                NFLoteConsultaRetorno retorno2 = new WSFacade((NFeConfig)new NFeConfigMaxima(conf)).consultaLote(nfe.getRecibo(), DFModelo.NFE);
                System.out.println("retorno consulta: " + retorno2.toString());
                if (retorno2.getStatus().equals("105")) {
                    throw new MaximaException("Lote em processamento. Aguarde 3 minutos e consulte novamente");
                }
                if (retorno2.getStatus().equals("656")) {
                    throw new MaximaException("Rejei\u00e7\u00e3o: Consumo Indevido. Dever\u00e1 aguardar uma hora para tentar executar opera\u00e7\u00e3o novamente.");
                }
                if (retorno2.getProtocolos() == null) {
                    nfe.setStatusNota(NFeStatus.EM_DIGITACAO);
                    nfe.setChaveAcesso("");
                    nfe.setDigitoChaveAcesso("");
                    nfe.setXmlTxt(null);
                    nfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
                    throw new MaximaException("Nota Fiscal Eletr\u00f4nica REJEITADA.\nMotivo:" + retorno2.getMotivo());
                }
                System.out.println("--- protocolos: " + retorno2.getProtocolos().toString());
                String codigoRetorno = ((NFProtocolo)retorno2.getProtocolos().get(0)).getProtocoloInfo().getStatus();
                System.out.println(" --- codigo retorno: " + codigoRetorno);
                if (codigoRetorno.equals("100")) {
                    NFLoteEnvio lote = (NFLoteEnvio)new DFPersister().read(NFLoteEnvio.class, nfe.getXmlTxt());
                    if (lote == null) return nfe;
                    if (lote.getNotas().isEmpty()) return nfe;
                    NFNotaProcessada notaProcessada = new NFNotaProcessada();
                    notaProcessada.setVersao(new BigDecimal(NFeConfigMaxima.VERSAO_NFE));
                    notaProcessada.setProtocolo((NFProtocolo)retorno2.getProtocolos().get(0));
                    notaProcessada.setNota((NFNota)lote.getNotas().get(0));
                    nfe.setXmlTxt(notaProcessada.toString());
                    nfe.setStatusNota(NFeStatus.AUTORIZADA);
                    nfe.setnProt(((NFProtocolo)retorno2.getProtocolos().get(0)).getProtocoloInfo().getNumeroProtocolo());
                    nfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
                    NFeEvento evento = new NFeEvento();
                    evento.setCorrecao(null);
                    evento.setDataEvento(LocalDateTime.now());
                    evento.setMotivoCanc(null);
                    evento.setNfeCabecalho(nfe);
                    evento.setNumeroSeq(Integer.valueOf(0));
                    evento.setProtocolo(nfe.getnProt());
                    evento.setTipoEvento("Autorizacao");
                    this.nFeEventoRepository.save((Object)evento);
                    path = conf.getCaminhoNFe() + nfe.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
                    File diretorio = new File(path);
                    if (!diretorio.exists()) {
                        diretorio.mkdir();
                    }
                } else {
                    if (codigoRetorno.equals("204")) {
                        String[] numeroReciboAux = ((NFProtocolo)retorno2.getProtocolos().get(0)).getProtocoloInfo().getMotivo().split(":");
                        String numeroRecibo = numeroReciboAux[2].substring(0).replace("]", "");
                        System.out.println("---- numero recibo: " + numeroRecibo);
                        nfe.setRecibo(numeroRecibo);
                        nfe.setStatusNota(NFeStatus.ENVIADA);
                        nfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
                        throw new MaximaException("Nota Fiscal Eletr\u00f4nica ENVIADA para sefaz.\nEfetue a consulta atrav\u00e9s do bot\u00e3o consulta.");
                    }
                    nfe.setStatusNota(NFeStatus.EM_DIGITACAO);
                    nfe.setChaveAcesso("");
                    nfe.setDigitoChaveAcesso("");
                    nfe.setXmlTxt(null);
                    nfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
                    if (retorno2.getProtocolos() == null) throw new MaximaException("Nota Fiscal Eletr\u00f4nica REJEITADA.\nMotivo:" + retorno2.getMotivo());
                    if (retorno2.getProtocolos().size() <= 0) throw new MaximaException("Nota Fiscal Eletr\u00f4nica REJEITADA.\nMotivo:" + retorno2.getMotivo());
                    throw new MaximaException("Nota Fiscal Eletr\u00f4nica REJEITADA.\nMotivo:" + ((NFProtocolo)retorno2.getProtocolos().get(0)).getProtocoloInfo().getMotivo());
                }
                String caminhoArquivo = path + nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso() + "-NFe.xml";
                MaximaFile.escreveTexto((String)caminhoArquivo, (String)nfe.getXmlTxt());
                return nfe;
            }
            catch (IOException ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException("Servidor Sefaz NFE n\u00e3o encontrado.");
            }
            catch (Exception ex) {
                Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
                throw new MaximaException(ex.getMessage());
            }
        }
        nfe.setStatusNota(NFeStatus.EM_DIGITACAO);
        nfe.setChaveAcesso("");
        nfe.setDigitoChaveAcesso("");
        nfe.setXmlTxt(null);
        return (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NFeCabecalho cancela(NFeCabecalho nfe, String xmlCancelamentoAssinado, String motivo) throws MaximaException {
        try {
            Configuracao conf = this.configuracaoRepository.load();
            List eventos = this.nFeEventoRepository.lista(nfe.getId());
            Integer numeroSeq = 1;
            if (eventos != null) {
                numeroSeq = eventos.size();
            }
            NFeConfigMaxima config = new NFeConfigMaxima(conf);
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            NFEnviaEventoRetorno retorno = new WSFacade((NFeConfig)config).cancelaNotaAssinada(nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso(), xmlCancelamentoAssinado);
            if (retorno.getCodigoStatusReposta() != 128 && retorno.getCodigoStatusReposta() != 155) throw new MaximaException("AVISO: " + retorno.getMotivo());
            if (((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getCodigoStatus() != 135 && ((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getCodigoStatus() != 155 && ((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getCodigoStatus() != 151) throw new MaximaException("AVISO: " + ((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getMotivo());
            String protocolo = ((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getNumeroProtocolo();
            NFProtocoloEventoCancelamento procEvento = new NFProtocoloEventoCancelamento();
            procEvento.setEventoRetorno((NFEventoRetorno)retorno.getEventoRetorno().get(0));
            procEvento.setVersao("1.00");
            NFEnviaEventoCancelamento cancelamento = (NFEnviaEventoCancelamento)new DFPersister().read(NFEnviaEventoCancelamento.class, xmlCancelamentoAssinado);
            procEvento.setEvento((NFEventoCancelamento)cancelamento.getEvento().get(0));
            String xmlCancelamento = procEvento.toString();
            nfe.setStatusNota(NFeStatus.CANCELADA);
            nfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
            NFeEvento evento = new NFeEvento();
            evento.setDataEvento(LocalDateTime.now());
            evento.setMotivoCanc(motivo);
            evento.setNfeCabecalho(nfe);
            evento.setTipoEvento("Cancelamento");
            evento.setProtocolo(protocolo);
            evento.setXmlCancelamento(xmlCancelamento);
            this.nFeEventoRepository.save((Object)evento);
            String path = conf.getCaminhoNFe() + nfe.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
            File diretorio = new File(path);
            if (!diretorio.exists()) {
                diretorio.mkdir();
            }
            String caminhoArquivo = path + nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso() + "-Cancelamento.xml";
            MaximaFile.escreveTexto((String)caminhoArquivo, (String)xmlCancelamento);
            return nfe;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(NotaFiscalServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException(ex.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException(ex.getMessage());
        }
    }

    public NFeCabecalho correcao(NFeCabecalho nfe, String xmlCorrecaoAssinado, String motivo, Integer numeroEvento) throws MaximaException {
        try {
            String path;
            String xmlCorrecaoAutorizado;
            Configuracao conf = this.configuracaoRepository.load();
            NFeConfigMaxima config = new NFeConfigMaxima(conf);
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            NFEnviaEventoRetorno retorno = new WSFacade((NFeConfig)config).corrigeNotaAssinada(nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso(), xmlCorrecaoAssinado);
            System.out.println("********** Retorno carta de corre\u00e7\u00e3o: " + retorno);
            if (retorno.getCodigoStatusReposta() == 128) {
                if (((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getCodigoStatus() != 135) {
                    throw new MaximaException("AVISO: " + ((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getMotivo());
                }
                String protocolo = ((NFEventoRetorno)retorno.getEventoRetorno().get(0)).getInfoEventoRetorno().getNumeroProtocolo();
                NFProtocoloEvento procEvento = new NFProtocoloEvento();
                procEvento.setEventoRetorno((NFEventoRetorno)retorno.getEventoRetorno().get(0));
                procEvento.setVersao("1.00");
                NFEnviaEventoCartaCorrecao cancelamento = (NFEnviaEventoCartaCorrecao)new DFPersister().read(NFEnviaEventoCartaCorrecao.class, xmlCorrecaoAssinado);
                procEvento.setEvento((NFEvento)cancelamento.getEvento().get(0));
                xmlCorrecaoAutorizado = procEvento.toString();
                NFeEvento evento = new NFeEvento();
                evento.setDataEvento(LocalDateTime.now());
                evento.setMotivoCanc(motivo);
                evento.setNfeCabecalho(nfe);
                evento.setTipoEvento("Carta de Corre\u00e7\u00e3o");
                evento.setProtocolo(protocolo);
                evento.setXmlCancelamento(xmlCorrecaoAutorizado);
                this.nFeEventoRepository.save((Object)evento);
                path = conf.getCaminhoNFe() + nfe.getDataEmissao().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
                File diretorio = new File(path);
                if (!diretorio.exists()) {
                    diretorio.mkdir();
                }
            } else {
                throw new MaximaException("AVISO: " + retorno.getMotivo());
            }
            String caminhoArquivo = path + nfe.getChaveAcesso() + nfe.getDigitoChaveAcesso() + "-Correcao-" + numeroEvento + ".xml";
            MaximaFile.escreveTexto((String)caminhoArquivo, (String)xmlCorrecaoAutorizado);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(NotaFiscalServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException(ex.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException(ex.getMessage());
        }
        return nfe;
    }

    public void inutiliza(String xml) throws MaximaException {
        Configuracao conf = this.configuracaoRepository.load();
        String path = null;
        try {
            String diretorioRaiz = conf.getCaminhoNFe();
            path = diretorioRaiz + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM")) + "/";
            File diretorio = new File(path);
            if (!diretorio.exists()) {
                diretorio.mkdir();
            }
        }
        catch (Exception e) {
            throw new MaximaException("AVISO: Diret\u00f3rio para emiss\u00e3o de NF-e n\u00e3o configurado ou inexistente.");
        }
        String xmlRetorno = null;
        String protocolo = null;
        try {
            new MaximaCertificado().loadCertificado(conf.getAliasCertificado(), conf.getSenhaCertificado());
            NFRetornoEventoInutilizacao retorno = new WSFacade((NFeConfig)new NFeConfigMaxima(conf)).inutilizaNotaAssinada(xml, DFModelo.NFE);
            System.out.println("== retorno: " + retorno);
            if (retorno != null && retorno.getDados().getStatus().equals("102")) {
                NFeInutilizacao inut = new NFeInutilizacao();
                inut.setAno(retorno.getDados().getAno());
                inut.setNumero(retorno.getDados().getNumeroNFInicial());
                inut.setProtocolo(retorno.getDados().getNumeroProtocolo());
                inut.setSerie(retorno.getDados().getSerie());
                inut.setXml(retorno.toString());
                inut = (NFeInutilizacao)this.nFeInutilizacaoRepository.save((Object)inut);
                xmlRetorno = inut.getXml();
                protocolo = inut.getProtocolo();
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Erro: Falha ao inutilizar n\u00famero NFe.\n" + ex.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("Erro: Falha ao inutilizar n\u00famero NFe.\n" + ex.getMessage());
        }
        String caminhoArquivo = path + protocolo + "-Inut.xml";
        try {
            MaximaFile.escreveTexto((String)caminhoArquivo, xmlRetorno);
        }
        catch (IOException ex) {
            Logger.getLogger(NotaFiscalFormController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public NFeCabecalho salva(NFeCabecalho nfe, NFeEmitente emitente, NFeDestinatario destinatario, List<NFeDetalhe> produtos, List<NFeCobranca> cobrancas, List<NFeDocumento> documentos, NFeTransportadora transportadora, NFeVeiculo veiculo) throws MaximaValidacaoException {
        nfe.setDestinatario(destinatario.getRazaoSocial());
        nfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
        if (nfe.getFormaPagamento() != null) {
            nfe.setFaturaNumero(nfe.getNumero());
            BigDecimal desconto = BigDecimal.ZERO;
            if (nfe.getValorDesconto() != null && nfe.getValorDesconto().compareTo(BigDecimal.ZERO) > 0) {
                nfe.setFaturaValorDesconto(nfe.getValorDesconto());
                desconto = nfe.getValorDesconto();
            }
            nfe.setFaturaValorOriginal(nfe.getValorTotal().add(desconto));
            nfe.setFaturaValorLiquido(nfe.getValorTotal());
        }
        emitente.setNfeCabecalho(nfe);
        this.emitenteRepository.save((Object)emitente);
        destinatario.setNfeCabecalho(nfe);
        this.destinatarioRepository.save((Object)destinatario);
        if (transportadora != null) {
            transportadora.setNfeCabecalho(nfe);
            this.transportadoraRepository.save((Object)transportadora);
        }
        if (veiculo != null) {
            veiculo.setNfeCabecalho(nfe);
            this.veiculoRepository.save((Object)veiculo);
        }
        this.notaFiscalItemRepository.deleteItens(nfe.getId());
        for (NFeDetalhe item : produtos) {
            item.setNfeCabecalho(nfe);
            this.notaFiscalItemRepository.save((Object)item);
        }
        this.nFeCobrancaRepository.deleteItens(nfe.getId());
        if (cobrancas != null) {
            for (NFeCobranca cob : cobrancas) {
                cob.setId(null);
                cob.setNfeCabecalho(nfe);
                this.nFeCobrancaRepository.save((Object)cob);
            }
        }
        this.nFeDocumentoRepository.deleteItens(nfe.getId());
        if (documentos != null) {
            for (NFeDocumento doc : documentos) {
                doc.setId(null);
                doc.setNfeCabecalho(nfe);
                this.nFeDocumentoRepository.save((Object)doc);
            }
        }
        return nfe;
    }

    public NFeCabecalho importa(VendaProduto vendaProduto, List<VendaProdutoItem> itens) throws MaximaException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public NFeCabecalho atualiza(NFeCabecalho nfe) {
        return (NFeCabecalho)this.notaFiscalRepository.save((Object)nfe);
    }

    public void delete(NFeCabecalho nfe) throws MaximaValidacaoException {
        nfe = (NFeCabecalho)this.notaFiscalRepository.findById((Object)nfe.getId()).get();
        this.notaFiscalItemRepository.deleteItens(nfe.getId());
        this.destinatarioRepository.delete((Object)this.destinatarioRepository.get(nfe.getId()));
        this.emitenteRepository.delete((Object)this.emitenteRepository.get(nfe.getId()));
        this.nFeCobrancaRepository.deleteItens(nfe.getId());
        this.nFeDocumentoRepository.deleteItens(nfe.getId());
        this.notaFiscalRepository.delete((Object)nfe);
    }

    @Transactional(readOnly=true)
    public List<NFeDetalhe> listaProdutos(NFeCabecalho nFeCabecalho) {
        return this.notaFiscalItemRepository.listaProdutos(nFeCabecalho.getId());
    }

    @Transactional(readOnly=true)
    public List<NFeCobranca> listaCobrancas(NFeCabecalho nFeCabecalho) {
        return this.nFeCobrancaRepository.list(nFeCabecalho.getId());
    }

    @Transactional(readOnly=true)
    public List<NFeDocumento> listaDocumentos(NFeCabecalho nFeCabecalho) {
        return this.nFeDocumentoRepository.list(nFeCabecalho.getId());
    }

    @Transactional(readOnly=true)
    public List<NFeEvento> listaEventos(NFeCabecalho nFeCabecalho) {
        return this.nFeEventoRepository.lista(nFeCabecalho.getId());
    }

    @Transactional(readOnly=true)
    public NFeEmitente getEmitente(NFeCabecalho nfe) {
        return this.emitenteRepository.get(nfe.getId());
    }

    @Transactional(readOnly=true)
    public NFeDestinatario getDestinatario(NFeCabecalho nfe) {
        return this.destinatarioRepository.get(nfe.getId());
    }

    @Transactional(readOnly=true)
    public NFeTransportadora getTransportadora(NFeCabecalho nfe) {
        return this.transportadoraRepository.get(nfe.getId());
    }

    @Transactional(readOnly=true)
    public NFeVeiculo getVeiculo(NFeCabecalho nfe) {
        return this.veiculoRepository.get(nfe.getId());
    }

    @Transactional(readOnly=true)
    public NFeCabecalho getById(Long id) throws MaximaValidacaoException {
        Optional nfe = this.notaFiscalRepository.findById((Object)id);
        if (nfe.isPresent()) {
            return (NFeCabecalho)nfe.get();
        }
        throw new MaximaValidacaoException("NF-e n\u00e3o encontrada.");
    }

    @Transactional(readOnly=true)
    public Integer getProximoNumero(String serie) throws MaximaValidacaoException {
        try {
            Integer numeroSerie = Integer.valueOf(serie);
            List numero = this.notaFiscalRepository.getUltimoNumero(numeroSerie, (Pageable)PageRequest.of((int)0, (int)1));
            if (numero == null || numero.isEmpty()) {
                return 1;
            }
            return Integer.parseInt((String)numero.get(0)) + 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new MaximaValidacaoException("ERRO: N\u00famero de s\u00e9rie inv\u00e1lido.");
        }
    }

    @Transactional(readOnly=true)
    public List<NFeCabecalho> lista(LocalDate inicio, LocalDate fim, String filtro) {
        return this.notaFiscalRepository.lista(inicio, fim, "%" + filtro + "%");
    }

    @Transactional(readOnly=true)
    public BigDecimal total(LocalDate inicio, LocalDate fim, String filtro) {
        BigDecimal total = this.notaFiscalRepository.total(inicio, fim, "%" + filtro + "%");
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    @Transactional(readOnly=true)
    public List<NFeCabecalho> listaSped(LocalDate inicio, LocalDate fim, NFTipo tipoOperacao) {
        return this.notaFiscalRepository.listaSped(inicio, fim, NFeStatus.AUTORIZADA, tipoOperacao);
    }

    @Transactional(readOnly=true)
    public List<Cliente> listaSpedClientes(LocalDate inicio, LocalDate fim) {
        return this.notaFiscalRepository.listaSpedClientes(inicio, fim, NFeStatus.AUTORIZADA);
    }

    @Transactional(readOnly=true)
    public List<String> listaSpedTipoUnidade(LocalDate inicio, LocalDate fim) {
        return this.notaFiscalItemRepository.listaTipoUnidade(inicio, fim, NFeStatus.AUTORIZADA);
    }

    @Transactional(readOnly=true)
    public List<Produto> listaSpedProduto(LocalDate inicio, LocalDate fim) {
        return this.notaFiscalItemRepository.listaProduto(inicio, fim, NFeStatus.AUTORIZADA);
    }

    @Transactional(readOnly=true)
    public List<BlocoCRegistro190> listaSpedRegistro190(NFeCabecalho nfe, NFTipo tipoOperacao) {
        List lista = this.notaFiscalItemRepository.listaSpedRegistro190(nfe.getId());
        ArrayList<BlocoCRegistro190> retorno = new ArrayList<BlocoCRegistro190>();
        int cont = 0;
        for (Object[] obj : lista) {
            String cfop;
            BlocoCRegistro190 c190 = new BlocoCRegistro190();
            c190.setCst((String)obj[0]);
            c190.setCfop(String.valueOf((Integer)obj[1]));
            if ((c190.getCst() == null || c190.getCst().isEmpty()) && ((cfop = c190.getCfop()).startsWith("51") || cfop.startsWith("61"))) {
                c190.setCst("00");
            }
            c190.setAliquotaIcms((BigDecimal)obj[2]);
            c190.setValorOperacao((BigDecimal)obj[3]);
            c190.setBaseCalculoIcms((BigDecimal)obj[4]);
            c190.setValorIcms((BigDecimal)obj[5]);
            c190.setBaseCalculoIcmsST((BigDecimal)obj[6]);
            c190.setValorIcmsST((BigDecimal)obj[7]);
            c190.setReducaoBaseCalculo((BigDecimal)obj[8]);
            c190.setValorIpi((BigDecimal)obj[9]);
            retorno.add(c190);
        }
        if (cont > 0) {
            System.out.println("Itens cst sem valor: " + cont);
        }
        return retorno;
    }

    @Transactional(readOnly=true)
    public BigDecimal valorNotasSped(LocalDate inicio, LocalDate fim, NFTipo tipoOperacao) {
        BigDecimal valorNota = this.notaFiscalRepository.valorNotasSped(inicio, fim, NFeStatus.AUTORIZADA, tipoOperacao);
        if (valorNota == null) {
            valorNota = BigDecimal.ZERO;
        }
        return valorNota;
    }

    @Transactional(readOnly=true)
    public BigDecimal valorIcmsSped(LocalDate inicio, LocalDate fim, NFTipo tipoOperacao) {
        BigDecimal valorIcms = this.notaFiscalRepository.valorIcmsSped(inicio, fim, NFeStatus.AUTORIZADA, tipoOperacao);
        if (valorIcms == null) {
            valorIcms = BigDecimal.ZERO;
        }
        return valorIcms;
    }

    @Transactional(readOnly=true)
    public BigDecimal valorIcmsStSped(LocalDate inicio, LocalDate fim, NFTipo tipoOperacao) {
        BigDecimal valorIcmsSt = this.notaFiscalRepository.valorIcmsStSped(inicio, fim, NFeStatus.AUTORIZADA, tipoOperacao);
        if (valorIcmsSt == null) {
            valorIcmsSt = BigDecimal.ZERO;
        }
        return valorIcmsSt;
    }

    @Transactional(readOnly=true)
    public BigDecimal valorUfIcmsStSped(LocalDate inicio, LocalDate fim, String uf, NFTipo tipoOperacao) {
        BigDecimal valorUfIcmsSt = this.notaFiscalRepository.valorUfIcmsStSped(inicio, fim, uf, NFeStatus.AUTORIZADA, tipoOperacao);
        if (valorUfIcmsSt == null) {
            valorUfIcmsSt = BigDecimal.ZERO;
        }
        return valorUfIcmsSt;
    }

    @Transactional(readOnly=true)
    public List<Estado> listaUfIcmsStSped(LocalDate inicio, LocalDate fim) {
        return this.notaFiscalRepository.listaUfIcmsStSped(inicio, fim, NFeStatus.AUTORIZADA);
    }

    @Transactional(readOnly=true)
    public List<NFeCabecalho> relatorio(LocalDate inicio, LocalDate fim, Long clienteId) {
        if (clienteId == null) {
            return this.notaFiscalRepository.relatorio(inicio, fim);
        }
        return this.notaFiscalRepository.relatorio(inicio, fim, clienteId);
    }

    @Transactional(readOnly=true)
    public List<NFeDetalhe> relatorioProdutosMonofasicos(LocalDate inicio, LocalDate fim) {
        return this.notaFiscalItemRepository.monofasicos(inicio, fim, NFeStatus.AUTORIZADA, NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO.getCodigo(), NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_MONOFASICA_ALIQUOTA_ZERO.getCodigo());
    }

    @Transactional(readOnly=true)
    public List<RelatorioFiscalProdutoBean> relatorioProdutos(LocalDate inicio, LocalDate fim, Boolean agruparProdutos) {
        List lista = agruparProdutos != false ? this.notaFiscalItemRepository.relatorioArupadoBean(inicio, fim, NFeStatus.AUTORIZADA) : this.notaFiscalItemRepository.relatorioBean(inicio, fim, NFeStatus.AUTORIZADA);
        ArrayList<RelatorioFiscalProdutoBean> retorno = new ArrayList<RelatorioFiscalProdutoBean>();
        for (Object[] obj : lista) {
            RelatorioFiscalProdutoBean bean = new RelatorioFiscalProdutoBean();
            bean.setProduto((String)obj[0]);
            bean.setQuantidade(new BigDecimal(obj[1].toString()));
            bean.setCusto(new BigDecimal(obj[2].toString()));
            bean.setTotal(new BigDecimal(obj[3].toString()));
            if (!agruparProdutos.booleanValue()) {
                LocalDate dataEmissao = (LocalDate)obj[4];
                bean.setData(dataEmissao.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
                bean.setNota((String)obj[5]);
            } else {
                bean.setData("---");
                bean.setNota("---");
            }
            retorno.add(bean);
        }
        return retorno;
    }

    public NFeCabecalho duplica(NFeCabecalho nfe) throws MaximaException {
        NFeDestinatario destinatario;
        Long nfeId = nfe.getId();
        NFeCabecalho novaNfe = nfe;
        novaNfe.setId(null);
        novaNfe = (NFeCabecalho)this.notaFiscalRepository.save((Object)novaNfe);
        System.out.println("---- nfe id: " + nfeId);
        NFeDestinatario novoDest = destinatario = this.destinatarioRepository.get(nfeId);
        System.out.println("--- novoDEst " + novoDest);
        novoDest.setId(null);
        novoDest.setNfeCabecalho(nfe);
        this.destinatarioRepository.save((Object)novoDest);
        NFeEmitente novoEmit = this.emitenteRepository.get(nfeId);
        novoEmit.setId(null);
        novoEmit.setNfeCabecalho(null);
        this.emitenteRepository.save((Object)novoEmit);
        List detalhes = this.notaFiscalItemRepository.listaProdutos(nfeId);
        Iterator iterator = detalhes.iterator();
        while (iterator.hasNext()) {
            NFeDetalhe det;
            NFeDetalhe novoItem = det = (NFeDetalhe)iterator.next();
            novoItem.setId(null);
            novoItem.setNfeCabecalho(novaNfe);
            this.notaFiscalItemRepository.save((Object)novoItem);
        }
        return novaNfe;
    }
}

