/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.controller;

import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaMask;
import java.net.URL;
import java.time.LocalDate;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CFeSATExportaController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfDataInicial;
    @FXML
    private TextField tfDataFinal;
    @FXML
    private Button btnSalva;
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private SatCFeService satCFeService;
    @Autowired
    private ConfiguracaoService configuracaoService;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaMascaras();
        this.carregaCombos();
    }

    public void inicializa() {
    }

    private void salva() {
        if (!this.validaForm()) {
            return;
        }
        try {
            this.satCFeService.exporta(MaximaDate.convertToLocalDate((String)this.tfDataInicial.getText()), MaximaDate.convertToLocalDate((String)this.tfDataFinal.getText()), this.configuracaoService.load().getCaminhoSAT());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Arquivos exportados com sucesso.");
            Stage form = (Stage)this.btnSalva.getScene().getWindow();
            form.close();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(CFeSATExportaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao exportar os arquivos.");
        }
    }

    private void carregaMascaras() {
        MaximaMask.dateField((TextField)this.tfDataInicial);
        MaximaMask.dateField((TextField)this.tfDataFinal);
    }

    private boolean validaForm() {
        boolean valido = true;
        LocalDate dataInicial = MaximaDate.convertToLocalDate((String)this.tfDataInicial.getText());
        LocalDate dataFinal = MaximaDate.convertToLocalDate((String)this.tfDataFinal.getText());
        if (dataInicial == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (dataFinal == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (dataInicial.isAfter(dataFinal)) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void carregaCombos() {
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

