/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.controller.VendaProdutoController;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.fiscal.controller.CPFFormController;
import br.com.maximasolutions.fiscal.service.NcmService;
import br.com.maximasolutions.sat.controller.SATController;
import br.com.maximasolutions.sat.controller.SatEnviaController;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.sat.modelo.SatCFe;
import br.com.maximasolutions.sat.modelo.SatCFeItem;
import br.com.maximasolutions.sat.modelo.SatCFePagamento;
import br.com.maximasolutions.sat.modelo.SatCFeXml;
import br.com.maximasolutions.sat.print.SatImpressaoController;
import br.com.maximasolutions.sat.service.SatCFeService;
import br.com.maximasolutions.sat.xml.modelo.CFe;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Controller
public class CupomSatFechamentoFormController
extends MaximaController
implements Initializable {
    @FXML
    private ComboBox<CondicaoRecebimento> cbbCondicaoPagamento;
    @FXML
    private TextField tfTotal;
    @FXML
    private TextField tfValorRecebido;
    @FXML
    private Label lbComanda;
    @FXML
    private Button btnFinalizar;
    private List<SatCFeItem> satCFeItems;
    @Autowired
    private CondicaoRecebimentoService condicaoPagamentoService;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private NcmService ncmService;
    @Autowired
    private SatCFeService satCFeService;
    private Configuracao conf;
    private ControleSAT controleSAT;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.setMascaras();
        this.loadCombos();
    }

    public void inicializa(ControleSAT controleSAT, Configuracao conf1, List<SatCFeItem> itens) {
        this.controleSAT = controleSAT;
        this.conf = conf1;
        this.satCFeItems = itens;
        BigDecimal totalCupom = BigDecimal.ZERO;
        for (SatCFeItem i : this.satCFeItems) {
            totalCupom = totalCupom.add(i.getValorTotalItem());
        }
        this.tfValorRecebido.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalCupom, (int)2));
        this.tfTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)totalCupom, (int)2));
        this.lbComanda.setAlignment(Pos.CENTER);
        this.cbbCondicaoPagamento.requestFocus();
    }

    private void finalizarComanda() {
        CondicaoRecebimento condicaoPagamento = (CondicaoRecebimento)this.cbbCondicaoPagamento.getSelectionModel().getSelectedItem();
        BigDecimal valorRecebido = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebido.getText());
        if (condicaoPagamento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione a condi\u00e7\u00e3o de pagamento.");
            return;
        }
        String nome = "";
        String cpf = "";
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/CPFForm.fxml", "CPF ou CNPJ");
            CPFFormController controller = (CPFFormController)stage.getUserData();
            stage.showAndWait();
            if (!controller.isFinalizado()) {
                return;
            }
            nome = controller.getNome();
            cpf = controller.getCpf();
        }
        catch (IOException ex) {
            Logger.getLogger(VendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir janela de CPF ou CNPJ.");
            return;
        }
        SatCFe cupom = new SatCFe();
        cupom.setAvulso(Boolean.TRUE);
        cupom.setCancelado(Boolean.FALSE);
        cupom.setCnpjEmitente(this.conf.getEmpresaNFe().getCpf());
        cupom.setCnpjSoftwareHouse(this.conf.getSatCnpjSoftwareHouse());
        cupom.setChaveAssinada(this.conf.getSatChaveAssinada());
        cupom.setIeEmitente(this.conf.getEmpresaNFe().getRg());
        cupom.setNumeroCaixa("001");
        SatCFePagamento pgto = new SatCFePagamento();
        pgto.setCfe(cupom);
        pgto.setFormaPagamento(condicaoPagamento.getFormaPagamento());
        pgto.setValor(valorRecebido);
        ArrayList<SatCFePagamento> satCFePagamentos = new ArrayList<SatCFePagamento>();
        satCFePagamentos.add(pgto);
        try {
            String xmlEnvio = SatEnviaController.convertCupomAvulsoToXmlCupom((NcmService)this.ncmService, (SatCFe)cupom, (List)this.satCFeItems, satCFePagamentos, (Configuracao)this.conf, (String)cupom.getNumeroCaixa(), (String)cpf, (String)nome);
            String xmlCupomEmitido = new SATController(this.controleSAT, this.conf).emiteCupom(xmlEnvio);
            byte[] arquivoCupom = SatEnviaController.tratarResultadoVenda((String)xmlCupomEmitido, (Configuracao)this.conf);
            SatCFeXml satCFeXml = new SatCFeXml();
            if (arquivoCupom != null) {
                satCFeXml.setArquivo(arquivoCupom);
            }
            String xmlCupom = ControleArquivos.lerBytesArquivo((String)"C:/Maxima/ultimoCupom.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlCupom.getBytes());
            Document doc = db.parse(is);
            NodeList raizes = doc.getChildNodes();
            org.w3c.dom.Node raiz = raizes.item(0);
            CFe xmlCFe = new CFe(raiz);
            SatCFe satCFe = this.satCFeService.getSatCfeXmlCupom(xmlCFe);
            List itens = this.satCFeService.getSatCfeItemXmlCupom(xmlCFe);
            List parcelas = this.satCFeService.getSatCfePagamento(xmlCFe);
            satCFe = this.satCFeService.salvaCupom(satCFe, itens, parcelas, satCFeXml, null);
            SatImpressaoController.imprimeCupom((byte[])arquivoCupom, (Configuracao)this.conf, (SatCFe)satCFe);
            this.fechaForm();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(CupomSatFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
        catch (Exception ex) {
            Logger.getLogger(CupomSatFechamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao emitir o Cupom Fiscal SAT.\n" + ex.getMessage()));
        }
    }

    public void loadMesaAberta() {
    }

    private void carregaIcones() {
        this.btnFinalizar.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnFinalizar.setOnAction(event -> this.finalizarComanda());
        this.cbbCondicaoPagamento.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.tfValorRecebido.selectAll();
                this.tfValorRecebido.requestFocus();
            }
        });
        this.tfValorRecebido.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.finalizarComanda();
            }
        });
    }

    private void setMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValorRecebido);
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnFinalizar.getScene().getWindow();
        stage.close();
    }

    private void loadCombos() {
        this.cbbCondicaoPagamento.setItems(FXCollections.observableArrayList((Collection)this.condicaoPagamentoService.list()));
    }
}

