/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.sat.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaResposta;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.sat.controller.SatComunicacaoController;
import br.com.maximasolutions.sat.core.ControleArquivos;
import br.com.maximasolutions.sat.core.ControleSAT;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SATController {
    private final ControleSAT controleSAT;
    private final Configuracao conf;

    public SATController(ControleSAT controleSAT, Configuracao conf) {
        this.controleSAT = controleSAT;
        this.conf = conf;
    }

    public boolean consultaSat() {
        MaximaResposta resposta = new SatComunicacaoController(this.controleSAT, this.conf).comunicaAplicativo();
        return resposta.getSucesso();
    }

    public String emiteCupom(String xmlCupom) throws Exception {
        try {
            xmlCupom = xmlCupom.replace("&", "-").replace("\u00b0", "\u00ba");
            ControleArquivos.escreverBytesArquivo((String)"C:/Maxima/xml_enviado_sat.txt", (byte[])xmlCupom.getBytes());
            System.out.println("----- teste cupom: " + this.controleSAT);
            return this.controleSAT.processarComandoEmitirCFe(this.conf.getSatSenha().trim(), xmlCupom);
        }
        catch (Exception e) {
            Logger.getLogger(SATController.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaValidacaoException(e.getMessage());
        }
    }

    public String cancelaCupom(String xmlCancelamento, String chaveAcesso) throws Exception {
        try {
            return this.controleSAT.processarComandoCancelarCFe(this.conf.getSatSenha().trim(), chaveAcesso, xmlCancelamento);
        }
        catch (Exception e) {
            Logger.getLogger(SATController.class.getSimpleName()).log(Level.SEVERE, null, e);
            throw new MaximaValidacaoException(e.getMessage());
        }
    }
}

